/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.task.CfReprocessingTask;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.service.cf.AbstractCalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldReprocessingService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.DefaultCalculatedFieldReprocessingService;
import org.thingsboard.server.service.cf.PropagationCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;
import org.thingsboard.server.utils.CalculatedFieldArgumentUtils;

@Service
public class DefaultCalculatedFieldReprocessingService
extends AbstractCalculatedFieldProcessingService
implements CalculatedFieldReprocessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCalculatedFieldReprocessingService.class);
    private static final Set<EntityType> supportedReprocessingEntities = EnumSet.of(EntityType.DEVICE, EntityType.ASSET);
    @Value(value="${actors.calculated_fields.calculation_timeout:5}")
    private long cfCalculationResultTimeout;
    @Value(value="${queue.calculated_fields.telemetry_fetch_pack_size:2000}")
    private int telemetryFetchPackSize;
    private final ActorSystemContext systemContext;

    public DefaultCalculatedFieldReprocessingService(AttributesService attributesService, TimeseriesService timeseriesService, ApiLimitService apiLimitService, RelationService relationService, OwnersCacheService ownersService, TbClusterService clusterService, ActorSystemContext systemContext, TelemetrySubscriptionService tsSubService) {
        super(attributesService, timeseriesService, tsSubService, apiLimitService, relationService, ownersService, clusterService);
        this.systemContext = systemContext;
    }

    protected String getExecutorNamePrefix() {
        return "calculated-field-reprocessing-callback";
    }

    public void reprocess(CfReprocessingTask task) throws Exception {
        CFReprocessingCtx ctx;
        TenantId tenantId = task.getTenantId();
        EntityId entityId = task.getEntityId();
        log.debug("[{}] Received reprocessing request: {}", (Object)tenantId, (Object)task);
        if (!supportedReprocessingEntities.contains(entityId.getEntityType())) {
            throw new IllegalArgumentException("EntityType '" + String.valueOf(entityId.getEntityType()) + "' is not supported for reprocessing");
        }
        CalculatedField calculatedField = task.getCalculatedField();
        if (calculatedField.getType() == CalculatedFieldType.ALARM) {
            throw new IllegalArgumentException("Reprocessing not applicable for this type");
        }
        if (OutputType.ATTRIBUTES.equals((Object)calculatedField.getConfiguration().getOutput().getType())) {
            throw new IllegalArgumentException("'ATTRIBUTES' output type is not supported for reprocessing");
        }
        long startTs = task.getStartTs();
        long endTs = task.getEndTs();
        CalculatedFieldCtx cfCtx = new CalculatedFieldCtx(calculatedField, this.systemContext);
        cfCtx.setUseLatestTs(false);
        cfCtx.init();
        CalculatedFieldState state = this.initState(tenantId, entityId, cfCtx, startTs);
        try (CFReprocessingCtx cFReprocessingCtx = ctx = this.buildCtx(tenantId, entityId, cfCtx, state);){
            ctx.checkStateSize();
            ctx.processInitialState(startTs);
            ctx.prepareCtx(startTs, endTs);
            ctx.processData(startTs, endTs);
            ctx.awaitResults();
            ctx.validateTaskResult();
        }
    }

    private Future<Void> processStateIfReady(CFReprocessingCtx ctx, long ts) throws Exception {
        CalculatedFieldState state = ctx.getState();
        boolean initialized = ctx.getCfCtx().isInitialized();
        if (initialized && state.isReady()) {
            log.trace("[{}][{}] Performing calculation for CF {}", new Object[]{ctx.getTenantId(), ctx.getEntityId(), ctx.getCfId()});
            CalculatedFieldResult calculationResult = (CalculatedFieldResult)ctx.performCalculation(state).get(this.cfCalculationResultTimeout, TimeUnit.SECONDS);
            ctx.checkStateSize();
            if (!calculationResult.isEmpty()) {
                ctx.setLatestResult(new TbPair((Object)ts, (Object)calculationResult));
                return this.saveResult(ctx, calculationResult, ts, TimeseriesSaveRequest.Strategy.TIME_SERIES_ONLY);
            }
        } else {
            if (log.isTraceEnabled()) {
                if (!initialized) {
                    log.trace("[{}][{}] Calculated field state is not initialized! {}", new Object[]{ctx.getTenantId(), ctx.getEntityId(), ctx.getCfId()});
                }
                if (!state.isReady()) {
                    log.trace("[{}][{}] Calculated field state is not ready! {}, {}", new Object[]{ctx.getTenantId(), ctx.getEntityId(), ctx.getCfId(), state.getReadinessStatus().errorMsg()});
                }
            }
            ctx.checkStateSize();
        }
        return Futures.immediateVoidFuture();
    }

    private Future<Void> processArgumentValuesUpdate(CFReprocessingCtx ctx, Map<String, ArgumentEntry> newArgValues, long ts) throws Exception {
        if (newArgValues.isEmpty()) {
            log.info("[{}] No argument values to process for CF.", (Object)ctx.getCfId());
        }
        if (!ctx.getState().update(newArgValues, ctx.getCfCtx()).isEmpty()) {
            return this.processStateIfReady(ctx, ts);
        }
        return Futures.immediateVoidFuture();
    }

    private CalculatedFieldState initState(TenantId tenantId, EntityId entityId, CalculatedFieldCtx ctx, long startTs) throws InterruptedException {
        Map arguments;
        CalculatedFieldState state = CalculatedFieldArgumentUtils.createStateByType((CalculatedFieldCtx)ctx, (EntityId)entityId);
        state.setCtx(ctx, null);
        state.init(false);
        if (CalculatedFieldType.ENTITY_AGGREGATION.equals((Object)ctx.getCfType())) {
            return state;
        }
        try {
            arguments = (Map)this.fetchArguments(ctx, entityId, startTs).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new RuntimeException(cause.getMessage(), cause);
        }
        state.update(arguments, ctx);
        log.debug("[{}][{}] Initialized state for CF {}", new Object[]{tenantId, entityId, ctx.getCfId()});
        return state;
    }

    protected List<ListenableFuture<Map.Entry<EntityId, AttributeKvEntry>>> fetchGeofencingEntityIdToKvEntriesFutures(TenantId tenantId, List<EntityId> geofencingEntities, Argument argument, long reprocessingStartTs) {
        return geofencingEntities.stream().map(entityId -> {
            AttributeScope scope = argument.getRefEntityKey().getScope();
            String key = argument.getRefEntityKey().getKey();
            ListenableFuture attributesFuture = this.attributesService.find(tenantId, entityId, scope, key);
            return Futures.transform((ListenableFuture)attributesFuture, resultOpt -> {
                BaseAttributeKvEntry attributeKvEntry = resultOpt.isEmpty() ? CalculatedFieldArgumentUtils.createDefaultAttributeEntry((Argument)argument, (long)reprocessingStartTs) : new BaseAttributeKvEntry((KvEntry)resultOpt.get(), reprocessingStartTs, ((AttributeKvEntry)resultOpt.get()).getVersion());
                return Map.entry(entityId, attributeKvEntry);
            }, (Executor)this.calculatedFieldCallbackExecutor);
        }).collect(Collectors.toList());
    }

    protected ListenableFuture<ArgumentEntry> fetchAttribute(TenantId tenantId, EntityId entityId, Argument argument, long reprocessingStartTs) {
        log.trace("[{}][{}] Fetching attribute for key {}", new Object[]{tenantId, entityId, argument.getRefEntityKey()});
        ListenableFuture attributeOptFuture = this.attributesService.find(tenantId, entityId, argument.getRefEntityKey().getScope(), argument.getRefEntityKey().getKey());
        return Futures.transform((ListenableFuture)attributeOptFuture, attrOpt -> {
            log.debug("[{}][{}] Fetched attribute for key {}: {}", new Object[]{tenantId, entityId, argument.getRefEntityKey(), attrOpt});
            BaseAttributeKvEntry attributeKvEntry = attrOpt.isEmpty() ? CalculatedFieldArgumentUtils.createDefaultAttributeEntry((Argument)argument, (long)reprocessingStartTs) : new BaseAttributeKvEntry((KvEntry)attrOpt.get(), reprocessingStartTs, ((AttributeKvEntry)attrOpt.get()).getVersion());
            return CalculatedFieldArgumentUtils.transformSingleValueArgument((KvEntry)attributeKvEntry);
        }, (Executor)this.calculatedFieldCallbackExecutor);
    }

    protected ListenableFuture<ArgumentEntry> fetchTsLatest(TenantId tenantId, EntityId entityId, Argument argument, long reprocessingStartTs) {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(argument.getRefEntityKey().getKey(), 0L, reprocessingStartTs, 0L, 1, Aggregation.NONE);
        log.trace("[{}][{}] Fetching timeseries for latest for query {}", new Object[]{tenantId, entityId, query});
        ListenableFuture tsKvListFuture = this.timeseriesService.findAll(tenantId, entityId, List.of(query));
        return Futures.transform((ListenableFuture)tsKvListFuture, arg_0 -> DefaultCalculatedFieldReprocessingService.lambda$fetchTsLatest$3(tenantId, entityId, (ReadTsKvQuery)query, argument, reprocessingStartTs, arg_0), (Executor)this.calculatedFieldCallbackExecutor);
    }

    private List<TsKvEntry> fetchTelemetryBatch(TenantId tenantId, EntityId entityId, Argument argument, long startTs, long endTs, int limit) throws InterruptedException {
        List result;
        EntityId sourceEntityId = this.resolveEntityId(tenantId, entityId, argument);
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(argument.getRefEntityKey().getKey(), startTs, endTs, 0L, limit, Aggregation.NONE, "ASC");
        log.trace("[{}][{}] Fetching telemetry batch for query {}", new Object[]{tenantId, entityId, query});
        try {
            result = (List)this.timeseriesService.findAll(tenantId, sourceEntityId, List.of(query)).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to fetch telemetry for " + String.valueOf(sourceEntityId) + " for key " + argument.getRefEntityKey().getKey() + ": " + e.getCause().getMessage(), e.getCause());
        }
        log.debug("[{}][{}] Fetched {} timeseries for query {}", new Object[]{tenantId, entityId, result.size(), query});
        return result;
    }

    private Future<Void> saveResult(CFReprocessingCtx ctx, CalculatedFieldResult calculatedFieldResult, long ts, TimeseriesSaveRequest.Strategy strategy) {
        SettableFuture future = SettableFuture.create();
        if (calculatedFieldResult instanceof PropagationCalculatedFieldResult) {
            PropagationCalculatedFieldResult propagationResult = (PropagationCalculatedFieldResult)calculatedFieldResult;
            TbCallback rootCallback = TbCallback.wrap((SettableFuture)future);
            this.handlePropagationResults(propagationResult, rootCallback, (entityId, res, cb) -> this.saveReprocessingTimeSeriesResult(ctx.getTenantId(), entityId, res.toJsonElement(), ts, strategy, cb));
        } else {
            this.saveReprocessingTimeSeriesResult(ctx.getTenantId(), ctx.getEntityId(), calculatedFieldResult.toJsonElement(), ts, strategy, TbCallback.wrap((SettableFuture)future));
        }
        return future;
    }

    private CFReprocessingCtx buildCtx(TenantId tenantId, EntityId entityId, CalculatedFieldCtx cfCtx, CalculatedFieldState state) {
        if (CalculatedFieldType.RELATED_ENTITIES_AGGREGATION.equals((Object)cfCtx.getCfType())) {
            return new RelatedEntitiesCfReprocessingCtx(this, tenantId, entityId, cfCtx, state);
        }
        if (CalculatedFieldType.ENTITY_AGGREGATION.equals((Object)cfCtx.getCfType())) {
            return new EntityAggCfReprocessingCtx(this, tenantId, entityId, cfCtx, state);
        }
        return new SimpleCfReprocessingCtx(this, tenantId, entityId, cfCtx, state);
    }

    private static /* synthetic */ ArgumentEntry lambda$fetchTsLatest$3(TenantId tenantId, EntityId entityId, ReadTsKvQuery query, Argument argument, long reprocessingStartTs, List tsKvList) {
        log.debug("[{}][{}] Fetched timeseries for latest for query {}: {}", new Object[]{tenantId, entityId, query, tsKvList});
        boolean noValidEntry = tsKvList.isEmpty() || tsKvList.get(0) == null || ((TsKvEntry)tsKvList.get(0)).getValue() == null;
        TsKvEntry tsKvEntry = noValidEntry ? CalculatedFieldArgumentUtils.createDefaultTsKvEntry((Argument)argument, (long)reprocessingStartTs) : (TsKvEntry)tsKvList.get(0);
        return CalculatedFieldArgumentUtils.transformSingleValueArgument((KvEntry)tsKvEntry);
    }
}

