/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.MultipleTbCallback;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggMetric;
import org.thingsboard.server.common.data.cf.configuration.aggregation.RelatedEntitiesAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.service.cf.AbstractCalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.AlarmCalculatedFieldResult;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.DefaultCalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.PropagationCalculatedFieldResult;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntry;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationArgumentEntry;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;
import org.thingsboard.server.utils.CalculatedFieldUtils;

@Service
public class DefaultCalculatedFieldProcessingService
extends AbstractCalculatedFieldProcessingService
implements CalculatedFieldProcessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCalculatedFieldProcessingService.class);
    private final PartitionService partitionService;

    public DefaultCalculatedFieldProcessingService(AttributesService attributesService, TimeseriesService timeseriesService, ApiLimitService apiLimitService, RelationService relationService, OwnersCacheService ownerService, TbClusterService clusterService, TelemetrySubscriptionService tsSubService, PartitionService partitionService) {
        super(attributesService, timeseriesService, tsSubService, apiLimitService, relationService, ownerService, clusterService);
        this.partitionService = partitionService;
    }

    protected String getExecutorNamePrefix() {
        return "calculated-field-callback";
    }

    public ListenableFuture<Map<String, ArgumentEntry>> fetchArguments(CalculatedFieldCtx ctx, EntityId entityId) {
        return super.fetchArguments(ctx, entityId, System.currentTimeMillis());
    }

    public Map<String, ArgumentEntry> fetchDynamicArgsFromDb(CalculatedFieldCtx ctx, EntityId entityId) {
        return ctx.getCfType() == CalculatedFieldType.GEOFENCING ? this.resolveArgumentFutures(this.fetchGeofencingCalculatedFieldArguments(ctx, entityId, true, System.currentTimeMillis())) : Collections.emptyMap();
    }

    public Optional<PropagationArgumentEntry> fetchPropagationArgumentFromDb(CalculatedFieldCtx ctx, EntityId entityId) {
        if (ctx.getCfType() != CalculatedFieldType.PROPAGATION) {
            return Optional.empty();
        }
        return Optional.of((PropagationArgumentEntry)this.resolveArgumentValue("propagationCtx", this.fetchPropagationCalculatedFieldArgument(ctx, entityId)));
    }

    public List<EntityId> fetchRelatedEntities(CalculatedFieldCtx ctx, EntityId entityId) {
        try {
            CalculatedFieldConfiguration calculatedFieldConfiguration = ctx.getCalculatedField().getConfiguration();
            if (calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration) {
                RelatedEntitiesAggregationCalculatedFieldConfiguration config = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration;
                return (List)this.resolveRelatedEntities(ctx.getTenantId(), entityId, config.getRelation()).get();
            }
            return Collections.emptyList();
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause = e.getCause();
            throw new RuntimeException("Failed to fetch related entities for entity [" + String.valueOf(entityId) + "]: " + cause.getMessage(), cause);
        }
    }

    public Map<String, ArgumentEntry> fetchArgsFromDb(TenantId tenantId, EntityId entityId, Map<String, Argument> arguments) {
        HashMap<String, ListenableFuture> argFutures = new HashMap<String, ListenableFuture>();
        for (Map.Entry<String, Argument> entry : arguments.entrySet()) {
            if (entry.getValue().hasRelationQuerySource()) continue;
            EntityId argEntityId = this.resolveEntityId(tenantId, entityId, entry.getValue());
            ListenableFuture argValueFuture = this.fetchArgumentValue(tenantId, argEntityId, entry.getValue(), System.currentTimeMillis());
            argFutures.put(entry.getKey(), argValueFuture);
        }
        return this.resolveArgumentFutures(argFutures);
    }

    public ArgumentEntry fetchMetricDuringInterval(TenantId tenantId, EntityId entityId, String argKey, AggMetric metric, AggIntervalEntry interval) {
        return super.fetchMetricDuringInterval(tenantId, entityId, argKey, metric, interval);
    }

    public void processResult(TenantId tenantId, EntityId entityId, String cfName, CalculatedFieldResult result, List<CalculatedFieldId> cfIds, TbCallback callback) {
        TelemetryCalculatedFieldResult telemetryRes;
        if (result instanceof AlarmCalculatedFieldResult) {
            this.sendMsgToRuleEngine(tenantId, entityId, callback, result.toTbMsg(entityId, cfName, cfIds));
            return;
        }
        TelemetryCalculatedFieldResult telemetryResult = result instanceof TelemetryCalculatedFieldResult ? (telemetryRes = (TelemetryCalculatedFieldResult)result) : ((PropagationCalculatedFieldResult)result).getResult();
        switch (1.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$OutputStrategyType[telemetryResult.getOutputStrategy().getType().ordinal()]) {
            case 1: {
                this.processImmediately(tenantId, entityId, cfName, result, cfIds, callback);
                break;
            }
            case 2: {
                this.pushMsgToRuleEngine(tenantId, entityId, cfName, result, cfIds, callback);
            }
        }
    }

    private void processImmediately(TenantId tenantId, EntityId entityId, String cfName, CalculatedFieldResult result, List<CalculatedFieldId> cfIds, TbCallback callback) {
        if (result instanceof TelemetryCalculatedFieldResult) {
            TelemetryCalculatedFieldResult telemetryResult = (TelemetryCalculatedFieldResult)result;
            this.saveTelemetryResult(tenantId, entityId, cfName, telemetryResult, cfIds, callback);
            return;
        }
        if (result instanceof PropagationCalculatedFieldResult) {
            PropagationCalculatedFieldResult propagationResult = (PropagationCalculatedFieldResult)result;
            this.handlePropagationResults(propagationResult, callback, (entity, res, cb) -> this.saveTelemetryResult(tenantId, entity, cfName, res, cfIds, cb));
            return;
        }
        callback.onSuccess();
    }

    private void pushMsgToRuleEngine(TenantId tenantId, EntityId entityId, String cfName, CalculatedFieldResult result, List<CalculatedFieldId> cfIds, TbCallback callback) {
        if (result instanceof PropagationCalculatedFieldResult) {
            PropagationCalculatedFieldResult propagationResult = (PropagationCalculatedFieldResult)result;
            this.handlePropagationResults(propagationResult, callback, (entity, res, cb) -> this.sendMsgToRuleEngine(tenantId, entity, cb, res.toTbMsg(entity, cfName, cfIds)));
            return;
        }
        this.sendMsgToRuleEngine(tenantId, entityId, callback, result.toTbMsg(entityId, cfName, cfIds));
    }

    public void pushMsgToLinks(CalculatedFieldTelemetryMsg msg, List<CalculatedFieldEntityCtxId> linkedCalculatedFields, TbCallback callback) {
        HashMap<TopicPartitionInfo, List> unicasts = new HashMap<TopicPartitionInfo, List>();
        ArrayList<CalculatedFieldEntityCtxId> broadcasts = new ArrayList<CalculatedFieldEntityCtxId>();
        for (CalculatedFieldEntityCtxId link : linkedCalculatedFields) {
            boolean broadcast;
            EntityId linkEntityId = link.entityId();
            EntityType linkEntityType = linkEntityId.getEntityType();
            boolean bl = broadcast = EntityType.DEVICE_PROFILE.equals((Object)linkEntityType) || EntityType.ASSET_PROFILE.equals((Object)linkEntityType);
            if (broadcast) {
                broadcasts.add(link);
                continue;
            }
            TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_RULE_ENGINE, "CalculatedFields", link.tenantId(), link.entityId());
            unicasts.computeIfAbsent(tpi, k -> new ArrayList()).add(link);
        }
        MultipleTbCallback linkCallback = new MultipleTbCallback(2, callback);
        if (!broadcasts.isEmpty()) {
            this.broadcast(broadcasts, msg, linkCallback);
        } else {
            linkCallback.onSuccess();
        }
        if (!unicasts.isEmpty()) {
            this.unicast(unicasts, msg, linkCallback);
        } else {
            linkCallback.onSuccess();
        }
    }

    private void unicast(Map<TopicPartitionInfo, List<CalculatedFieldEntityCtxId>> unicasts, CalculatedFieldTelemetryMsg msg, MultipleTbCallback mainCallback) {
        TbCallbackWrapper callback = new TbCallbackWrapper((TbCallback)new MultipleTbCallback(unicasts.size(), (TbCallback)mainCallback));
        unicasts.forEach((arg_0, arg_1) -> this.lambda$unicast$3(msg, (TbQueueCallback)callback, arg_0, arg_1));
    }

    private void broadcast(List<CalculatedFieldEntityCtxId> broadcasts, CalculatedFieldTelemetryMsg msg, MultipleTbCallback mainCallback) {
        TbCallbackWrapper callback = new TbCallbackWrapper((TbCallback)mainCallback);
        TransportProtos.CalculatedFieldLinkedTelemetryMsgProto linkedTelemetryMsgProto = this.buildLinkedTelemetryMsgProto(msg.getProto(), broadcasts);
        this.clusterService.broadcastToCalculatedFields(TransportProtos.ToCalculatedFieldNotificationMsg.newBuilder().setLinkedTelemetryMsg(linkedTelemetryMsgProto).build(), (TbQueueCallback)callback);
    }

    private TransportProtos.CalculatedFieldLinkedTelemetryMsgProto buildLinkedTelemetryMsgProto(TransportProtos.CalculatedFieldTelemetryMsgProto telemetryProto, List<CalculatedFieldEntityCtxId> links) {
        TransportProtos.CalculatedFieldLinkedTelemetryMsgProto.Builder builder = TransportProtos.CalculatedFieldLinkedTelemetryMsgProto.newBuilder();
        builder.setMsg(telemetryProto);
        for (CalculatedFieldEntityCtxId link : links) {
            builder.addLinks(CalculatedFieldUtils.toProto((CalculatedFieldEntityCtxId)link));
        }
        return builder.build();
    }

    private /* synthetic */ void lambda$unicast$3(CalculatedFieldTelemetryMsg msg, TbQueueCallback callback, TopicPartitionInfo topicPartitionInfo, List ctxIds) {
        TransportProtos.CalculatedFieldLinkedTelemetryMsgProto linkedTelemetryMsgProto = this.buildLinkedTelemetryMsgProto(msg.getProto(), ctxIds);
        this.clusterService.pushMsgToCalculatedFields(topicPartitionInfo, UUID.randomUUID(), TransportProtos.ToCalculatedFieldMsg.newBuilder().setLinkedTelemetryMsg(linkedTelemetryMsgProto).build(), callback);
    }
}

