/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldLink;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.cf.DefaultCalculatedFieldCache;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.security.permission.OwnersCacheService;

@Service
public class DefaultCalculatedFieldCache
implements CalculatedFieldCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCalculatedFieldCache.class);
    private final ConcurrentReferenceHashMap<CalculatedFieldId, Lock> calculatedFieldFetchLocks = new ConcurrentReferenceHashMap();
    private final CalculatedFieldService calculatedFieldService;
    private final TbAssetProfileCache assetProfileCache;
    private final TbDeviceProfileCache deviceProfileCache;
    private final TbTenantProfileCache tenantProfileCache;
    private final OwnersCacheService ownersCacheService;
    @Lazy
    private final ActorSystemContext systemContext;
    private final ConcurrentMap<CalculatedFieldId, CalculatedField> calculatedFields = new ConcurrentHashMap();
    private final ConcurrentMap<EntityId, List<CalculatedField>> entityIdCalculatedFields = new ConcurrentHashMap();
    private final ConcurrentMap<CalculatedFieldId, List<CalculatedFieldLink>> calculatedFieldLinks = new ConcurrentHashMap();
    private final ConcurrentMap<EntityId, List<CalculatedFieldLink>> entityIdCalculatedFieldLinks = new ConcurrentHashMap();
    private final ConcurrentMap<CalculatedFieldId, CalculatedFieldCtx> calculatedFieldsCtx = new ConcurrentHashMap();
    private final ConcurrentMap<EntityId, Set<EntityId>> ownerEntities = new ConcurrentHashMap();
    @Value(value="${queue.calculated_fields.init_fetch_pack_size:50000}")
    private int initFetchPackSize;

    @AfterStartUp(order=10)
    public void init() {
        PageDataIterable cfs = new PageDataIterable(arg_0 -> ((CalculatedFieldService)this.calculatedFieldService).findAllCalculatedFields(arg_0), this.initFetchPackSize);
        cfs.forEach(cf -> {
            if (cf != null) {
                this.calculatedFields.putIfAbsent(cf.getId(), cf);
                List links = cf.getConfiguration().buildCalculatedFieldLinks(cf.getTenantId(), cf.getEntityId(), cf.getId());
                this.calculatedFieldLinks.put(cf.getId(), new CopyOnWriteArrayList(links));
            }
        });
        this.calculatedFields.values().forEach(cf -> this.entityIdCalculatedFields.computeIfAbsent(cf.getEntityId(), id -> new CopyOnWriteArrayList()).add(cf));
        this.calculatedFieldLinks.values().stream().flatMap(Collection::stream).forEach(link -> this.entityIdCalculatedFieldLinks.computeIfAbsent(link.entityId(), id -> new CopyOnWriteArrayList()).add(link));
    }

    public CalculatedField getCalculatedField(CalculatedFieldId calculatedFieldId) {
        return (CalculatedField)this.calculatedFields.get(calculatedFieldId);
    }

    public List<CalculatedField> getCalculatedFieldsByEntityId(EntityId entityId) {
        return this.entityIdCalculatedFields.getOrDefault(entityId, Collections.emptyList());
    }

    public List<CalculatedFieldLink> getCalculatedFieldLinksByEntityId(EntityId entityId) {
        return this.entityIdCalculatedFieldLinks.getOrDefault(entityId, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalculatedFieldCtx getCalculatedFieldCtx(CalculatedFieldId calculatedFieldId) {
        CalculatedFieldCtx ctx = (CalculatedFieldCtx)this.calculatedFieldsCtx.get(calculatedFieldId);
        if (ctx == null) {
            Lock lock = this.getFetchLock(calculatedFieldId);
            lock.lock();
            try {
                CalculatedField calculatedField;
                ctx = (CalculatedFieldCtx)this.calculatedFieldsCtx.get(calculatedFieldId);
                if (ctx == null && (calculatedField = this.getCalculatedField(calculatedFieldId)) != null) {
                    ctx = new CalculatedFieldCtx(calculatedField, this.systemContext);
                    this.calculatedFieldsCtx.put(calculatedFieldId, ctx);
                    log.debug("[{}] Put calculated field ctx into cache: {}", (Object)calculatedFieldId, (Object)ctx);
                }
            }
            finally {
                lock.unlock();
            }
        }
        log.trace("[{}] Found calculated field ctx in cache: {}", (Object)calculatedFieldId, (Object)ctx);
        return ctx;
    }

    public List<CalculatedFieldCtx> getCalculatedFieldCtxsByEntityId(EntityId entityId) {
        if (entityId == null) {
            return Collections.emptyList();
        }
        return this.getCalculatedFieldsByEntityId(entityId).stream().map(cf -> this.getCalculatedFieldCtx(cf.getId())).toList();
    }

    public Stream<CalculatedFieldCtx> getCalculatedFieldCtxsByType(CalculatedFieldType cfType) {
        return this.calculatedFields.values().stream().filter(cf -> cfType.equals((Object)cf.getType())).map(cf -> this.getCalculatedFieldCtx(cf.getId()));
    }

    public boolean hasCalculatedFields(TenantId tenantId, EntityId entityId, Predicate<CalculatedFieldCtx> filter) {
        List entityCfs = this.getCalculatedFieldCtxsByEntityId(entityId);
        for (CalculatedFieldCtx ctx : entityCfs) {
            if (!filter.test(ctx)) continue;
            return true;
        }
        return this.hasCalculatedFieldsByProfile(tenantId, entityId, filter);
    }

    public boolean hasCalculatedFieldsByProfile(TenantId tenantId, EntityId entityId, Predicate<CalculatedFieldCtx> filter) {
        EntityId profileId = this.getProfileId(tenantId, entityId);
        if (profileId != null) {
            List profileCfs = this.getCalculatedFieldCtxsByEntityId(profileId);
            for (CalculatedFieldCtx ctx : profileCfs) {
                if (!filter.test(ctx)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCalculatedField(TenantId tenantId, CalculatedFieldId calculatedFieldId) {
        Lock lock = this.getFetchLock(calculatedFieldId);
        lock.lock();
        try {
            CalculatedField calculatedField = this.calculatedFieldService.findById(tenantId, calculatedFieldId);
            if (calculatedField == null) {
                return;
            }
            EntityId cfEntityId = calculatedField.getEntityId();
            this.calculatedFields.put(calculatedFieldId, calculatedField);
            this.entityIdCalculatedFields.computeIfAbsent(cfEntityId, entityId -> new CopyOnWriteArrayList()).add(calculatedField);
            CalculatedFieldConfiguration configuration = calculatedField.getConfiguration();
            this.calculatedFieldLinks.put(calculatedFieldId, configuration.buildCalculatedFieldLinks(tenantId, cfEntityId, calculatedFieldId));
            configuration.getReferencedEntities().stream().filter(referencedEntityId -> !referencedEntityId.equals(cfEntityId)).forEach(referencedEntityId -> this.entityIdCalculatedFieldLinks.computeIfAbsent(referencedEntityId, entityId -> new CopyOnWriteArrayList()).add(configuration.buildCalculatedFieldLink(tenantId, referencedEntityId, calculatedFieldId)));
        }
        finally {
            lock.unlock();
        }
    }

    public void updateCalculatedField(TenantId tenantId, CalculatedFieldId calculatedFieldId) {
        this.evict(calculatedFieldId);
        this.addCalculatedField(tenantId, calculatedFieldId);
    }

    public void evict(CalculatedFieldId calculatedFieldId) {
        CalculatedField oldCalculatedField = (CalculatedField)this.calculatedFields.remove(calculatedFieldId);
        log.debug("[{}] evict calculated field from cache: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
        this.calculatedFieldLinks.remove(calculatedFieldId);
        log.debug("[{}] evict calculated field from cached calculated fields by entity id: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
        this.entityIdCalculatedFields.forEach((entityId, calculatedFields) -> calculatedFields.removeIf(cf -> cf.getId().equals((Object)calculatedFieldId)));
        log.debug("[{}] evict calculated field links from cache: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
        this.calculatedFieldsCtx.remove(calculatedFieldId);
        log.debug("[{}] evict calculated field ctx from cache: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
        this.entityIdCalculatedFieldLinks.forEach((entityId, calculatedFieldLinks) -> calculatedFieldLinks.removeIf(link -> link.calculatedFieldId().equals((Object)calculatedFieldId)));
        log.debug("[{}] evict calculated field links from cached links by entity id: {}", (Object)calculatedFieldId, (Object)oldCalculatedField);
    }

    public void handleTenantProfileUpdate(TenantProfileId tenantProfileId) {
        this.calculatedFieldsCtx.values().stream().filter(ctx -> {
            TenantProfile tenantProfile = this.tenantProfileCache.get(ctx.getTenantId());
            return tenantProfile != null && tenantProfileId.equals((Object)tenantProfile.getId());
        }).forEach(CalculatedFieldCtx::setTenantProfileProperties);
    }

    public EntityId getProfileId(TenantId tenantId, EntityId entityId) {
        AssetProfile profile = switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1 -> this.assetProfileCache.get(tenantId, (AssetId)entityId);
            case 2 -> this.deviceProfileCache.get(tenantId, (DeviceId)entityId);
            default -> null;
        };
        return profile != null ? (EntityId)profile.getId() : null;
    }

    public Set<EntityId> getDynamicEntities(TenantId tenantId, EntityId entityId) {
        if (entityId != null && entityId.getEntityType().isOneOf(new EntityType[]{EntityType.CUSTOMER, EntityType.TENANT})) {
            return this.getOwnedEntities(tenantId, entityId);
        }
        return Collections.emptySet();
    }

    public void addOwnerEntity(TenantId tenantId, EntityId entityId) {
        EntityId owner = this.ownersCacheService.getOwner(tenantId, entityId);
        this.getOwnedEntities(tenantId, owner).add(entityId);
    }

    public void updateOwnerEntity(TenantId tenantId, EntityId entityId) {
        this.evictEntity(entityId);
        this.addOwnerEntity(tenantId, entityId);
    }

    public void evictEntity(EntityId entityId) {
        this.ownerEntities.values().forEach(entities -> entities.remove(entityId));
    }

    public void evictOwner(EntityId owner) {
        this.ownerEntities.remove(owner);
    }

    private Set<EntityId> getOwnedEntities(TenantId tenantId, EntityId ownerId) {
        return this.ownerEntities.computeIfAbsent(ownerId, owner -> {
            ConcurrentHashMap.KeySetView entities = ConcurrentHashMap.newKeySet();
            entities.addAll(this.ownersCacheService.getOwnedEntities(tenantId, ownerId));
            return entities;
        });
    }

    private Lock getFetchLock(CalculatedFieldId id) {
        return (Lock)this.calculatedFieldFetchLocks.computeIfAbsent((Object)id, __ -> new ReentrantLock());
    }

    @ConstructorProperties(value={"calculatedFieldService", "assetProfileCache", "deviceProfileCache", "tenantProfileCache", "ownersCacheService", "systemContext"})
    @Generated
    public DefaultCalculatedFieldCache(CalculatedFieldService calculatedFieldService, TbAssetProfileCache assetProfileCache, TbDeviceProfileCache deviceProfileCache, TbTenantProfileCache tenantProfileCache, OwnersCacheService ownersCacheService, @Lazy ActorSystemContext systemContext) {
        this.calculatedFieldService = calculatedFieldService;
        this.assetProfileCache = assetProfileCache;
        this.deviceProfileCache = deviceProfileCache;
        this.tenantProfileCache = tenantProfileCache;
        this.ownersCacheService = ownersCacheService;
        this.systemContext = systemContext;
    }

    @Generated
    public int getInitFetchPackSize() {
        return this.initFetchPackSize;
    }
}

