/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.action.TbAlarmResult;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.service.cf.AlarmCalculatedFieldResult;
import org.thingsboard.server.service.cf.CalculatedFieldResult;

public class AlarmCalculatedFieldResult
implements CalculatedFieldResult {
    private final TbAlarmResult alarmResult;

    public TbMsg toTbMsg(EntityId entityId, String cfName, List<CalculatedFieldId> cfIds) {
        TbMsgType msgType;
        TbMsgMetaData metaData = new TbMsgMetaData();
        if (this.alarmResult.isCreated()) {
            msgType = TbMsgType.ALARM_CREATED;
            metaData.putValue("isNewAlarm", Boolean.TRUE.toString());
        } else if (this.alarmResult.isUpdated()) {
            msgType = TbMsgType.ALARM_UPDATED;
            metaData.putValue("isExistingAlarm", Boolean.TRUE.toString());
        } else if (this.alarmResult.isSeverityUpdated()) {
            msgType = TbMsgType.ALARM_SEVERITY_UPDATED;
            metaData.putValue("isExistingAlarm", Boolean.TRUE.toString());
            metaData.putValue("isSeverityUpdated", Boolean.TRUE.toString());
        } else {
            msgType = TbMsgType.ALARM_CLEAR;
            metaData.putValue("isClearedAlarm", Boolean.TRUE.toString());
        }
        if (this.alarmResult.getConditionRepeats() != null) {
            metaData.putValue("alarmConditionRepeats", String.valueOf(this.alarmResult.getConditionRepeats()));
        }
        if (this.alarmResult.getConditionDuration() != null) {
            metaData.putValue("alarmConditionDuration", String.valueOf(this.alarmResult.getConditionDuration()));
        }
        return TbMsg.newMsg().type(msgType).originator(entityId).data(JacksonUtil.toString((Object)this.alarmResult.getAlarm())).metaData(metaData).build();
    }

    public String stringValue() {
        return this.alarmResult != null ? JacksonUtil.toString((Object)this.alarmResult) : null;
    }

    public boolean isEmpty() {
        return this.alarmResult == null;
    }

    @Generated
    public static AlarmCalculatedFieldResultBuilder builder() {
        return new AlarmCalculatedFieldResultBuilder();
    }

    @Generated
    public TbAlarmResult getAlarmResult() {
        return this.alarmResult;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmCalculatedFieldResult)) {
            return false;
        }
        AlarmCalculatedFieldResult other = (AlarmCalculatedFieldResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TbAlarmResult this$alarmResult = this.getAlarmResult();
        TbAlarmResult other$alarmResult = other.getAlarmResult();
        return !(this$alarmResult == null ? other$alarmResult != null : !this$alarmResult.equals(other$alarmResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmCalculatedFieldResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TbAlarmResult $alarmResult = this.getAlarmResult();
        result = result * 59 + ($alarmResult == null ? 43 : $alarmResult.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlarmCalculatedFieldResult(alarmResult=" + String.valueOf(this.getAlarmResult()) + ")";
    }

    @ConstructorProperties(value={"alarmResult"})
    @Generated
    public AlarmCalculatedFieldResult(TbAlarmResult alarmResult) {
        this.alarmResult = alarmResult;
    }
}

