/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ai;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.service.ai.AiRequestsExecutor;
import org.thingsboard.server.service.ai.DefaultAiRequestsExecutor;

@Lazy
@Component
class DefaultAiRequestsExecutor
implements AiRequestsExecutor {
    private final AiRequestsExecutorProperties properties;
    private ListeningExecutorService executorService;

    @PostConstruct
    private void init() {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.properties.getPoolSize(), (ThreadFactory)ThingsBoardThreadFactory.forName((String)this.properties.getPoolName())));
    }

    public FluentFuture<ChatResponse> sendChatRequestAsync(ChatModel chatModel, ChatRequest chatRequest) {
        return FluentFuture.from((ListenableFuture)this.executorService.submit(() -> chatModel.chat(chatRequest)));
    }

    @PreDestroy
    private void destroy() {
        if (this.executorService != null) {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (Duration)Duration.ofSeconds(this.properties.getTerminationTimeoutSeconds()));
            this.executorService = null;
        }
    }

    @ConstructorProperties(value={"properties"})
    @Generated
    public DefaultAiRequestsExecutor(AiRequestsExecutorProperties properties) {
        this.properties = properties;
    }
}

