/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.permission.AllowedPermissionsInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class UserPermissionsController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPermissionsController.class);

    @ApiOperation(value="Get Permissions (getAllowedPermissions)", notes="Returns a complex object that describes:\n\n * all possible (both granted and not granted) permissions for the authority of the user (Tenant or Customer);\n * all granted permissions for the user;\n\n The result impacts UI behavior and hides certain UI elements if user has no permissions to invoke the related operations. Nevertheless, all API calls check the permissions each time they are executed on the server side.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/permissions/allowedPermissions"})
    public AllowedPermissionsInfo getAllowedPermissions() throws ThingsboardException {
        Set allowedResources = (Set)Resource.resourcesByAuthority.get(this.getCurrentUser().getAuthority());
        HashMap operationsByResource = new HashMap();
        allowedResources.forEach(resource -> operationsByResource.put(resource, (Set)Resource.operationsByResource.get(resource)));
        return new AllowedPermissionsInfo(operationsByResource, Operation.allowedForGroupRoleOperations, Operation.allowedForGroupOwnerOnlyOperations, Operation.allowedForGroupOwnerOnlyGroupOperations, allowedResources, this.getCurrentUser().getUserPermissions(), this.getCurrentUser().getOwnerId());
    }

    @ApiOperation(value="Check permission for specified entity (hasEntityPermission)", notes="Returns true if the user has permission to perform the operation, and false otherwise.\n")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/permission/{entityType}/{entityId}/{operation}"})
    public boolean hasEntityPermission(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") EntityType entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String strEntityId, @Parameter(description="A string value representing permission operation. For example, 'READ', 'WRITE', 'DELETE', 'CREATE', 'ALL'", required=true, schema=@Schema(allowableValues={"ALL", "CREATE", "READ", "WRITE", "DELETE", "RPC_CALL", "READ_CREDENTIALS", "WRITE_CREDENTIALS", "READ_ATTRIBUTES", "WRITE_ATTRIBUTES", "READ_TELEMETRY", "WRITE_TELEMETRY", "ADD_TO_GROUP", "REMOVE_FROM_GROUP", "CHANGE_OWNER", "IMPERSONATE", "CLAIM_DEVICES", "SHARE_GROUP", "ASSIGN_TO_TENANT", "READ_CALCULATED_FIELD", "WRITE_CALCULATED_FIELD"})) @PathVariable(value="operation") Operation operation) {
        EntityId entityId = EntityIdFactory.getByTypeAndId((EntityType)entityType, (String)strEntityId);
        try {
            this.checkEntityId(entityId, operation);
        }
        catch (ThingsboardException e) {
            return false;
        }
        return true;
    }
}

