/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class UiSettingsController
extends BaseController {
    @Value(value="${ui.help.base-url}")
    private String helpBaseUrl;

    @ApiOperation(value="Get UI help base url (getHelpBaseUrl)", notes="Get UI help base url used to fetch help assets. The actual value of the base url is configurable in the system configuration file.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/uiSettings/helpBaseUrl"})
    public String getHelpBaseUrl() {
        return this.helpBaseUrl;
    }
}

