/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.common.data.security.model.mfa.PlatformTwoFaSettings;
import org.thingsboard.server.common.data.security.model.mfa.account.EmailTwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.account.SmsTwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderType;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.TwoFactorAuthController;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.mfa.TwoFactorAuthService;
import org.thingsboard.server.service.security.auth.mfa.config.TwoFaConfigManager;
import org.thingsboard.server.service.security.auth.rest.RestAuthenticationDetails;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;
import org.thingsboard.server.service.security.system.SystemSecurityService;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/auth/2fa"})
@TbCoreComponent
public class TwoFactorAuthController
extends BaseController {
    private final TwoFactorAuthService twoFactorAuthService;
    private final TwoFaConfigManager twoFaConfigManager;
    private final JwtTokenFactory tokenFactory;
    private final SystemSecurityService systemSecurityService;
    private final UserService userService;

    @ApiOperation(value="Request 2FA verification code (requestTwoFaVerificationCode)", notes="Request 2FA verification code.\n\nTo make a request to this endpoint, you need an access token with the scope of PRE_VERIFICATION_TOKEN, which is issued on username/password auth if 2FA is enabled.\n\nThe API method is rate limited (using rate limit config from TwoFactorAuthSettings). Will return a Bad Request error if provider is not configured for usage, and Too Many Requests error if rate limits are exceeded.")
    @PostMapping(value={"/verification/send"})
    @PreAuthorize(value="hasAuthority('PRE_VERIFICATION_TOKEN')")
    public void requestTwoFaVerificationCode(@RequestParam TwoFaProviderType providerType) throws Exception {
        SecurityUser user = this.getCurrentUser();
        this.twoFactorAuthService.prepareVerificationCode(user, providerType, true);
    }

    @ApiOperation(value="Check 2FA verification code (checkTwoFaVerificationCode)", notes="Checks 2FA verification code, and if it is correct the method returns a regular access and refresh token pair.\n\nThe API method is rate limited (using rate limit config from TwoFactorAuthSettings), and also will block a user after X unsuccessful verification attempts if such behavior is configured (in TwoFactorAuthSettings).\n\nWill return a Bad Request error if provider is not configured for usage, and Too Many Requests error if rate limits are exceeded.")
    @PostMapping(value={"/verification/check"})
    @PreAuthorize(value="hasAuthority('PRE_VERIFICATION_TOKEN')")
    public JwtPair checkTwoFaVerificationCode(@RequestParam TwoFaProviderType providerType, @RequestParam String verificationCode, HttpServletRequest servletRequest) throws Exception {
        SecurityUser user = this.getCurrentUser();
        boolean verificationSuccess = this.twoFactorAuthService.checkVerificationCode(user, providerType, verificationCode, true);
        if (verificationSuccess) {
            this.logLogInAction(servletRequest, user, null);
            return this.createTokenPair(user);
        }
        IllegalArgumentException error = new IllegalArgumentException("Verification code is incorrect");
        this.logLogInAction(servletRequest, user, (Exception)error);
        throw error;
    }

    @ApiOperation(value="Get available 2FA providers (getAvailableTwoFaProviders)", notes="Get the list of 2FA provider infos available for user to use. Example:\n```\n[\n  {\n    \"type\": \"EMAIL\",\n    \"default\": true,\n    \"contact\": \"ab*****ko@gmail.com\"\n  },\n  {\n    \"type\": \"TOTP\",\n    \"default\": false,\n    \"contact\": null\n  },\n  {\n    \"type\": \"SMS\",\n    \"default\": false,\n    \"contact\": \"+38********12\"\n  }\n]\n```")
    @GetMapping(value={"/providers"})
    @PreAuthorize(value="hasAuthority('PRE_VERIFICATION_TOKEN')")
    public List<TwoFaProviderInfo> getAvailableTwoFaProviders() throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        Optional platformTwoFaSettings = this.twoFaConfigManager.getPlatformTwoFaSettings(user.getTenantId(), true);
        return ((Collection)this.twoFaConfigManager.getAccountTwoFaSettings(user.getTenantId(), (User)user).map(settings -> settings.getConfigs().values()).orElse(Collections.emptyList())).stream().map(config -> {
            String contact = null;
            switch (1.$SwitchMap$org$thingsboard$server$common$data$security$model$mfa$provider$TwoFaProviderType[config.getProviderType().ordinal()]) {
                case 1: {
                    String phoneNumber = ((SmsTwoFaAccountConfig)config).getPhoneNumber();
                    contact = StringUtils.obfuscate((String)phoneNumber, (int)2, (char)'*', (int)(phoneNumber.indexOf(43) + 1), (int)phoneNumber.length());
                    break;
                }
                case 2: {
                    String email = ((EmailTwoFaAccountConfig)config).getEmail();
                    contact = StringUtils.obfuscate((String)email, (int)2, (char)'*', (int)0, (int)email.indexOf(64));
                }
            }
            return TwoFaProviderInfo.builder().type(config.getProviderType()).isDefault(config.isUseByDefault()).contact(contact).minVerificationCodeSendPeriod(((PlatformTwoFaSettings)platformTwoFaSettings.get()).getMinVerificationCodeSendPeriod()).build();
        }).collect(Collectors.toList());
    }

    @ApiOperation(value="Get regular token pair after successfully configuring 2FA", notes="Checks 2FA is configured, returning token pair on success.")
    @PostMapping(value={"/login"})
    @PreAuthorize(value="hasAuthority('MFA_CONFIGURATION_TOKEN')")
    public JwtPair authenticateByTwoFaConfigurationToken(HttpServletRequest servletRequest) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        if (this.twoFactorAuthService.isTwoFaEnabled(user.getTenantId(), (User)user)) {
            this.logLogInAction(servletRequest, user, null);
            return this.createTokenPair(user);
        }
        IllegalArgumentException error = new IllegalArgumentException("2FA is not configured");
        this.logLogInAction(servletRequest, user, (Exception)error);
        throw error;
    }

    private JwtPair createTokenPair(SecurityUser user) {
        this.log.debug("[{}][{}] Creating token pair for user", (Object)user.getTenantId(), (Object)user.getId());
        user = new SecurityUser(this.userService.findUserById(user.getTenantId(), user.getId()), true, user.getUserPrincipal(), this.getMergedUserPermissions((User)user, false));
        return this.tokenFactory.createTokenPair(user);
    }

    private void logLogInAction(HttpServletRequest servletRequest, SecurityUser user, Exception error) {
        this.systemSecurityService.logLoginAction((User)user, (Object)new RestAuthenticationDetails(servletRequest), ActionType.LOGIN, error);
    }

    @ConstructorProperties(value={"twoFactorAuthService", "twoFaConfigManager", "tokenFactory", "systemSecurityService", "userService"})
    @Generated
    public TwoFactorAuthController(TwoFactorAuthService twoFactorAuthService, TwoFaConfigManager twoFaConfigManager, JwtTokenFactory tokenFactory, SystemSecurityService systemSecurityService, UserService userService) {
        this.twoFactorAuthService = twoFactorAuthService;
        this.twoFaConfigManager = twoFaConfigManager;
        this.tokenFactory = tokenFactory;
        this.systemSecurityService = systemSecurityService;
        this.userService = userService;
    }
}

