/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.trendz.TrendzProxyService;

@RestController
@TbCoreComponent
@RequestMapping
public class TrendzProxyController
extends BaseController {
    private final TrendzProxyService trendzProxyService;

    @ApiOperation(value="Forward Authorized Requests to Trendz", notes="Forwards authorized requests (/apiTrendz/**) to Trendz using the Trendz internal URL. Can only be used if Trendz is already synchronized and integration is enabled. \n\nAvailable for any authorized user. ")
    @RequestMapping(value={"/apiTrendz/**"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public ResponseEntity<byte[]> handleAuthorizedTrendzRequests(HttpServletRequest request, @RequestBody(required=false) byte[] body) throws ThingsboardException {
        return this.trendzProxyService.proxy(request, body);
    }

    @ApiOperation(value="Forward Unauthorized Requests to Trendz", notes="Forwards unauthorized requests (/apiTrendz/publicApi/**, /trendz/**) to Trendz using the Trendz internal URL. Can only be used if Trendz is already synchronized and integration is enabled. \n\nAvailable for any authorized user. ")
    @RequestMapping(value={"/apiTrendz/publicApi/**", "/trendz/**"})
    public ResponseEntity<byte[]> handleUnauthorizedTrendzRequests(HttpServletRequest request, @RequestBody(required=false) byte[] body) throws ThingsboardException {
        return this.trendzProxyService.proxy(request, body);
    }

    @ConstructorProperties(value={"trendzProxyService"})
    @Generated
    public TrendzProxyController(TrendzProxyService trendzProxyService) {
        this.trendzProxyService = trendzProxyService;
    }
}

