/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.trendz.TrendzSummary;
import org.thingsboard.server.common.data.trendz.TrendzUsage;
import org.thingsboard.server.common.data.trendz.TrendzViewConfig;
import org.thingsboard.server.common.data.trendz.TrendzViewConfigLite;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.trendz.TrendzApiService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api/trendz"})
public class TrendzApiController
extends BaseController {
    private static final String TRENDZ_VIEW_ID = "viewId";
    private final TrendzApiService trendzApiService;

    @ApiOperation(value="Get Trendz Views (getTrendzViews)", notes="Returns a page of Trendz views that are available for the current user. Can only be used if Trendz is already synchronized and integration is enabled. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @GetMapping(path={"/view/all"}, params={"pageSize", "page"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    public PageData<TrendzViewConfigLite> getTrendzViews(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the Trendz view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"name", "createdAt", "updatedAt", "favorite"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser user = this.getCurrentUser();
        return this.trendzApiService.getAllViews((User)user, pageLink);
    }

    @ApiOperation(value="Get Trendz View by Id (getTrendzViewById)", notes="Fetch the Trendz View object based on the provided Trendz View Id. Can only be used if Trendz is already synchronized and integration is enabled. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @GetMapping(value={"/view/{viewId}"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    public TrendzViewConfig getTrendzViewById(@Parameter(description="A string value representing the Trendz view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="viewId") String strViewId) throws ThingsboardException {
        TrendzApiController.checkParameter((String)"viewId", (String)strViewId);
        UUID viewId = this.toUUID(strViewId);
        SecurityUser user = this.getCurrentUser();
        return this.trendzApiService.getViewById((User)user, viewId);
    }

    @ApiOperation(value="Get Trendz Summary (getTrendzSummary)", notes="Fetch the Trendz summary object. Can only be used if Trendz is already synchronized and integration is enabled. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @GetMapping(value={"/summary"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    public TrendzSummary getTrendzSummary() throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        return this.trendzApiService.getTrendzSummary((User)user);
    }

    @ApiOperation(value="Get Trendz Usage (getTrendzUsage)", notes="Fetch the Trendz usage object. Can only be used if Trendz is already synchronized and integration is enabled. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/usage"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public TrendzUsage getTrendzUsage() throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        return this.trendzApiService.getTrendzUsage((User)user);
    }

    @ConstructorProperties(value={"trendzApiService"})
    @Generated
    public TrendzApiController(TrendzApiService trendzApiService) {
        this.trendzApiService = trendzApiService;
    }
}

