/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.solutions.SolutionService;
import org.thingsboard.server.service.solutions.data.solution.SolutionInstallResponse;
import org.thingsboard.server.service.solutions.data.solution.TenantSolutionTemplateDetails;
import org.thingsboard.server.service.solutions.data.solution.TenantSolutionTemplateInfo;
import org.thingsboard.server.service.solutions.data.solution.TenantSolutionTemplateInstructions;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api/solutions"})
public class SolutionController
extends BaseController {
    @Autowired
    private SolutionService solutionService;

    @ApiOperation(value="Get Solution templates (getSolutionTemplateInfos)", notes="Get a list of solution template descriptors\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/templates/infos"})
    public List<TenantSolutionTemplateInfo> getSolutionTemplateInfos() throws ThingsboardException {
        this.checkAllPermissions();
        return (List)this.checkNotNull((Object)this.solutionService.getSolutionInfos(this.getTenantId()));
    }

    @ApiOperation(value="Get Solution template details (getSolutionTemplateDetails)", notes="Get a solution template details based on the provided id\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/templates/details/{solutionTemplateId}"})
    public TenantSolutionTemplateDetails getSolutionTemplateDetails(@Parameter(description="A string value representing the solution template id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="solutionTemplateId") String solutionTemplateId) throws ThingsboardException {
        SolutionController.checkParameter((String)"solutionTemplateId", (String)solutionTemplateId);
        this.checkAllPermissions();
        return (TenantSolutionTemplateDetails)this.checkNotNull((Object)this.solutionService.getSolutionDetails(this.getTenantId(), solutionTemplateId));
    }

    @ApiOperation(value="Get Solution Template Instructions (getSolutionTemplateInstructions)", notes="Get a solution template instructions based on the provided id\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/templates/instructions/{solutionTemplateId}"})
    public TenantSolutionTemplateInstructions getSolutionTemplateInstructions(@Parameter(description="A string value representing the solution template id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="solutionTemplateId") String solutionTemplateId) throws ThingsboardException {
        SolutionController.checkParameter((String)"solutionTemplateId", (String)solutionTemplateId);
        this.checkAllPermissions();
        return (TenantSolutionTemplateInstructions)this.checkNotNull((Object)this.solutionService.getSolutionInstructions(this.getTenantId(), solutionTemplateId));
    }

    @ApiOperation(value="Install Solution Template (installSolutionTemplate)", notes="Install solution template based on the provided id\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/templates/{solutionTemplateId}/install"})
    public SolutionInstallResponse installSolutionTemplate(@Parameter(description="A string value representing the solution template id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(name="solutionTemplateId") String solutionTemplateId, HttpServletRequest request) throws ThingsboardException {
        SolutionController.checkParameter((String)"solutionTemplateId", (String)solutionTemplateId);
        this.checkAllPermissions();
        return (SolutionInstallResponse)this.checkNotNull((Object)this.solutionService.installSolution((User)this.getCurrentUser(), this.getTenantId(), solutionTemplateId, request));
    }

    @ApiOperation(value="Uninstall Solution Template (uninstallSolutionTemplate)", notes="Uninstall solution template based on the provided id\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/templates/{solutionTemplateId}/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public void uninstallSolutionTemplate(@Parameter(description="A string value representing the solution template id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(name="solutionTemplateId") String solutionTemplateId) throws ThingsboardException {
        SolutionController.checkParameter((String)"solutionTemplateId", (String)solutionTemplateId);
        this.checkAllPermissions();
        this.solutionService.deleteSolution(this.getTenantId(), solutionTemplateId, (User)this.getCurrentUser());
    }

    private void checkAllPermissions() throws ThingsboardException {
        if (!this.getCurrentUser().getUserPermissions().hasGenericPermission(Resource.ALL, Operation.ALL)) {
            throw new ThingsboardException("You don't have permissions to use solution templates!", ThingsboardErrorCode.PERMISSION_DENIED);
        }
    }
}

