/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.report.ScheduledReportQuery;
import org.thingsboard.server.common.data.scheduler.ScheduledReportInfo;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventFilter;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.common.data.scheduler.SchedulerEventTimeFilter;
import org.thingsboard.server.common.data.scheduler.SchedulerEventWithCustomerInfo;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.scheduler.TbSchedulerService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class SchedulerEventController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerEventController.class);
    private static final String SCHEDULER_EVENT_INFO_DESCRIPTION = "Scheduler Events allows you to schedule various types of events with flexible schedule configuration. Scheduler fires configured scheduler events according to their schedule. See the 'Model' tab of the Response Class for more details. ";
    private static final String SCHEDULER_EVENT_WITH_CUSTOMER_INFO_DESCRIPTION = "Scheduler Event With Customer Info extends Scheduler Event Info object and adds 'customerTitle' - a String value representing the title of the customer which user created a Scheduler Event and 'customerIsPublic' - a boolean parameter that specifies if customer is public. See the 'Model' tab of the Response Class for more details. ";
    private static final String SCHEDULER_EVENT_DESCRIPTION = "Scheduler Event extends Scheduler Event Info object and adds 'configuration' - a JSON structure of scheduler event configuration. See the 'Model' tab of the Response Class for more details. ";
    private static final String INVALID_SCHEDULER_EVENT_ID = "Referencing non-existing Scheduler Event Id will cause 'Not Found' error.";
    private static final int DEFAULT_SCHEDULER_EVENT_LIMIT = 100;
    public static final String SCHEDULER_EVENT_ID = "schedulerEventId";
    private final TbSchedulerService tbSchedulerService;

    @ApiOperation(value="Get Scheduler Event With Customer Info (getSchedulerEventInfoById)", notes="Fetch the SchedulerEventWithCustomerInfo object based on the provided scheduler event Id. Scheduler Event With Customer Info extends Scheduler Event Info object and adds 'customerTitle' - a String value representing the title of the customer which user created a Scheduler Event and 'customerIsPublic' - a boolean parameter that specifies if customer is public. See the 'Model' tab of the Response Class for more details. Referencing non-existing Scheduler Event Id will cause 'Not Found' error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/schedulerEvent/info/{schedulerEventId}"})
    public SchedulerEventWithCustomerInfo getSchedulerEventInfoById(@Parameter(description="A string value representing the scheduler id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="schedulerEventId") String strSchedulerEventId) throws ThingsboardException {
        SchedulerEventController.checkParameter((String)"schedulerEventId", (String)strSchedulerEventId);
        SchedulerEventId schedulerEventId = new SchedulerEventId(this.toUUID(strSchedulerEventId));
        return this.checkSchedulerEventInfoId(schedulerEventId, Operation.READ);
    }

    @ApiOperation(value="Get Scheduler Event (getSchedulerEventById)", notes="Fetch the SchedulerEvent object based on the provided scheduler event Id. Scheduler Event extends Scheduler Event Info object and adds 'configuration' - a JSON structure of scheduler event configuration. See the 'Model' tab of the Response Class for more details. Referencing non-existing Scheduler Event Id will cause 'Not Found' error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/schedulerEvent/{schedulerEventId}"})
    public SchedulerEvent getSchedulerEventById(@Parameter(description="A string value representing the scheduler id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="schedulerEventId") String strSchedulerEventId) throws ThingsboardException {
        SchedulerEventController.checkParameter((String)"schedulerEventId", (String)strSchedulerEventId);
        SchedulerEventId schedulerEventId = new SchedulerEventId(this.toUUID(strSchedulerEventId));
        return this.checkSchedulerEventId(schedulerEventId, Operation.READ);
    }

    @ApiOperation(value="Save Scheduler Event (saveSchedulerEvent)", notes="Creates or Updates scheduler event. Scheduler Event extends Scheduler Event Info object and adds 'configuration' - a JSON structure of scheduler event configuration. See the 'Model' tab of the Response Class for more details. When creating scheduler event, platform generates scheduler event Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created scheduler event id will be present in the response. Specify existing scheduler event id to update the scheduler event. Referencing non-existing scheduler event Id will cause 'Not Found' error. Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Scheduler Event entity. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/schedulerEvent"})
    public SchedulerEvent saveSchedulerEvent(@Parameter(description="A JSON value representing the Scheduler Event.") @RequestBody SchedulerEvent schedulerEvent) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        schedulerEvent.setTenantId(currentUser.getTenantId());
        if (Authority.CUSTOMER_USER.equals((Object)currentUser.getAuthority())) {
            schedulerEvent.setCustomerId(currentUser.getCustomerId());
        }
        this.checkEntity((EntityId)schedulerEvent.getId(), (TenantEntity)schedulerEvent, Resource.SCHEDULER_EVENT);
        return this.tbSchedulerService.save(schedulerEvent, (User)currentUser);
    }

    @ApiOperation(value="Enable or disable Scheduler Event (enableSchedulerEvent)", notes="Updates scheduler event with enabled = true/false. Scheduler Event extends Scheduler Event Info object and adds 'configuration' - a JSON structure of scheduler event configuration. See the 'Model' tab of the Response Class for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PutMapping(value={"/schedulerEvent/{schedulerEventId}/enabled/{enabledValue}"})
    public SchedulerEvent enableSchedulerEvent(@Parameter(description="A string value representing the scheduler id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="schedulerEventId") String strSchedulerEventId, @Parameter(description="Enabled or disabled scheduler", required=true) @PathVariable(value="enabledValue") Boolean enabledValue) throws ThingsboardException {
        SchedulerEventController.checkParameter((String)"schedulerEventId", (String)strSchedulerEventId);
        SchedulerEventId schedulerEventId = new SchedulerEventId(this.toUUID(strSchedulerEventId));
        SchedulerEvent schedulerEvent = this.checkSchedulerEventId(schedulerEventId, Operation.WRITE);
        schedulerEvent.setEnabled(enabledValue.booleanValue());
        return this.tbSchedulerService.save(schedulerEvent, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete Scheduler Event (deleteSchedulerEvent)", notes="Deletes the scheduler event. Referencing non-existing Scheduler Event Id will cause 'Not Found' error.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/schedulerEvent/{schedulerEventId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteSchedulerEvent(@Parameter(description="A string value representing the scheduler id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="schedulerEventId") String strSchedulerEventId) throws ThingsboardException {
        SchedulerEventController.checkParameter((String)"schedulerEventId", (String)strSchedulerEventId);
        SchedulerEventId schedulerEventId = new SchedulerEventId(this.toUUID(strSchedulerEventId));
        SchedulerEvent schedulerEvent = this.checkSchedulerEventId(schedulerEventId, Operation.DELETE);
        this.tbSchedulerService.delete(schedulerEvent, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get all scheduler events (getAllSchedulerEvents)", notes="Requested scheduler events must be owned by tenant or assigned to customer which user is performing the request. Scheduler Event With Customer Info extends Scheduler Event Info object and adds 'customerTitle' - a String value representing the title of the customer which user created a Scheduler Event and 'customerIsPublic' - a boolean parameter that specifies if customer is public. See the 'Model' tab of the Response Class for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/schedulerEvents"})
    public List<SchedulerEventWithCustomerInfo> getAllSchedulerEvents(@Parameter(description="A string value representing the scheduler type. For example, 'generateReport'") @RequestParam(required=false) String type) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.accessControlService.checkPermission(currentUser, Resource.SCHEDULER_EVENT, Operation.READ);
        SchedulerEventFilter filter = SchedulerEventFilter.builder().customerId(currentUser.getCustomerId()).type(type).build();
        return this.schedulerEventService.findSchedulerEventsByTenantIdAndFilter(currentUser.getTenantId(), filter, new PageLink(1000)).getData();
    }

    @ApiOperation(value="Get scheduler events (getSchedulerEvents)", notes="Requested scheduler events must be owned by tenant or assigned to customer which user is performing the request. Scheduler Event With Customer Info extends Scheduler Event Info object and adds 'customerTitle' - a String value representing the title of the customer which user created a Scheduler Event and 'customerIsPublic' - a boolean parameter that specifies if customer is public. See the 'Model' tab of the Response Class for more details. \n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/schedulerEvents"}, params={"pageSize", "page"})
    public PageData<SchedulerEventWithCustomerInfo> getSchedulerEvents(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on event's name, type, or customer's name") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @Parameter(description="A string value representing the scheduler type. For example, 'generateReport'") @RequestParam(required=false) String type, @Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) UUID edgeId) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.accessControlService.checkPermission(currentUser, Resource.SCHEDULER_EVENT, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SchedulerEventFilter filter = SchedulerEventFilter.builder().customerId(currentUser.getCustomerId()).type(type).edgeId(edgeId != null ? new EdgeId(edgeId) : null).build();
        return this.schedulerEventService.findSchedulerEventsByTenantIdAndFilter(currentUser.getTenantId(), filter, pageLink);
    }

    @ApiOperation(value="Get scheduler events (getSchedulerEvents)", notes="Retrieves scheduler events filtering by event run time. Requested scheduler events must be owned by tenant or assigned to customer which user is performing the request. Scheduler Event With Customer Info extends Scheduler Event Info object and adds 'customerTitle' - a String value representing the title of the customer which user created a Scheduler Event and 'customerIsPublic' - a boolean parameter that specifies if customer is public. See the 'Model' tab of the Response Class for more details. \n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/schedulerEvents"}, params={"startTime", "endTime"})
    public List<SchedulerEventWithCustomerInfo> getSchedulerEvents(@Parameter(description="A string value representing the scheduler type. For example, 'generateReport'") @RequestParam(required=false) String type, @Parameter(description="Start time filter in milliseconds for scheduler event run time") @RequestParam long startTime, @Parameter(description="End time filter in milliseconds for scheduler event run time") @RequestParam long endTime, @Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) UUID edgeId, @Parameter(description="Case-insensitive 'substring' filter based on event's name, type, or customer's name") @RequestParam(required=false) String textSearch) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.accessControlService.checkPermission(currentUser, Resource.SCHEDULER_EVENT, Operation.READ);
        SchedulerEventTimeFilter filter = ((SchedulerEventTimeFilter.SchedulerEventTimeFilterBuilder)((SchedulerEventTimeFilter.SchedulerEventTimeFilterBuilder)((SchedulerEventTimeFilter.SchedulerEventTimeFilterBuilder)SchedulerEventTimeFilter.builder().customerId(currentUser.getCustomerId())).type(type)).startTime(startTime).endTime(endTime).edgeId(edgeId != null ? new EdgeId(edgeId) : null)).build();
        return this.schedulerEventService.findAllSchedulerEventsByTenantIdAndEventTimeFilter(currentUser.getTenantId(), filter, textSearch);
    }

    @ApiOperation(value="Get Scheduled Report Events (getScheduledReportEvents)", notes="\n\nAvailable for users with 'TENANT_ADMIN' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/scheduledReports"})
    public PageData<ScheduledReportInfo> getScheduledReportEvents(@Parameter(description="Report template id") @RequestParam(required=false) UUID reportTemplateId, @Parameter(description="The user used for report generation.") @RequestParam(required=false) UUID userId, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the scheduler event name or customer title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.SCHEDULER_EVENT, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        ScheduledReportQuery query = ScheduledReportQuery.builder().reportTemplateId(reportTemplateId).userId(userId).includeCustomers(includeCustomers != null && includeCustomers != false).pageLink(pageLink).build();
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            return (PageData)this.checkNotNull((Object)this.schedulerEventService.findScheduledReportEvents(tenantId, query));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        return (PageData)this.checkNotNull((Object)this.schedulerEventService.findScheduledReportEvents(tenantId, customerId, query));
    }

    @ApiOperation(value="Get Scheduler Events By Ids (getSchedulerEventsByIds)", notes="Requested scheduler events must be owned by tenant or assigned to customer which user is performing the request. Scheduler Events allows you to schedule various types of events with flexible schedule configuration. Scheduler fires configured scheduler events according to their schedule. See the 'Model' tab of the Response Class for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/schedulerEvents"}, params={"schedulerEventIds"})
    public List<SchedulerEventInfo> getSchedulerEventsByIds(@Parameter(description="A list of scheduler event ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="schedulerEventIds") String[] strSchedulerEventIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("schedulerEventIds", strSchedulerEventIds);
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.SCHEDULER_EVENT, Operation.READ)) {
            return Collections.emptyList();
        }
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<SchedulerEventId> schedulerEventIds = new ArrayList<SchedulerEventId>();
        for (String strSchedulerEventId : strSchedulerEventIds) {
            schedulerEventIds.add(new SchedulerEventId(this.toUUID(strSchedulerEventId)));
        }
        List schedulerEvents = (List)this.checkNotNull((Object)((List)this.schedulerEventService.findSchedulerEventInfoByIdsAsync(tenantId, schedulerEventIds).get()));
        return this.filterSchedulerEventsByReadPermission(schedulerEvents);
    }

    private List<SchedulerEventInfo> filterSchedulerEventsByReadPermission(List<SchedulerEventInfo> schedulerEvents) {
        return schedulerEvents.stream().filter(schedulerEvent -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.SCHEDULER_EVENT, Operation.READ, (EntityId)schedulerEvent.getId(), (TenantEntity)schedulerEvent);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ApiOperation(value="Assign scheduler event to edge (assignSchedulerEventToEdge)", notes="Creates assignment of an existing scheduler event to an instance of The Edge. Assignment works in async way - first, notification event pushed to edge service queue on platform. Second, remote edge service will receive a copy of assignment scheduler event (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once scheduler event will be delivered to edge service, it is going to be available for usage on remote edge instance. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/edge/{edgeId}/schedulerEvent/{schedulerEventId}"})
    public SchedulerEventInfo assignSchedulerEventToEdge(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="A string value representing the scheduler id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="schedulerEventId") String strSchedulerEventId) throws ThingsboardException {
        SchedulerEventController.checkParameter((String)"edgeId", (String)strEdgeId);
        SchedulerEventController.checkParameter((String)"schedulerEventId", (String)strSchedulerEventId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
        SchedulerEventId schedulerEventId = new SchedulerEventId(this.toUUID(strSchedulerEventId));
        this.checkSchedulerEventId(schedulerEventId, Operation.READ);
        return this.tbSchedulerService.assignToEdge(schedulerEventId, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign scheduler event from edge (unassignSchedulerEventFromEdge)", notes="Clears assignment of the scheduler event to the edge. Unassignment works in async way - first, 'unassign' notification event pushed to edge queue on platform. Second, remote edge service will receive an 'unassign' command to remove entity group (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once 'unassign' command will be delivered to edge service, it's going to remove entity group and entities inside this group locally.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/edge/{edgeId}/schedulerEvent/{schedulerEventId}"})
    public SchedulerEventInfo unassignSchedulerEventFromEdge(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="A string value representing the scheduler id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="schedulerEventId") String strSchedulerEventId) throws ThingsboardException {
        SchedulerEventController.checkParameter((String)"edgeId", (String)strEdgeId);
        SchedulerEventController.checkParameter((String)"schedulerEventId", (String)strSchedulerEventId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
        SchedulerEventId schedulerEventId = new SchedulerEventId(this.toUUID(strSchedulerEventId));
        this.checkSchedulerEventId(schedulerEventId, Operation.READ);
        return this.tbSchedulerService.unassignFromEdge(schedulerEventId, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Edge Scheduler Events (getEdgeSchedulerEvents)", notes="Returns a page of  Scheduler Events Info objects based on the provided Edge entity. Scheduler Event extends Scheduler Event Info object and adds 'configuration' - a JSON structure of scheduler event configuration. See the 'Model' tab of the Response Class for more details. Scheduler Events allows you to schedule various types of events with flexible schedule configuration. Scheduler fires configured scheduler events according to their schedule. See the 'Model' tab of the Response Class for more details. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edge/{edgeId}/schedulerEvents"}, params={"pageSize", "page"})
    public PageData<SchedulerEventInfo> getEdgeSchedulerEvents(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the scheduler event name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        SchedulerEventController.checkParameter((String)"edgeId", (String)strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.schedulerEventService.findSchedulerEventInfosByTenantIdAndEdgeId(tenantId, edgeId, pageLink));
    }

    @ApiOperation(value="Get All Edge Scheduler Events (getAllEdgeSchedulerEvents)", notes="Fetch the list of Scheduler Event Info objects based on the provided Edge entity. Scheduler Event extends Scheduler Event Info object and adds 'configuration' - a JSON structure of scheduler event configuration. See the 'Model' tab of the Response Class for more details. Scheduler Events allows you to schedule various types of events with flexible schedule configuration. Scheduler fires configured scheduler events according to their schedule. See the 'Model' tab of the Response Class for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edge/{edgeId}/allSchedulerEvents"})
    public List<SchedulerEventInfo> getAllEdgeSchedulerEvents(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId) throws ThingsboardException {
        PageData pageData;
        SchedulerEventController.checkParameter((String)"edgeId", (String)strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        ArrayList result = new ArrayList();
        PageLink pageLink = new PageLink(100);
        do {
            if ((pageData = this.schedulerEventService.findSchedulerEventInfosByTenantIdAndEdgeId(tenantId, edgeId, pageLink)).getData().isEmpty()) continue;
            result.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        return (List)this.checkNotNull(result);
    }

    @ConstructorProperties(value={"tbSchedulerService"})
    @Generated
    public SchedulerEventController(TbSchedulerService tbSchedulerService) {
        this.tbSchedulerService = tbSchedulerService;
    }
}

