/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.QueueController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.queue.TbQueueService;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class QueueController
extends BaseController {
    private final TbQueueService tbQueueService;

    @ApiOperation(value="Get Queues (getTenantQueuesByServiceType)", notes="Returns a page of queues registered in the platform. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/queues"}, params={"serviceType", "pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Queue> getTenantQueuesByServiceType(@Parameter(description="Service type (implemented only for the TB-RULE-ENGINE)", schema=@Schema(allowableValues={"TB-RULE-ENGINE", "TB-CORE", "TB-TRANSPORT", "JS-EXECUTOR"}, requiredMode=Schema.RequiredMode.REQUIRED)) @RequestParam String serviceType, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the queue name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "topic"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        QueueController.checkParameter((String)"serviceType", (String)serviceType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        ServiceType type = ServiceType.of((String)serviceType);
        switch (1.$SwitchMap$org$thingsboard$server$common$msg$queue$ServiceType[type.ordinal()]) {
            case 1: {
                return this.queueService.findQueuesByTenantId(this.getTenantId(), pageLink);
            }
        }
        return new PageData();
    }

    @ApiOperation(value="Get Queue (getQueueById)", notes="Fetch the Queue object based on the provided Queue Id. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/queues/{queueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Queue getQueueById(@Parameter(description="A string value representing the queue id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="queueId") String queueIdStr) throws ThingsboardException {
        QueueController.checkParameter((String)"queueId", (String)queueIdStr);
        QueueId queueId = new QueueId(UUID.fromString(queueIdStr));
        this.checkQueueId(queueId, Operation.READ);
        return (Queue)this.checkNotNull((Object)this.queueService.findQueueById(this.getTenantId(), queueId));
    }

    @ApiOperation(value="Get Queue (getQueueByName)", notes="Fetch the Queue object based on the provided Queue name. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/queues/name/{queueName}"}, method={RequestMethod.GET})
    @ResponseBody
    public Queue getQueueByName(@Parameter(description="A string value representing the queue id. For example, 'Main'") @PathVariable(value="queueName") String queueName) throws ThingsboardException {
        QueueController.checkParameter((String)"queueName", (String)queueName);
        return (Queue)this.checkNotNull((Object)this.queueService.findQueueByTenantIdAndName(this.getTenantId(), queueName));
    }

    @ApiOperation(value="Create Or Update Queue (saveQueue)", notes="Create or update the Queue. When creating queue, platform generates Queue Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). Specify existing Queue id to update the queue. Referencing non-existing Queue Id will cause 'Not Found' error.\n\nQueue name is unique in the scope of sysadmin. Remove 'id', 'tenantId' from the request body example (below) to create new Queue entity. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @RequestMapping(value={"/queues"}, params={"serviceType"}, method={RequestMethod.POST})
    @ResponseBody
    public Queue saveQueue(@Parameter(description="A JSON value representing the queue.") @RequestBody Queue queue, @Parameter(description="Service type (implemented only for the TB-RULE-ENGINE)", schema=@Schema(allowableValues={"TB-RULE-ENGINE", "TB-CORE", "TB-TRANSPORT", "JS-EXECUTOR"}, requiredMode=Schema.RequiredMode.REQUIRED)) @RequestParam String serviceType) throws ThingsboardException {
        QueueController.checkParameter((String)"serviceType", (String)serviceType);
        queue.setTenantId(this.getCurrentUser().getTenantId());
        this.checkEntity((EntityId)((QueueId)queue.getId()), (TenantEntity)queue, Resource.QUEUE);
        ServiceType type = ServiceType.of((String)serviceType);
        switch (1.$SwitchMap$org$thingsboard$server$common$msg$queue$ServiceType[type.ordinal()]) {
            case 1: {
                queue.setTenantId(this.getTenantId());
                Queue savedQueue = this.tbQueueService.saveQueue(queue);
                this.checkNotNull((Object)savedQueue);
                return savedQueue;
            }
        }
        return null;
    }

    @ApiOperation(value="Delete Queue (deleteQueue)", notes="Deletes the Queue. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @RequestMapping(value={"/queues/{queueId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteQueue(@Parameter(description="A string value representing the queue id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="queueId") String queueIdStr) throws ThingsboardException {
        QueueController.checkParameter((String)"queueId", (String)queueIdStr);
        QueueId queueId = new QueueId(this.toUUID(queueIdStr));
        this.checkQueueId(queueId, Operation.DELETE);
        this.tbQueueService.deleteQueue(this.getTenantId(), queueId);
    }

    @ConstructorProperties(value={"tbQueueService"})
    @Generated
    public QueueController(TbQueueService tbQueueService) {
        this.tbQueueService = tbQueueService;
    }
}

