/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.AutoCommitController;
import org.thingsboard.server.controller.OwnerController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.OwnersCacheService;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class OwnerController
extends AutoCommitController {
    public static final String OWNER_ID = "ownerId";
    public static final String ENTITY_TYPE = "entityType";
    public static final String ENTITY_ID = "entityId";
    @Autowired
    private OwnersCacheService ownersCacheService;

    @ApiOperation(value="Change owner to tenant (changeOwnerToTenant)", notes="Tenant changes Owner from Customer or sub-Customer to Tenant. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/owner/TENANT/{ownerId}/{entityType}/{entityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void changeOwnerToTenant(@Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ownerId") String ownerIdStr, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'") @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityId") String entityIdStr, @Parameter(description="An optional list of additional entity group ids") @RequestBody(required=false) String[] strEntityGroupIds) throws ThingsboardException {
        OwnerController.checkParameter((String)"ownerId", (String)ownerIdStr);
        OwnerController.checkParameter((String)"entityType", (String)entityType);
        OwnerController.checkParameter((String)"entityId", (String)entityIdStr);
        TenantId targetOwnerId = TenantId.fromUUID((UUID)UUID.fromString(ownerIdStr));
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
        if (!this.getCurrentUser().getTenantId().equals((Object)targetOwnerId)) {
            throw new ThingsboardException("You aren't authorized to perform this operation!", ThingsboardErrorCode.PERMISSION_DENIED);
        }
        this.checkEntityId(entityId, Operation.CHANGE_OWNER);
        List entityGroups = this.validateEntityGroupIds(strEntityGroupIds, entityId, (EntityId)targetOwnerId);
        this.changeOwner(this.getCurrentUser().getTenantId(), (EntityId)targetOwnerId, entityId);
        if (entityGroups != null) {
            this.addEntityToEntityGroups(this.getCurrentUser().getTenantId(), entityId, entityGroups);
        }
    }

    @ApiOperation(value="Change owner to customer (changeOwnerToCustomer)", notes="Tenant/Customer changes Owner to Customer or sub-Customer. Sub-Customer can`t perform this operation! \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/owner/CUSTOMER/{ownerId}/{entityType}/{entityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void changeOwnerToCustomer(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ownerId") String ownerIdStr, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'") @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityId") String entityIdStr, @Parameter(description="An optional list of additional entity group ids") @RequestBody(required=false) String[] strEntityGroupIds) throws Exception {
        OwnerController.checkParameter((String)"ownerId", (String)ownerIdStr);
        OwnerController.checkParameter((String)"entityType", (String)entityType);
        OwnerController.checkParameter((String)"entityId", (String)entityIdStr);
        SecurityUser currentUser = this.getCurrentUser();
        EntityId currentUserOwnerId = currentUser.getOwnerId();
        CustomerId targetOwnerId = new CustomerId(UUID.fromString(ownerIdStr));
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
        if (!currentUserOwnerId.equals(targetOwnerId)) {
            Customer targetOwner = this.customerService.findCustomerById(currentUser.getTenantId(), targetOwnerId);
            Set targetOwnerOwners = this.ownersCacheService.getOwners(currentUser.getTenantId(), (EntityId)targetOwnerId, (HasOwnerId)targetOwner);
            if (!targetOwnerOwners.contains(currentUserOwnerId)) {
                throw new ThingsboardException("You aren't authorized to perform this operation!", ThingsboardErrorCode.PERMISSION_DENIED);
            }
        }
        List entityGroups = this.validateEntityGroupIds(strEntityGroupIds, entityId, (EntityId)targetOwnerId);
        this.changeOwner(currentUser.getTenantId(), (EntityId)targetOwnerId, entityId);
        if (entityGroups != null) {
            this.addEntityToEntityGroups(currentUser.getTenantId(), entityId, entityGroups);
        }
    }

    private EntityId changeOwner(TenantId tenantId, EntityId targetOwnerId, EntityId entityId) throws ThingsboardException {
        try {
            EntityId previousOwnerId;
            switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
                case 1: {
                    Device device = this.checkDeviceId(new DeviceId(entityId.getId()), Operation.CHANGE_OWNER);
                    previousOwnerId = device.getOwnerId();
                    this.ownersCacheService.changeDeviceOwner(tenantId, targetOwnerId, device);
                    this.logChangeOwnerAction((EntityId)device.getId(), (HasName)device, targetOwnerId);
                    break;
                }
                case 2: {
                    Asset asset = this.checkAssetId(new AssetId(entityId.getId()), Operation.CHANGE_OWNER);
                    previousOwnerId = asset.getOwnerId();
                    this.ownersCacheService.changeAssetOwner(tenantId, targetOwnerId, asset);
                    this.logChangeOwnerAction((EntityId)asset.getId(), (HasName)asset, targetOwnerId);
                    break;
                }
                case 3: {
                    EntityView entityView = this.checkEntityViewId(new EntityViewId(entityId.getId()), Operation.CHANGE_OWNER);
                    previousOwnerId = entityView.getOwnerId();
                    this.ownersCacheService.changeEntityViewOwner(tenantId, targetOwnerId, entityView);
                    this.logChangeOwnerAction((EntityId)entityView.getId(), (HasName)entityView, targetOwnerId);
                    break;
                }
                case 4: {
                    Edge edge = this.checkEdgeId(new EdgeId(entityId.getId()), Operation.CHANGE_OWNER);
                    previousOwnerId = edge.getOwnerId();
                    this.ownersCacheService.changeEdgeOwner(tenantId, targetOwnerId, edge);
                    this.logChangeOwnerAction((EntityId)edge.getId(), (HasName)edge, targetOwnerId);
                    break;
                }
                case 5: {
                    Customer customer = this.checkCustomerId(new CustomerId(entityId.getId()), Operation.CHANGE_OWNER);
                    previousOwnerId = customer.getOwnerId();
                    this.ownersCacheService.changeCustomerOwner(tenantId, targetOwnerId, customer);
                    this.logChangeOwnerAction((EntityId)customer.getId(), (HasName)customer, targetOwnerId);
                    break;
                }
                case 6: {
                    User user = this.checkUserId(new UserId(entityId.getId()), Operation.CHANGE_OWNER);
                    previousOwnerId = user.getOwnerId();
                    this.ownersCacheService.changeUserOwner(tenantId, targetOwnerId, user);
                    this.logChangeOwnerAction((EntityId)user.getId(), (HasName)user, targetOwnerId);
                    break;
                }
                case 7: {
                    Dashboard dashboard = this.checkDashboardId(new DashboardId(entityId.getId()), Operation.CHANGE_OWNER);
                    previousOwnerId = dashboard.getOwnerId();
                    this.ownersCacheService.changeDashboardOwner(tenantId, targetOwnerId, dashboard);
                    this.logChangeOwnerAction((EntityId)dashboard.getId(), (HasName)dashboard, targetOwnerId);
                    break;
                }
                default: {
                    throw new ThingsboardException("EntityType does not support owner change: " + String.valueOf(entityId.getEntityType()), ThingsboardErrorCode.BAD_REQUEST_PARAMS);
                }
            }
            return previousOwnerId;
        }
        catch (ThingsboardException e) {
            this.logEntityActionService.logEntityAction(tenantId, entityId, ActionType.CHANGE_OWNER, (User)this.getCurrentUser(), (Exception)((Object)e), new Object[0]);
            throw e;
        }
    }

    private List<EntityGroup> validateEntityGroupIds(String[] strEntityGroupIds, EntityId entityId, EntityId targetOwnerId) throws ThingsboardException {
        ArrayList<EntityGroupInfo> entityGroups = null;
        if (strEntityGroupIds != null && strEntityGroupIds.length > 0) {
            this.checkArrayParameter("strEntityGroupIds", strEntityGroupIds);
            entityGroups = new ArrayList<EntityGroupInfo>();
            for (String strEntityGroupId : strEntityGroupIds) {
                EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
                EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.ADD_TO_GROUP);
                if (!entityGroup.getOwnerId().equals(targetOwnerId)) {
                    throw new ThingsboardException("Unable to add entity to entity group with different owner!", ThingsboardErrorCode.PERMISSION_DENIED);
                }
                if (entityGroup.getType() != entityId.getEntityType()) {
                    throw new ThingsboardException("Unable to add entity to entity group with different type!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
                }
                if (entityGroup.isGroupAll()) {
                    throw new ThingsboardException("Unable to add entity to entity group: Addition to entity group 'All' is forbidden!", ThingsboardErrorCode.PERMISSION_DENIED);
                }
                entityGroups.add(entityGroup);
            }
        }
        return entityGroups;
    }

    private void addEntityToEntityGroups(TenantId tenantId, EntityId entityId, List<EntityGroup> entityGroups) throws ThingsboardException {
        for (EntityGroup entityGroup : entityGroups) {
            this.entityGroupService.addEntityToEntityGroup(tenantId, entityGroup.getId(), entityId);
            if (entityGroup.getType() == EntityType.USER) {
                this.userPermissionsService.onUserUpdatedOrRemoved(this.userService.findUserById(this.getTenantId(), new UserId(entityId.getId())));
            } else if (entityGroup.getType() == EntityType.DEVICE) {
                DeviceGroupOtaPackage fw = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupIdAndType(entityGroup.getId(), OtaPackageType.FIRMWARE);
                DeviceGroupOtaPackage sw = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupIdAndType(entityGroup.getId(), OtaPackageType.SOFTWARE);
                if (fw != null || sw != null) {
                    List<DeviceId> deviceIds = Collections.singletonList(new DeviceId(entityId.getId()));
                    this.otaPackageStateService.update(this.getTenantId(), deviceIds, fw != null, sw != null);
                }
            }
            this.logEntityActionService.logEntityAction(this.getTenantId(), entityId, null, ActionType.ADDED_TO_ENTITY_GROUP, (User)this.getCurrentUser(), new Object[]{entityId.toString(), entityGroup.getUuidId().toString(), entityGroup.getName()});
        }
    }

    private <E extends HasName, I extends EntityId> void logChangeOwnerAction(I entityId, E entity, EntityId targetOwnerId) throws ThingsboardException {
        this.logEntityActionService.logEntityAction(this.getTenantId(), entityId, entity, ActionType.CHANGE_OWNER, (User)this.getCurrentUser(), new Object[]{targetOwnerId});
    }
}

