/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.NameConflictStrategy;
import org.thingsboard.server.common.data.SaveDeviceWithCredentialsRequest;
import org.thingsboard.server.common.data.device.profile.lwm2m.bootstrap.LwM2MServerSecurityConfigDefault;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.DeviceController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.lwm2m.LwM2MService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class Lwm2mController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Lwm2mController.class);
    @Autowired
    private DeviceController deviceController;
    @Autowired
    private LwM2MService lwM2MService;
    public static final String IS_BOOTSTRAP_SERVER = "isBootstrapServer";

    @ApiOperation(value="Get Lwm2m Bootstrap SecurityInfo (getLwm2mBootstrapSecurityInfo)", notes="Get the Lwm2m Bootstrap SecurityInfo object (of the current server) based on the provided isBootstrapServer parameter. If isBootstrapServer == true, get the parameters of the current Bootstrap Server. If isBootstrapServer == false, get the parameters of the current Lwm2m Server. Used for client settings when starting the client in Bootstrap mode. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/lwm2m/deviceProfile/bootstrap/{isBootstrapServer}"}, method={RequestMethod.GET})
    @ResponseBody
    public LwM2MServerSecurityConfigDefault getLwm2mBootstrapSecurityInfo(@Parameter(description="A Boolean value representing the Server SecurityInfo for future Bootstrap client mode settings. Values: 'true' for Bootstrap Server; 'false' for Lwm2m Server. ") @PathVariable(value="isBootstrapServer") boolean bootstrapServer) throws ThingsboardException {
        return this.lwM2MService.getServerSecurityInfo(bootstrapServer);
    }

    @ApiOperation(hidden=true, value="Save device with credentials (Deprecated)")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/lwm2m/device-credentials"}, method={RequestMethod.POST})
    @ResponseBody
    public Device saveDeviceWithCredentials(@RequestBody Map<Class<?>, Object> deviceWithDeviceCredentials, @RequestParam(name="entityGroupId", required=false) String strEntityGroupId) throws ThingsboardException {
        Device device = (Device)this.checkNotNull((Object)((Device)JacksonUtil.convertValue((Object)deviceWithDeviceCredentials.get(Device.class), Device.class)));
        DeviceCredentials credentials = (DeviceCredentials)this.checkNotNull((Object)((DeviceCredentials)JacksonUtil.convertValue((Object)deviceWithDeviceCredentials.get(DeviceCredentials.class), DeviceCredentials.class)));
        return this.deviceController.saveDeviceWithCredentials(new SaveDeviceWithCredentialsRequest(device, credentials), strEntityGroupId, null, NameConflictStrategy.DEFAULT.policy(), NameConflictStrategy.DEFAULT.separator(), NameConflictStrategy.DEFAULT.uniquifyStrategy());
    }
}

