/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.ListenableFuture;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.EntityViewInfo;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.NameConflictPolicy;
import org.thingsboard.server.common.data.NameConflictStrategy;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.UniquifyStrategy;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.entityview.EntityViewSearchQuery;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class EntityViewController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityViewController.class);
    public final TbEntityViewService tbEntityViewService;
    public static final String ENTITY_VIEW_ID = "entityViewId";

    @ApiOperation(value="Get entity view (getEntityViewById)", notes="Fetch the EntityView object based on the provided entity view id. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. See the 'Model' tab for more details.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityView/{entityViewId}"})
    public EntityView getEntityViewById(@Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        EntityViewController.checkParameter((String)"entityViewId", (String)strEntityViewId);
        return this.checkEntityViewId(new EntityViewId(this.toUUID(strEntityViewId)), Operation.READ);
    }

    @ApiOperation(value="Get entity view info (getEntityViewInfoById)", notes="Fetch the Entity View info object based on the provided entity view id. Entity Views Info extends the Entity View with owner name. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. See the 'Model' tab for more details.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityView/info/{entityViewId}"})
    public EntityViewInfo getEntityViewInfoById(@Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        EntityViewController.checkParameter((String)"entityViewId", (String)strEntityViewId);
        return this.checkEntityViewInfoId(new EntityViewId(this.toUUID(strEntityViewId)), Operation.READ);
    }

    @ApiOperation(value="Save or update entity view (saveEntityView)", notes="Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. See the 'Model' tab for more details.Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Entity View entity.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityView"})
    public EntityView saveEntityView(@Parameter(description="A JSON object representing the entity view.") @RequestBody EntityView entityView, @RequestParam(name="entityGroupId", required=false) String strEntityGroupId, @Parameter(description="A list of entity group ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="entityGroupIds", required=false) String[] strEntityGroupIds, @Parameter(description="Optional value of name conflict policy. Possible values: FAIL or UNIQUIFY.  If omitted, FAIL policy is applied. FAIL policy implies exception will be thrown if an entity with the same name already exists.  UNIQUIFY policy appends a suffix to the entity name, if a name conflict occurs.") @RequestParam(name="nameConflictPolicy", defaultValue="FAIL") NameConflictPolicy nameConflictPolicy, @Parameter(description="Optional value of name suffix separator used by UNIQUIFY policy. By default, underscore separator is used. For example, strategy is UNIQUIFY, separator is '-'; if a name conflict occurs for entity name 'test-name', created entity will have name like 'test-name-7fsh4f'.") @RequestParam(name="uniquifySeparator", defaultValue="_") String uniquifySeparator, @Parameter(description="Optional value of uniquify strategy used by UNIQUIFY policy. Possible values: RANDOM or INCREMENTAL. By default, RANDOM strategy is used, which means random alphanumeric string will be added as a suffix to entity name. INCREMENTAL implies the first possible number starting from 1 will be added as a name suffix. For example, strategy is UNIQUIFY, uniquify strategy is INCREMENTAL; if a name conflict occurs for entity name 'test-name', created entity will have name like 'test-name-1.") @RequestParam(name="uniquifyStrategy", defaultValue="RANDOM") UniquifyStrategy uniquifyStrategy) throws Exception {
        SecurityUser user = this.getCurrentUser();
        return (EntityView)this.saveGroupEntity((GroupEntity)entityView, strEntityGroupId, strEntityGroupIds, (entityView1, entityGroups) -> {
            try {
                return this.tbEntityViewService.save(entityView1, entityGroups, new NameConflictStrategy(nameConflictPolicy, uniquifySeparator, uniquifyStrategy), user);
            }
            catch (Exception e) {
                throw this.handleException(e);
            }
        });
    }

    @ApiOperation(value="Delete entity view (deleteEntityView)", notes="Delete the EntityView object based on the provided entity view id. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/entityView/{entityViewId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteEntityView(@Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        EntityViewController.checkParameter((String)"entityViewId", (String)strEntityViewId);
        EntityViewId entityViewId = new EntityViewId(this.toUUID(strEntityViewId));
        EntityView entityView = this.checkEntityViewId(entityViewId, Operation.DELETE);
        this.tbEntityViewService.delete((Object)entityView, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Entity View by name (getTenantEntityView)", notes="Fetch the Entity View object based on the tenant id and entity view name. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/tenant/entityViews"}, params={"entityViewName"})
    public EntityView getTenantEntityView(@Parameter(description="Entity View name") @RequestParam String entityViewName) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (EntityView)this.checkNotNull((Object)this.entityViewService.findEntityViewByTenantIdAndName(tenantId, entityViewName));
    }

    @ApiOperation(value="Get Customer Entity Views (getCustomerEntityViews)", notes="Returns a page of Entity View objects assigned to customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customer/{customerId}/entityViews"}, params={"pageSize", "page"})
    public PageData<EntityView> getCustomerEntityViews(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityViewController.checkParameter((String)"customerId", (String)strCustomerId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && !type.trim().isEmpty()) {
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewsByTenantIdAndCustomerIdAndType(tenantId, customerId, pageLink, type));
        }
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewsByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Tenant Entity Views (getTenantEntityViews)", notes="Returns a page of entity views owned by tenant. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/tenant/entityViews"}, params={"pageSize", "page"})
    public PageData<EntityView> getTenantEntityViews(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && !type.trim().isEmpty()) {
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewByTenantIdAndType(tenantId, pageLink, type));
        }
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Entity Views (getUserEntityViews)", notes="Returns a page of entity views that are available for the current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/entityViews"}, params={"pageSize", "page"})
    public PageData<EntityView> getUserEntityViews(@Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser currentUser = this.getCurrentUser();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        return this.entityService.findUserEntities(currentUser.getTenantId(), currentUser.getCustomerId(), mergedUserPermissions, EntityType.ENTITY_VIEW, Operation.READ, type, pageLink);
    }

    @ApiOperation(value="Get All Entity View Infos for current user (getAllEntityViewInfos)", notes="Returns a page of entity view info objects owned by the tenant or the customer of a current user. Entity Views Info extends the Entity View with owner name. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers.  You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityViewInfos/all"}, params={"pageSize", "page"})
    public PageData<EntityViewInfo> getAllEntityViewInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            if (includeCustomers != null && includeCustomers.booleanValue()) {
                if (type != null && !type.isEmpty()) {
                    return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndType(tenantId, type, pageLink));
                }
                return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantId(tenantId, pageLink));
            }
            if (type != null && !type.isEmpty()) {
                return (PageData)this.checkNotNull((Object)this.entityViewService.findTenantEntityViewInfosByTenantIdAndType(tenantId, type, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.entityViewService.findTenantEntityViewInfosByTenantId(tenantId, pageLink));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            if (type != null && !type.isEmpty()) {
                return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerIdAndTypeIncludingSubCustomers(tenantId, customerId, type, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        if (type != null && !type.isEmpty()) {
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Customer Entity View Infos (getCustomerEntityViewInfos)", notes="Returns a page of entity view info objects owned by the specified customer. Entity Views Info extends the Entity View with owner name. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers.  You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customer/{customerId}/entityViewInfos"}, params={"pageSize", "page"})
    public PageData<EntityViewInfo> getCustomerEntityViewInfos(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityViewController.checkParameter((String)"customerId", (String)strCustomerId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            if (type != null && !type.isEmpty()) {
                return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerIdAndTypeIncludingSubCustomers(tenantId, customerId, type, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        if (type != null && !type.isEmpty()) {
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Entity Views By Ids (getEntityViewsByIds)", notes="Requested entity views must be owned by tenant or assigned to customer which user is performing the request. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityViews"}, params={"entityViewIds"})
    public List<EntityView> getEntityViewsByIds(@Parameter(description="A list of entity view ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="entityViewIds") Set<UUID> entityViewUUIDs) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<EntityViewId> entityViewIds = new ArrayList<EntityViewId>();
        for (UUID entityViewUUID : entityViewUUIDs) {
            entityViewIds.add(new EntityViewId(entityViewUUID));
        }
        List entityViews = this.entityViewService.findEntityViewsByTenantIdAndIds(tenantId, entityViewIds);
        return this.filterEntityViewsByReadPermission(entityViews);
    }

    @ApiOperation(value="Find related entity views (findByQuery)", notes="Returns all entity views that are related to the specific entity. The entity id, relation type, entity view types, depth of the search, and other query parameters defined using complex 'EntityViewSearchQuery' object. See 'Model' tab of the Parameters for more info.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/entityViews"})
    public List<EntityView> findByQuery(@Parameter(description="The entity view search query JSON") @RequestBody EntityViewSearchQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull((Object)query);
        this.checkNotNull((Object)query.getParameters());
        this.checkNotNull((Object)query.getEntityViewTypes());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        List entityViews = (List)this.checkNotNull((Object)((List)this.entityViewService.findEntityViewsByQuery(this.getTenantId(), query).get()));
        return this.filterEntityViewsByReadPermission(entityViews);
    }

    @ApiOperation(value="Get entity views by Entity Group Id (getEntityViewsByEntityGroupId)", notes="Returns a page of Entity View objects that belongs to specified Entity View Id. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/{entityGroupId}/entityViews"}, params={"pageSize", "page"})
    public PageData<EntityView> getEntityViewsByEntityGroupId(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        EntityViewController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        this.checkEntityGroupType(EntityType.ENTITY_VIEW, entityGroup.getType());
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewsByEntityGroupId(entityGroupId, pageLink));
    }

    private List<EntityView> filterEntityViewsByReadPermission(List<EntityView> entityViews) {
        return entityViews.stream().filter(entityView -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.READ, (EntityId)entityView.getId(), (TenantEntity)entityView);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ApiOperation(value="Get Entity View Types (getEntityViewTypes)", notes="Returns a set of unique entity view types based on entity views that are either owned by the tenant or assigned to the customer which user is performing the request.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityView/types"})
    public List<EntitySubtype> getEntityViewTypes() throws ThingsboardException, ExecutionException, InterruptedException {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.ENTITY_VIEW, Operation.READ);
        TenantId tenantId = user.getTenantId();
        ListenableFuture entityViewTypes = this.entityViewService.findEntityViewTypesByTenantId(tenantId);
        return (List)this.checkNotNull((Object)((List)entityViewTypes.get()));
    }

    @ConstructorProperties(value={"tbEntityViewService"})
    @Generated
    public EntityViewController(TbEntityViewService tbEntityViewService) {
        this.tbEntityViewService = tbEntityViewService;
    }
}

