/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.sync.vc.BranchInfo;
import org.thingsboard.server.common.data.sync.vc.EntityDataDiff;
import org.thingsboard.server.common.data.sync.vc.EntityDataInfo;
import org.thingsboard.server.common.data.sync.vc.EntityVersion;
import org.thingsboard.server.common.data.sync.vc.VersionCreationResult;
import org.thingsboard.server.common.data.sync.vc.VersionLoadResult;
import org.thingsboard.server.common.data.sync.vc.VersionedEntityInfo;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateRequest;
import org.thingsboard.server.common.data.sync.vc.request.load.VersionLoadRequest;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/entities/vc"})
@PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
public class EntitiesVersionControlController
extends BaseController {
    private final EntitiesVersionControlService versionControlService;
    @Value(value="${queue.vc.request-timeout:180000}")
    private int vcRequestTimeout;

    @ApiOperation(value="Save entities version (saveEntitiesVersion)", notes="Creates a new version of entities (or a single entity) by request.\nSupported entity types: CUSTOMER, ASSET, RULE_CHAIN, DASHBOARD, DEVICE_PROFILE, DEVICE, ENTITY_VIEW, WIDGETS_BUNDLE, CONVERTER, INTEGRATION, ROLE and USER group.\n\nThere are two available types of request: `SINGLE_ENTITY` and `COMPLEX`. Each of them contains version name (`versionName`) and name of a branch (`branch`) to create version (commit) in. If specified branch does not exists in a remote repo, then new empty branch will be created. Request of the `SINGLE_ENTITY` type has id of an entity (`entityId`) and additional configuration (`config`) which has following options: \n- `saveRelations` - whether to add inbound and outbound relations of type COMMON to created entity version;\n- `saveAttributes` - to save attributes of server scope (and also shared scope for devices);\n- `saveCredentials` - when saving a version of a device, to add its credentials to the version;\n- `savePermissions` - when saving a user group - to save group permission list;\n- `saveGroupEntities` - when saving an entity group - to save its entities as well.\n\nAn example of a `SINGLE_ENTITY` version create request:\n```json\n{\n  \"type\": \"SINGLE_ENTITY\",\n\n  \"versionName\": \"Version 1.0\",\n  \"branch\": \"dev\",\n\n  \"entityId\": {\n    \"entityType\": \"DEVICE\",\n    \"id\": \"b79448e0-d4f4-11ec-847b-0f432358ab48\"\n  },\n  \"config\": {\n    \"saveRelations\": true,\n    \"saveAttributes\": true,\n    \"saveCredentials\": false\n  }\n}\n```\n\nSecond request type (`COMPLEX`), additionally to `branch` and `versionName`, contains following properties:\n- `entityTypes` - a structure with entity types to export and configuration for each entity type;    this configuration has all the options available for `SINGLE_ENTITY` and additionally has these ones: \n     - `allEntities` and `entityIds` - if you want to save the version of all entities of the entity type         then set `allEntities` param to true, otherwise set it to false and specify `entityIds` -         in case entity type is group entity, list of specific entity groups, or if not - list of entities;\n     - `syncStrategy` - synchronization strategy to use for this entity type: when set to `OVERWRITE`         then the list of remote entities of this type will be overwritten by newly added entities. If set to         `MERGE` - existing remote entities of this entity type will not be removed, new entities will just         be added on top (or existing remote entities will be updated).\n- `syncStrategy` - default synchronization strategy to use when it is not specified for an entity type.\n\nExample for this type of request:\n```json\n{\n  \"type\": \"COMPLEX\",\n\n  \"versionName\": \"Devices and profiles: release 2\",\n  \"branch\": \"master\",\n\n  \"syncStrategy\": \"OVERWRITE\",\n  \"entityTypes\": {\n    \"DEVICE\": {\n      \"syncStrategy\": null,\n      \"allEntities\": true,\n      \"saveRelations\": true,\n      \"saveAttributes\": true,\n      \"saveCredentials\": true\n    },\n    \"DEVICE_PROFILE\": {\n      \"syncStrategy\": \"MERGE\",\n      \"allEntities\": false,\n      \"entityIds\": [\n        \"b79448e0-d4f4-11ec-847b-0f432358ab48\"\n      ],\n      \"saveRelations\": true\n    }\n  }\n}\n```\n\nResponse wil contain generated request UUID, that can be then used to retrieve status of operation via `getVersionCreateRequestStatus`.\n\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/version"})
    public DeferredResult<UUID> saveEntitiesVersion(@RequestBody VersionCreateRequest request) throws Exception {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.WRITE);
        return this.wrapFuture(this.versionControlService.saveEntitiesVersion((User)user, request));
    }

    @ApiOperation(value="Get version create request status (getVersionCreateRequestStatus)", notes="Returns the status of previously made version create request. \n\nThis status contains following properties:\n- `done` - whether request processing is finished;\n- `version` - created version info: timestamp, version id (commit hash), commit name and commit author;\n- `added` - count of items that were created in the remote repo;\n- `modified` - modified items count;\n- `removed` - removed items count;\n- `error` - error message, if an error occurred while handling the request.\n\nAn example of successful status:\n```json\n{\n  \"done\": true,\n  \"added\": 10,\n  \"modified\": 2,\n  \"removed\": 5,\n  \"version\": {\n    \"timestamp\": 1655198528000,\n    \"id\":\"8a834dd389ed80e0759ba8ee338b3f1fd160a114\",\n    \"name\": \"My devices v2.0\",\n    \"author\": \"John Doe\"\n  },\n  \"error\": null\n}\n```\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/version/{requestId}/status"})
    public VersionCreationResult getVersionCreateRequestStatus(@Parameter(description="A string value representing the version control request id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable UUID requestId) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.WRITE);
        return this.versionControlService.getVersionCreateStatus((User)this.getCurrentUser(), requestId);
    }

    @ApiOperation(value="List entity versions (listEntityVersions)", notes="Returns list of versions for a specific entity in a concrete branch. \nYou need to specify external id of an entity to list versions for. This is `externalId` property of an entity, or otherwise if not set - simply id of this entity. \nIf specified branch does not exist - empty page data will be returned. \n\nEach version info item has timestamp, id, name and author. Version id can then be used to restore the version. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nResponse example: \n```json\n{\n  \"data\": [\n    {\n      \"timestamp\": 1655198593000,\n      \"id\": \"fd82625bdd7d6131cf8027b44ee967012ecaf990\",\n      \"name\": \"Devices and assets - v2.0\",\n      \"author\": \"John Doe <johndoe@gmail.com>\"\n    },\n    {\n      \"timestamp\": 1655198528000,\n      \"id\": \"682adcffa9c8a2f863af6f00c4850323acbd4219\",\n      \"name\": \"Update my device\",\n      \"author\": \"John Doe <johndoe@gmail.com>\"\n    },\n    {\n      \"timestamp\": 1655198280000,\n      \"id\": \"d2a6087c2b30e18cc55e7cdda345a8d0dfb959a4\",\n      \"name\": \"Devices and assets - v1.0\",\n      \"author\": \"John Doe <johndoe@gmail.com>\"\n    }\n  ],\n  \"totalPages\": 1,\n  \"totalElements\": 3,\n  \"hasNext\": false\n}\n```\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/version/{entityType}/{externalEntityUuid}"}, params={"branch", "pageSize", "page"})
    public DeferredResult<PageData<EntityVersion>> listEntityVersions(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable EntityType entityType, @Parameter(description="A string value representing external entity id. This is `externalId` property of an entity, or otherwise if not set - simply id of this entity.") @PathVariable UUID externalEntityUuid, @Parameter(description="The name of the working branch, for example 'master'") @RequestParam String branch, @RequestParam(required=false, value="internalEntityId") UUID internalEntityUuid, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the entity version name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"timestamp"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        EntityId externalEntityId = EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)externalEntityUuid);
        EntityId internalEntityId = internalEntityUuid != null ? EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)internalEntityUuid) : null;
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.wrapFuture(this.versionControlService.listEntityVersions(this.getTenantId(), branch, externalEntityId, internalEntityId, pageLink));
    }

    @ApiOperation(value="List entity type versions (listEntityTypeVersions)", notes="Returns list of versions of an entity type in a branch. This is a collected list of versions that were created for entities of this type in a remote branch. \nIf specified branch does not exist - empty page data will be returned. The response structure is the same as for `listEntityVersions` API method.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/version/{entityType}"}, params={"branch", "pageSize", "page"})
    public DeferredResult<PageData<EntityVersion>> listEntityTypeVersions(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable EntityType entityType, @Parameter(description="The name of the working branch, for example 'master'", required=true) @RequestParam String branch, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the entity version name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"timestamp"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.wrapFuture(this.versionControlService.listEntityTypeVersions(this.getTenantId(), branch, entityType, pageLink));
    }

    @ApiOperation(value="List all versions (listVersions)", notes="Lists all available versions in a branch for all entity types. \nIf specified branch does not exist - empty page data will be returned. The response format is the same as for `listEntityVersions` API method.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/version"}, params={"branch", "pageSize", "page"})
    public DeferredResult<PageData<EntityVersion>> listVersions(@Parameter(description="The name of the working branch, for example 'master'", required=true) @RequestParam String branch, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the entity version name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"timestamp"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.wrapFuture(this.versionControlService.listVersions(this.getTenantId(), branch, pageLink));
    }

    @ApiOperation(value="List entities at version (listEntitiesAtVersion)", notes="Returns a list of remote entities of a specific entity type that are available at a concrete version. \nEach entity item in the result has `externalId` property. Entities order will be the same as in the repository.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/entity/{entityType}/{versionId}"})
    public DeferredResult<List<VersionedEntityInfo>> listEntitiesAtVersion(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable EntityType entityType, @Parameter(description="Version id, for example fd82625bdd7d6131cf8027b44ee967012ecaf990. Represents commit hash.", required=true) @PathVariable String versionId) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        return this.wrapFuture(this.versionControlService.listEntitiesAtVersion(this.getTenantId(), versionId, entityType));
    }

    @ApiOperation(value="List all entities at version (listAllEntitiesAtVersion)", notes="Returns a list of all remote entities available in a specific version. Response type is the same as for listAllEntitiesAtVersion API method. \nReturned entities order will be the same as in the repository.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/entity/{versionId}"})
    public DeferredResult<List<VersionedEntityInfo>> listAllEntitiesAtVersion(@Parameter(description="Version id, for example fd82625bdd7d6131cf8027b44ee967012ecaf990. Represents commit hash.", required=true) @PathVariable String versionId) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        return this.wrapFuture(this.versionControlService.listAllEntitiesAtVersion(this.getTenantId(), versionId));
    }

    @ApiOperation(value="Get entity data info (getEntityDataInfo)", notes="Retrieves short info about the remote entity by external id at a concrete version. \nReturned entity data info contains following properties: `hasRelations` (whether stored entity data contains relations), `hasAttributes` (contains attributes), `hasCredentials` (whether stored device data has credentials), `hasPermissions` (user group data contains group permission list) and `hasGroupEntities` (entity group data contains group entities).\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/info/{versionId}/{entityType}/{externalEntityUuid}"})
    public DeferredResult<EntityDataInfo> getEntityDataInfo(@Parameter(description="Version id, for example fd82625bdd7d6131cf8027b44ee967012ecaf990. Represents commit hash.", required=true) @PathVariable String versionId, @Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable EntityType entityType, @Parameter(description="A string value representing external entity id", required=true) @PathVariable UUID externalEntityUuid, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false, value="internalEntityId") UUID internalEntityUuid) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        EntityId externalId = EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)externalEntityUuid);
        EntityId internalId = internalEntityUuid != null ? EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)internalEntityUuid) : null;
        return this.wrapFuture(this.versionControlService.getEntityDataInfo((User)this.getCurrentUser(), externalId, internalId, versionId));
    }

    @ApiOperation(value="Compare entity data to version (compareEntityDataToVersion)", notes="Returns an object with current entity data and the one at a specific version. Entity data structure is the same as stored in a repository. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/diff/{entityType}/{internalEntityUuid}"}, params={"versionId"})
    public DeferredResult<EntityDataDiff> compareEntityDataToVersion(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable EntityType entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable UUID internalEntityUuid, @Parameter(description="Version id, for example fd82625bdd7d6131cf8027b44ee967012ecaf990. Represents commit hash.", required=true) @RequestParam String versionId) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)internalEntityUuid);
        return this.wrapFuture(this.versionControlService.compareEntityDataToVersion((User)this.getCurrentUser(), entityId, versionId));
    }

    @ApiOperation(value="Load entities version (loadEntitiesVersion)", notes="Loads specific version of remote entities (or single entity) by request. Supported entity types: CUSTOMER, ASSET, RULE_CHAIN, DASHBOARD, DEVICE_PROFILE, DEVICE, ENTITY_VIEW, WIDGETS_BUNDLE, CONVERTER, INTEGRATION, ROLE and USER group.\n\nThere are multiple types of request. Each of them requires branch name (`branch`) and version id (`versionId`). Request of type `SINGLE_ENTITY` is needed to restore a concrete version of a specific entity. It contains id of a remote entity (`externalEntityId`), internal entity id (`internalEntityId`) and additional configuration (`config`):\n- `loadRelations` - to update relations list (in case `saveRelations` option was enabled during version creation);\n- `loadAttributes` - to load entity attributes (if `saveAttributes` config option was enabled);\n- `loadCredentials` - to update device credentials (if `saveCredentials` option was enabled during version creation);\n- `loadPermissions` - when loading user group, to update group permission list;\n- `loadGroupEntities` - when loading an entity group, to load its entities as well;\n- `autoGenerateIntegrationKey` - if loading integration version, to autogenerate routing key.\n\nAn example of such request:\n```json\n{\n  \"type\": \"SINGLE_ENTITY\",\n  \n  \"branch\": \"dev\",\n  \"versionId\": \"b3c28d722d328324c7c15b0b30047b0c40011cf7\",\n  \n  \"externalEntityId\": {\n    \"entityType\": \"DEVICE\",\n    \"id\": \"b7944123-d4f4-11ec-847b-0f432358ab48\"\n  },\n  \"config\": {\n    \"loadRelations\": false,\n    \"loadAttributes\": true,\n    \"loadCredentials\": true\n  }\n}\n```\n\nAnother request type (`ENTITY_TYPE`) is needed to load specific version of the whole entity types. It contains a structure with entity types to load and configs for each entity type (`entityTypes`). For each specified entity type, the method will load all remote entities of this type that are present at the version. A config for each entity type contains the same options as in `SINGLE_ENTITY` request type, and additionally contains following options:\n- `removeOtherEntities` - to remove local entities that are not present on the remote - basically to    overwrite local entity type with the remote one;\n- `findExistingEntityByName` - when you are loading some remote entities that are not yet present at this tenant,    try to find existing entity by name and update it rather than create new.\n\nHere is an example of the request to completely restore version of the whole device entity type:\n```json\n{\n  \"type\": \"ENTITY_TYPE\",\n\n  \"branch\": \"dev\",\n  \"versionId\": \"b3c28d722d328324c7c15b0b30047b0c40011cf7\",\n\n  \"entityTypes\": {\n    \"DEVICE\": {\n      \"removeOtherEntities\": true,\n      \"findExistingEntityByName\": false,\n      \"loadRelations\": true,\n      \"loadAttributes\": true,\n      \"loadCredentials\": true\n    }\n  }\n}\n```\n\nThe response will contain generated request UUID that is to be used to check the status of operation via `getVersionLoadRequestStatus`.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/entity"})
    public UUID loadEntitiesVersion(@RequestBody VersionLoadRequest request) throws Exception {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.VERSION_CONTROL, Operation.WRITE);
        return this.versionControlService.loadEntitiesVersion((User)user, request);
    }

    @ApiOperation(value="Get version load request status (getVersionLoadRequestStatus)", notes="Returns the status of previously made version load request. The structure contains following parameters:\n- `done` - if the request was successfully processed;\n- `result` - a list of load results for each entity type:\n     - `created` - created entities count;\n     - `updated` - updated entities count;\n     - `deleted` - removed entities count;\n     - `groupsCreated` - created entity groups count;\n     - `groupsUpdated` - updated entity groups count;\n     - `groupsDeleted` - removed entity groups count.\n- `error` - if an error occurred during processing, error info:\n     - `type` - error type;\n     - `source` - an external id of remote entity;\n     - `target` - if failed to find referenced entity by external id - this external id;\n     - `message` - error message.\n\nAn example of successfully processed request status:\n```json\n{\n  \"done\": true,\n  \"result\": [\n    {\n      \"entityType\": \"DEVICE\",\n      \"created\": 10,\n      \"updated\": 5,\n      \"deleted\": 5,\n      \"groupsCreated\": 1,\n      \"groupsUpdated\": 1,\n      \"groupsDeleted\": 1\n    },\n     {\n      \"entityType\": \"ASSET\",\n      \"created\": 4,\n      \"updated\": 0,\n      \"deleted\": 8,\n      \"groupsCreated\": 1,\n      \"groupsUpdated\": 0,\n      \"groupsDeleted\": 2\n    }\n  ]\n}\n```\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/entity/{requestId}/status"})
    public VersionLoadResult getVersionLoadRequestStatus(@Parameter(description="A string value representing the version control request id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable UUID requestId) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.WRITE);
        return this.versionControlService.getVersionLoadStatus((User)this.getCurrentUser(), requestId);
    }

    @ApiOperation(value="List branches (listBranches)", notes="Lists branches available in the remote repository. \n\nResponse example: \n```json\n[\n  {\n    \"name\": \"master\",\n    \"default\": true\n  },\n  {\n    \"name\": \"dev\",\n    \"default\": false\n  },\n  {\n    \"name\": \"dev-2\",\n    \"default\": false\n  }\n]\n```")
    @GetMapping(value={"/branches"})
    public DeferredResult<List<BranchInfo>> listBranches() throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        TenantId tenantId = this.getTenantId();
        ListenableFuture branches = this.versionControlService.listBranches(tenantId);
        return this.wrapFuture(Futures.transform((ListenableFuture)branches, remoteBranches -> {
            ArrayList<BranchInfo> infos = new ArrayList<BranchInfo>();
            String defaultBranchName = this.versionControlService.getVersionControlSettings(tenantId).getDefaultBranch();
            BranchInfo defaultBranch = StringUtils.isNotEmpty((String)defaultBranchName) ? new BranchInfo(defaultBranchName, true) : (BranchInfo)remoteBranches.stream().filter(BranchInfo::isDefault).findFirst().orElse(null);
            if (defaultBranch != null) {
                infos.add(defaultBranch);
            }
            infos.addAll(remoteBranches.stream().filter(b -> !b.equals((Object)defaultBranch)).map(b -> new BranchInfo(b.getName(), false)).collect(Collectors.toList()));
            return infos;
        }, (Executor)MoreExecutors.directExecutor()));
    }

    protected <T> DeferredResult<T> wrapFuture(ListenableFuture<T> future) {
        return this.wrapFuture(future, (long)this.vcRequestTimeout);
    }

    @ConstructorProperties(value={"versionControlService"})
    @Generated
    public EntitiesVersionControlController(EntitiesVersionControlService versionControlService) {
        this.versionControlService = versionControlService;
    }
}

