/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HomeDashboard;
import org.thingsboard.server.common.data.HomeDashboardInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.dashboard.TbDashboardService;
import org.thingsboard.server.service.resource.TbResourceService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class DashboardController
extends BaseController {
    private final TbDashboardService tbDashboardService;
    private final TbResourceService tbResourceService;
    public static final String DASHBOARD_ID = "dashboardId";
    private static final String HOME_DASHBOARD_ID = "homeDashboardId";
    private static final String HOME_DASHBOARD_HIDE_TOOLBAR = "homeDashboardHideToolbar";
    public static final String DASHBOARD_INFO_DEFINITION = "The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON.";
    public static final String DASHBOARD_DEFINITION = "The Dashboard object is a heavyweight object that contains information about the dashboard (e.g. title, image, assigned customers) and also configuration JSON (e.g. layouts, widgets, entity aliases).";
    public static final String HIDDEN_FOR_MOBILE = "Exclude dashboards that are hidden for mobile";
    @Autowired
    private WhiteLabelingService whiteLabelingService;
    @Value(value="${ui.dashboard.max_datapoints_limit}")
    private long maxDatapointsLimit;

    @ApiOperation(value="Get server time (getServerTime)", notes="Get the server time (milliseconds since January 1, 1970 UTC). Used to adjust view of the dashboards according to the difference between browser and server time.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/serverTime"})
    @ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", examples={@ExampleObject(value="1636023857137")})})
    public long getServerTime() {
        return System.currentTimeMillis();
    }

    @ApiOperation(value="Get max data points limit (getMaxDatapointsLimit)", notes="Get the maximum number of data points that dashboard may request from the server per in a single subscription command. This value impacts the time window behavior. It impacts 'Max values' parameter in case user selects 'None' as 'Data aggregation function'. It also impacts the 'Grouping interval' in case of any other 'Data aggregation function' is selected. The actual value of the limit is configurable in the system configuration file.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/maxDatapointsLimit"})
    @ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", examples={@ExampleObject(value="5000")})})
    public long getMaxDatapointsLimit() {
        return this.maxDatapointsLimit;
    }

    @ApiOperation(value="Get Dashboard Info (getDashboardInfoById)", notes="Get the information about the dashboard based on 'dashboardId' parameter. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/info/{dashboardId}"})
    public DashboardInfo getDashboardInfoById(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        DashboardController.checkParameter((String)"dashboardId", (String)strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        return this.checkDashboardInfoId(dashboardId, Operation.READ);
    }

    @ApiOperation(value="Get Dashboard (getDashboardById)", notes="Get the dashboard based on 'dashboardId' parameter. The Dashboard object is a heavyweight object that contains information about the dashboard (e.g. title, image, assigned customers) and also configuration JSON (e.g. layouts, widgets, entity aliases).\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/{dashboardId}"})
    public void getDashboardById(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId, @Parameter(description="Export used resources and replace resource links with resource metadata") @RequestParam(value="includeResources", required=false) boolean includeResources, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletResponse response) throws Exception {
        DashboardController.checkParameter((String)"dashboardId", (String)strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.READ);
        if (includeResources) {
            dashboard.setResources(this.tbResourceService.exportResources(dashboard, this.getCurrentUser()));
        }
        response.setContentType("application/json");
        this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)dashboard));
    }

    @ApiOperation(value="Create Or Update Dashboard (saveDashboard)", notes="Create or update the Dashboard. When creating dashboard, platform generates Dashboard Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Dashboard id will be present in the response. Specify existing Dashboard id to update the dashboard. Referencing non-existing dashboard Id will cause 'Not Found' error. Only users with 'TENANT_ADMIN') authority may create the dashboards.Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Dashboard entity. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/dashboard"})
    public void saveDashboard(@RequestBody(description="A JSON value representing the dashboard.") @org.springframework.web.bind.annotation.RequestBody Dashboard dashboard, @RequestParam(name="entityGroupId", required=false) String strEntityGroupId, @Parameter(description="A list of entity group ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="entityGroupIds", required=false) String[] strEntityGroupIds, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletResponse response) throws Exception {
        SecurityUser user = this.getCurrentUser();
        Dashboard savedDashboard = (Dashboard)this.saveGroupEntity((GroupEntity)dashboard, strEntityGroupId, strEntityGroupIds, (dashboard1, entityGroups) -> {
            try {
                return (Dashboard)this.tbDashboardService.save(dashboard1, entityGroups, user);
            }
            catch (Exception e) {
                throw this.handleException(e);
            }
        });
        response.setContentType("application/json");
        this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)savedDashboard));
    }

    @ApiOperation(value="Delete the Dashboard (deleteDashboard)", notes="Delete the Dashboard. Only users with 'TENANT_ADMIN') authority may delete the dashboards.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/dashboard/{dashboardId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteDashboard(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        DashboardController.checkParameter((String)"dashboardId", (String)strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.DELETE);
        this.tbDashboardService.delete((Object)dashboard, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Dashboards by System Administrator (getTenantDashboards)", notes="Returns a page of dashboard info objects owned by tenant. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/tenant/{tenantId}/dashboards"}, params={"pageSize", "page"})
    public PageData<DashboardInfo> getTenantDashboards(@Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="tenantId") String strTenantId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        this.checkTenantId(tenantId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DASHBOARD, Operation.READ);
        return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Dashboards (getTenantDashboards)", notes="Returns a page of dashboard info objects owned by the tenant of a current user. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/tenant/dashboards"}, params={"pageSize", "page"})
    public PageData<DashboardInfo> getTenantDashboards(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Exclude dashboards that are hidden for mobile") @RequestParam(required=false) Boolean mobile, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DASHBOARD, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (mobile != null && mobile.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.dashboardService.findMobileDashboardsByTenantId(tenantId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Dashboards (getUserDashboards)", notes="Returns a page of Dashboard Info objects available for specified or current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/dashboards"}, params={"pageSize", "page"})
    public PageData<DashboardInfo> getUserDashboards(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Exclude dashboards that are hidden for mobile") @RequestParam(required=false) Boolean mobile, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Filter by allowed operations for the current user") @RequestParam(required=false) String operation, @Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(name="userId", required=false) String strUserId) throws ThingsboardException {
        SecurityUser securityUser;
        if (!StringUtils.isEmpty((String)strUserId)) {
            UserId userId = new UserId(this.toUUID(strUserId));
            User user = this.checkUserId(userId, Operation.READ);
            UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
            securityUser = new SecurityUser(user, true, principal, this.getMergedUserPermissions(user, false));
        } else {
            securityUser = this.getCurrentUser();
        }
        Operation operationType = Operation.READ;
        if (!StringUtils.isEmpty((String)operation)) {
            try {
                operationType = Operation.valueOf((String)operation);
            }
            catch (IllegalArgumentException e) {
                throw new ThingsboardException("Unsupported operation type '" + operation + "'!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
            }
        }
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        MergedUserPermissions mergedUserPermissions = securityUser.getUserPermissions();
        return this.entityService.findUserEntities(securityUser.getTenantId(), securityUser.getCustomerId(), mergedUserPermissions, EntityType.DASHBOARD, operationType, null, pageLink, mobile != null ? mobile : false, false);
    }

    @ApiOperation(value="Get All Dashboards for current user (getAllDashboards)", notes="Returns a page of dashboard info objects owned by the tenant or the customer of a current user. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboards/all"}, params={"pageSize", "page"})
    public PageData<DashboardInfo> getAllDashboards(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DASHBOARD, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            if (includeCustomers != null && includeCustomers.booleanValue()) {
                return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantId(tenantId, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.dashboardService.findTenantDashboardsByTenantId(tenantId, pageLink));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Customer Dashboards (getCustomerDashboards)", notes="Returns a page of dashboard info objects owned by the specified customer. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customer/{customerId}/dashboards"}, params={"pageSize", "page"})
    public PageData<DashboardInfo> getCustomerDashboards(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        DashboardController.checkParameter((String)"customerId", (String)strCustomerId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DASHBOARD, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get dashboards by Dashboard Ids (getDashboardsByIds)", notes="Returns a list of DashboardInfo objects based on the provided ids. Filters the list based on the user permissions. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboards"}, params={"dashboardIds"})
    public List<DashboardInfo> getDashboardsByIds(@Parameter(description="A list of dashboard ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="dashboardIds") Set<UUID> dashboardUUIDs) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<DashboardId> dashboardIds = new ArrayList<DashboardId>();
        for (UUID dashboardUUID : dashboardUUIDs) {
            dashboardIds.add(new DashboardId(dashboardUUID));
        }
        List dashboards = this.dashboardService.findDashboardInfoByIds(tenantId, dashboardIds);
        return this.filterDashboardsByReadPermission(dashboards);
    }

    @ApiOperation(value="Get dashboards by Entity Group Id (getDashboardsByEntityGroupId)", notes="Returns a page of Dashboard objects that belongs to specified Entity Group Id. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/{entityGroupId}/dashboards"}, params={"pageSize", "page"})
    public PageData<DashboardInfo> getDashboardsByEntityGroupId(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        DashboardController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        this.checkEntityGroupType(EntityType.DASHBOARD, entityGroup.getType());
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByEntityGroupId(entityGroupId, pageLink));
    }

    @ApiOperation(value="Import Dashboards (importGroupDashboards)", notes="Import the dashboards to specified group.The Dashboard object is a heavyweight object that contains information about the dashboard (e.g. title, image, assigned customers) and also configuration JSON (e.g. layouts, widgets, entity aliases).\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for specified group.", requestBody=@RequestBody(content={@Content(mediaType="application/json")}))
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/entityGroup/{entityGroupId}/dashboards/import"})
    public void importGroupDashboards(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="JSON array with the dashboard objects", required=true) @org.springframework.web.bind.annotation.RequestBody List<Dashboard> dashboardList, @Parameter(description="Overwrite dashboards with the same name") @RequestParam(required=false, defaultValue="false", name="overwrite") boolean overwrite) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        this.checkEntityGroupId(entityGroupId, Operation.WRITE);
        this.dashboardService.importDashboards(tenantId, entityGroupId, dashboardList, overwrite);
    }

    @ApiOperation(value="Export Dashboards (exportGroupDashboards)", notes="Export the dashboards that belong to specified group id.The Dashboard object is a heavyweight object that contains information about the dashboard (e.g. title, image, assigned customers) and also configuration JSON (e.g. layouts, widgets, entity aliases).\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/entityGroup/{entityGroupId}/dashboards/export"}, params={"limit"})
    public void exportGroupDashboards(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Limit of the entities to export", required=true) @RequestParam int limit, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletResponse response) throws Exception {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        this.checkEntityGroupId(entityGroupId, Operation.READ);
        TimePageLink pageLink = new TimePageLink(limit);
        response.setContentType("application/json");
        List dashboards = this.dashboardService.exportDashboards(tenantId, entityGroupId, pageLink);
        this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)dashboards));
    }

    private List<DashboardInfo> filterDashboardsByReadPermission(List<DashboardInfo> dashboards) {
        return dashboards.stream().filter(dashboard -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.DASHBOARD, Operation.READ, (EntityId)dashboard.getId(), (TenantEntity)dashboard);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ApiOperation(value="Get Home Dashboard (getHomeDashboard)", notes="Returns the home dashboard object that is configured as 'homeDashboardId' parameter in the 'additionalInfo' of the User. If 'homeDashboardId' parameter is not set on the User level and the User has authority 'CUSTOMER_USER', check the same parameter for the corresponding Customer. If 'homeDashboardId' parameter is not set on the User and Customer levels then checks the same parameter for the Tenant that owns the user. The Dashboard object is a heavyweight object that contains information about the dashboard (e.g. title, image, assigned customers) and also configuration JSON (e.g. layouts, widgets, entity aliases).\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/home"})
    public void getHomeDashboard(@RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletResponse response) throws Exception {
        JsonNode additionalInfo;
        SecurityUser securityUser = this.getCurrentUser();
        response.setContentType("application/json");
        if (securityUser.isSystemAdmin()) {
            return;
        }
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        HomeDashboard homeDashboard = null;
        boolean ownerWhiteLabelingAllowed = this.whiteLabelingService.isWhiteLabelingAllowed(this.getTenantId(), user.getCustomerId());
        if (ownerWhiteLabelingAllowed) {
            additionalInfo = user.getAdditionalInfo();
            homeDashboard = this.extractHomeDashboardFromAdditionalInfo(additionalInfo);
        }
        if (homeDashboard == null) {
            if (securityUser.isCustomerUser() && ownerWhiteLabelingAllowed) {
                Customer customer = this.customerService.findCustomerById(securityUser.getTenantId(), securityUser.getCustomerId());
                additionalInfo = customer.getAdditionalInfo();
                homeDashboard = this.extractHomeDashboardFromAdditionalInfo(additionalInfo);
            }
            if (homeDashboard == null && (securityUser.isTenantAdmin() && ownerWhiteLabelingAllowed || securityUser.isCustomerUser() && this.whiteLabelingService.isWhiteLabelingAllowed(this.getTenantId(), null))) {
                Tenant tenant = this.tenantService.findTenantById(securityUser.getTenantId());
                additionalInfo = tenant.getAdditionalInfo();
                homeDashboard = this.extractHomeDashboardFromAdditionalInfo(additionalInfo);
            }
        }
        if (homeDashboard != null) {
            this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)homeDashboard));
        }
    }

    @ApiOperation(value="Get Home Dashboard Info (getHomeDashboardInfo)", notes="Returns the home dashboard info object that is configured as 'homeDashboardId' parameter in the 'additionalInfo' of the User. If 'homeDashboardId' parameter is not set on the User level and the User has authority 'CUSTOMER_USER', check the same parameter for the corresponding Customer. If 'homeDashboardId' parameter is not set on the User and Customer levels then checks the same parameter for the Tenant that owns the user. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/home/info"})
    public HomeDashboardInfo getHomeDashboardInfo() throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        if (securityUser.isSystemAdmin()) {
            return null;
        }
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        JsonNode additionalInfo = user.getAdditionalInfo();
        return this.getHomeDashboardInfo(securityUser, additionalInfo);
    }

    @ApiOperation(value="Get Tenant Home Dashboard Info (getTenantHomeDashboardInfo)", notes="Returns the home dashboard info object that is configured as 'homeDashboardId' parameter in the 'additionalInfo' of the corresponding tenant. \n\nAvailable for users with 'TENANT_ADMIN' authority.\n\nSecurity check is performed to verify that the user has 'READ' permission for the white labeling resource.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/tenant/dashboard/home/info"})
    public HomeDashboardInfo getTenantHomeDashboardInfo() throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.READ);
        Tenant tenant = this.tenantService.findTenantById(this.getTenantId());
        JsonNode additionalInfo = tenant.getAdditionalInfo();
        DashboardId dashboardId = null;
        boolean hideDashboardToolbar = true;
        if (additionalInfo != null && additionalInfo.has("homeDashboardId") && !additionalInfo.get("homeDashboardId").isNull()) {
            String strDashboardId = additionalInfo.get("homeDashboardId").asText();
            dashboardId = new DashboardId(this.toUUID(strDashboardId));
            if (additionalInfo.has("homeDashboardHideToolbar")) {
                hideDashboardToolbar = additionalInfo.get("homeDashboardHideToolbar").asBoolean();
            }
        }
        return new HomeDashboardInfo(dashboardId, hideDashboardToolbar);
    }

    @ApiOperation(value="Get Customer Home Dashboard Info (getCustomerHomeDashboardInfo)", notes="Returns the home dashboard info object that is configured as 'homeDashboardId' parameter in the 'additionalInfo' of the corresponding customer. \n\nAvailable for users with 'CUSTOMER_USER' authority.\n\nSecurity check is performed to verify that the user has 'READ' permission for the white labeling resource.")
    @PreAuthorize(value="hasAuthority('CUSTOMER_USER')")
    @GetMapping(value={"/customer/dashboard/home/info"})
    public HomeDashboardInfo getCustomerHomeDashboardInfo() throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.READ);
        Customer customer = this.customerService.findCustomerById(this.getTenantId(), this.getCurrentUser().getCustomerId());
        JsonNode additionalInfo = customer.getAdditionalInfo();
        DashboardId dashboardId = null;
        boolean hideDashboardToolbar = true;
        if (additionalInfo != null && additionalInfo.has("homeDashboardId") && !additionalInfo.get("homeDashboardId").isNull()) {
            String strDashboardId = additionalInfo.get("homeDashboardId").asText();
            dashboardId = new DashboardId(this.toUUID(strDashboardId));
            if (additionalInfo.has("homeDashboardHideToolbar")) {
                hideDashboardToolbar = additionalInfo.get("homeDashboardHideToolbar").asBoolean();
            }
        }
        return new HomeDashboardInfo(dashboardId, hideDashboardToolbar);
    }

    @ApiOperation(value="Update Tenant Home Dashboard Info (getTenantHomeDashboardInfo)", notes="Update the home dashboard assignment for the current tenant. \n\nAvailable for users with 'TENANT_ADMIN' authority.\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the white labeling resource.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/tenant/dashboard/home/info"})
    @ResponseStatus(value=HttpStatus.OK)
    public void setTenantHomeDashboardInfo(@Parameter(description="A JSON object that represents home dashboard id and other parameters", required=true) @org.springframework.web.bind.annotation.RequestBody HomeDashboardInfo homeDashboardInfo) throws ThingsboardException {
        Tenant tenant;
        JsonNode additionalInfo;
        this.checkWhiteLabelingPermissions(Operation.WRITE);
        if (homeDashboardInfo.getDashboardId() != null) {
            this.checkDashboardId(homeDashboardInfo.getDashboardId(), Operation.READ);
        }
        if (!((additionalInfo = (tenant = this.tenantService.findTenantById(this.getTenantId())).getAdditionalInfo()) instanceof ObjectNode)) {
            additionalInfo = JacksonUtil.newObjectNode();
        }
        if (homeDashboardInfo.getDashboardId() != null) {
            ((ObjectNode)additionalInfo).put("homeDashboardId", homeDashboardInfo.getDashboardId().getId().toString());
            ((ObjectNode)additionalInfo).put("homeDashboardHideToolbar", homeDashboardInfo.isHideDashboardToolbar());
        } else {
            ((ObjectNode)additionalInfo).remove("homeDashboardId");
            ((ObjectNode)additionalInfo).remove("homeDashboardHideToolbar");
        }
        tenant.setAdditionalInfo(additionalInfo);
        this.tenantService.saveTenant(tenant);
    }

    @ApiOperation(value="Update Customer Home Dashboard Info (setCustomerHomeDashboardInfo)", notes="Update the home dashboard assignment for the current customer. \n\nAvailable for users with 'CUSTOMER_USER' authority.\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the white labeling resource.")
    @PreAuthorize(value="hasAuthority('CUSTOMER_USER')")
    @PostMapping(value={"/customer/dashboard/home/info"})
    @ResponseStatus(value=HttpStatus.OK)
    public void setCustomerHomeDashboardInfo(@Parameter(description="A JSON object that represents home dashboard id and other parameters", required=true) @org.springframework.web.bind.annotation.RequestBody HomeDashboardInfo homeDashboardInfo) throws ThingsboardException {
        Customer customer;
        JsonNode additionalInfo;
        this.checkWhiteLabelingPermissions(Operation.WRITE);
        if (homeDashboardInfo.getDashboardId() != null) {
            this.checkDashboardId(homeDashboardInfo.getDashboardId(), Operation.READ);
        }
        if (!((additionalInfo = (customer = this.customerService.findCustomerById(this.getTenantId(), this.getCurrentUser().getCustomerId())).getAdditionalInfo()) instanceof ObjectNode)) {
            additionalInfo = JacksonUtil.newObjectNode();
        }
        if (homeDashboardInfo.getDashboardId() != null) {
            ((ObjectNode)additionalInfo).put("homeDashboardId", homeDashboardInfo.getDashboardId().getId().toString());
            ((ObjectNode)additionalInfo).put("homeDashboardHideToolbar", homeDashboardInfo.isHideDashboardToolbar());
        } else {
            ((ObjectNode)additionalInfo).remove("homeDashboardId");
            ((ObjectNode)additionalInfo).remove("homeDashboardHideToolbar");
        }
        customer.setAdditionalInfo(additionalInfo);
        this.customerService.saveCustomer(customer);
    }

    private HomeDashboard extractHomeDashboardFromAdditionalInfo(JsonNode additionalInfo) {
        try {
            if (additionalInfo != null && additionalInfo.has("homeDashboardId") && !additionalInfo.get("homeDashboardId").isNull()) {
                String strDashboardId = additionalInfo.get("homeDashboardId").asText();
                DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
                Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.READ);
                boolean hideDashboardToolbar = true;
                if (additionalInfo.has("homeDashboardHideToolbar")) {
                    hideDashboardToolbar = additionalInfo.get("homeDashboardHideToolbar").asBoolean();
                }
                return new HomeDashboard(dashboard, hideDashboardToolbar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void checkWhiteLabelingPermissions(Operation operation) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WHITE_LABELING, operation);
    }

    @ConstructorProperties(value={"tbDashboardService", "tbResourceService"})
    @Generated
    public DashboardController(TbDashboardService tbDashboardService, TbResourceService tbResourceService) {
        this.tbDashboardService = tbDashboardService;
        this.tbResourceService = tbResourceService;
    }
}

