/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashSet;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.plugin.ComponentDescriptor;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class ComponentDescriptorController
extends BaseController {
    private static final String COMPONENT_DESCRIPTOR_DEFINITION = "Each Component Descriptor represents configuration of specific rule node (e.g. 'Save Timeseries' or 'Send Email'.). The Component Descriptors are used by the rule chain Web UI to build the configuration forms for the rule nodes. The Component Descriptors are discovered at runtime by scanning the class path and searching for @RuleNode annotation. Once discovered, the up to date list of descriptors is persisted to the database.";

    @ApiOperation(value="Get Component Descriptor (getComponentDescriptorByClazz)", notes="Gets the Component Descriptor object using class name from the path parameters. Each Component Descriptor represents configuration of specific rule node (e.g. 'Save Timeseries' or 'Send Email'.). The Component Descriptors are used by the rule chain Web UI to build the configuration forms for the rule nodes. The Component Descriptors are discovered at runtime by scanning the class path and searching for @RuleNode annotation. Once discovered, the up to date list of descriptors is persisted to the database.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN')")
    @RequestMapping(value={"/component/{componentDescriptorClazz:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public ComponentDescriptor getComponentDescriptorByClazz(@Parameter(description="Component Descriptor class name", required=true) @PathVariable(value="componentDescriptorClazz") String strComponentDescriptorClazz) throws ThingsboardException {
        ComponentDescriptorController.checkParameter((String)"strComponentDescriptorClazz", (String)strComponentDescriptorClazz);
        return this.checkComponentDescriptorByClazz(strComponentDescriptorClazz);
    }

    @ApiOperation(value="Get Component Descriptors (getComponentDescriptorsByType)", notes="Gets the Component Descriptors using rule node type and optional rule chain type request parameters. Each Component Descriptor represents configuration of specific rule node (e.g. 'Save Timeseries' or 'Send Email'.). The Component Descriptors are used by the rule chain Web UI to build the configuration forms for the rule nodes. The Component Descriptors are discovered at runtime by scanning the class path and searching for @RuleNode annotation. Once discovered, the up to date list of descriptors is persisted to the database.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN')")
    @RequestMapping(value={"/components/{componentType}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ComponentDescriptor> getComponentDescriptorsByType(@Parameter(description="Type of the Rule Node", schema=@Schema(allowableValues={"ENRICHMENT", "FILTER", "TRANSFORMATION", "ACTION", "EXTERNAL"}, requiredMode=Schema.RequiredMode.REQUIRED)) @PathVariable(value="componentType") String strComponentType, @Parameter(description="Type of the Rule Chain", schema=@Schema(allowableValues={"CORE", "EDGE"})) @RequestParam(value="ruleChainType", required=false) String strRuleChainType) throws ThingsboardException {
        ComponentDescriptorController.checkParameter((String)"componentType", (String)strComponentType);
        return this.checkComponentDescriptorsByType(ComponentType.valueOf((String)strComponentType), this.getRuleChainType(strRuleChainType));
    }

    @ApiOperation(value="Get Component Descriptors (getComponentDescriptorsByTypes)", notes="Gets the Component Descriptors using coma separated list of rule node types and optional rule chain type request parameters. Each Component Descriptor represents configuration of specific rule node (e.g. 'Save Timeseries' or 'Send Email'.). The Component Descriptors are used by the rule chain Web UI to build the configuration forms for the rule nodes. The Component Descriptors are discovered at runtime by scanning the class path and searching for @RuleNode annotation. Once discovered, the up to date list of descriptors is persisted to the database.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN')")
    @RequestMapping(value={"/components"}, params={"componentTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ComponentDescriptor> getComponentDescriptorsByTypes(@Parameter(description="List of types of the Rule Nodes, (ENRICHMENT, FILTER, TRANSFORMATION, ACTION or EXTERNAL)", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="componentTypes") String[] strComponentTypes, @Parameter(description="Type of the Rule Chain", schema=@Schema(allowableValues={"CORE", "EDGE"})) @RequestParam(value="ruleChainType", required=false) String strRuleChainType) throws ThingsboardException {
        this.checkArrayParameter("componentTypes", strComponentTypes);
        HashSet<ComponentType> componentTypes = new HashSet<ComponentType>();
        for (String strComponentType : strComponentTypes) {
            componentTypes.add(ComponentType.valueOf((String)strComponentType));
        }
        return this.checkComponentDescriptorsByTypes(componentTypes, this.getRuleChainType(strRuleChainType));
    }

    private RuleChainType getRuleChainType(String strRuleChainType) {
        RuleChainType ruleChainType = StringUtils.isEmpty((String)strRuleChainType) ? RuleChainType.CORE : RuleChainType.valueOf((String)strRuleChainType);
        return ruleChainType;
    }
}

