/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.ListenableFuture;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.NameConflictPolicy;
import org.thingsboard.server.common.data.NameConflictStrategy;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.UniquifyStrategy;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetInfo;
import org.thingsboard.server.common.data.asset.AssetSearchQuery;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportRequest;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportResult;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.asset.AssetBulkImportService;
import org.thingsboard.server.service.entitiy.asset.TbAssetService;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class AssetController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetController.class);
    private final AssetBulkImportService assetBulkImportService;
    private final TbAssetService tbAssetService;
    public static final String ASSET_ID = "assetId";

    @ApiOperation(value="Get Asset (getAssetById)", notes="Fetch the Asset object based on the provided Asset Id. If the user has the authority of 'Tenant Administrator', the server checks that the asset is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the asset is assigned to the same customer.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset/{assetId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Asset getAssetById(@Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        AssetController.checkParameter((String)"assetId", (String)strAssetId);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        return this.checkAssetId(assetId, Operation.READ);
    }

    @ApiOperation(value="Get Asset Info (getAssetInfoById)", notes="Fetch the Asset Info object based on the provided Asset Id. If the user has the authority of 'Tenant Administrator', the server checks that the asset is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the asset is assigned to the same customer.Asset Info is an extension of the default Asset object that contains information about the owner name. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset/info/{assetId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AssetInfo getAssetInfoById(@Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        AssetController.checkParameter((String)"assetId", (String)strAssetId);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        return this.checkAssetInfoId(assetId, Operation.READ);
    }

    @ApiOperation(value="Create Or Update Asset (saveAsset)", notes="Creates or Updates the Asset. When creating asset, platform generates Asset Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Asset id will be present in the response. Specify existing Asset id to update the asset. Referencing non-existing Asset Id will cause 'Not Found' error. Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Asset entity. \n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset"}, method={RequestMethod.POST})
    @ResponseBody
    public Asset saveAsset(@RequestBody(description="A JSON value representing the asset.", required=true) @org.springframework.web.bind.annotation.RequestBody Asset asset, @Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'. If specified, the entity will be added to the corresponding entity group.") @RequestParam(name="entityGroupId", required=false) String strEntityGroupId, @Parameter(description="A list of string values, separated by comma ',' representing the Entity Group Ids. For example, '784f394c-42b6-435a-983c-b7beff2784f9','a84f394c-42b6-435a-083c-b7beff2784f9'. If specified, the entity will be added to the corresponding entity groups.", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="entityGroupIds", required=false) String[] strEntityGroupIds, @Parameter(description="Optional value of name conflict policy. Possible values: FAIL or UNIQUIFY.  If omitted, FAIL policy is applied. FAIL policy implies exception will be thrown if an entity with the same name already exists.  UNIQUIFY policy appends a suffix to the entity name, if a name conflict occurs.") @RequestParam(name="nameConflictPolicy", defaultValue="FAIL") NameConflictPolicy nameConflictPolicy, @Parameter(description="Optional value of name suffix separator used by UNIQUIFY policy. By default, underscore separator is used. For example, strategy is UNIQUIFY, separator is '-'; if a name conflict occurs for entity name 'test-name', created entity will have name like 'test-name-7fsh4f'.") @RequestParam(name="uniquifySeparator", defaultValue="_") String uniquifySeparator, @Parameter(description="Optional value of uniquify strategy used by UNIQUIFY policy. Possible values: RANDOM or INCREMENTAL. By default, RANDOM strategy is used, which means random alphanumeric string will be added as a suffix to entity name. INCREMENTAL implies the first possible number starting from 1 will be added as a name suffix. For example, strategy is UNIQUIFY, uniquify strategy is INCREMENTAL; if a name conflict occurs for entity name 'test-name', created entity will have name like 'test-name-1.") @RequestParam(name="uniquifyStrategy", defaultValue="RANDOM") UniquifyStrategy uniquifyStrategy) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        return (Asset)this.saveGroupEntity((GroupEntity)asset, strEntityGroupId, strEntityGroupIds, (asset1, entityGroups) -> {
            try {
                return this.tbAssetService.save(asset, entityGroups, new NameConflictStrategy(nameConflictPolicy, uniquifySeparator, uniquifyStrategy), (User)user);
            }
            catch (Exception e) {
                throw this.handleException(e);
            }
        });
    }

    @ApiOperation(value="Delete asset (deleteAsset)", notes="Deletes the asset and all the relations (from and to the asset). Referencing non-existing asset Id will cause an error.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset/{assetId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteAsset(@Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws Exception {
        AssetController.checkParameter((String)"assetId", (String)strAssetId);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        Asset asset = this.checkAssetId(assetId, Operation.DELETE);
        this.tbAssetService.delete(asset, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Assets (getTenantAssets)", notes="Returns a page of assets owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/assets"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Asset> getTenantAssets(@Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="Asset type") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByTenantIdAndType(tenantId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Asset (getTenantAsset)", notes="Requested asset must be owned by tenant that the user belongs to. Asset name is an unique property of asset. So it can be used to identify the asset.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/assets"}, params={"assetName"}, method={RequestMethod.GET})
    @ResponseBody
    public Asset getTenantAsset(@Parameter(description="A string value representing the Asset name.") @RequestParam String assetName) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (Asset)this.checkNotNull((Object)this.assetService.findAssetByTenantIdAndName(tenantId, assetName));
    }

    @ApiOperation(value="Get Customer Assets (getCustomerAssets)", notes="Returns a page of assets objects owned by customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/assets"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Asset> getCustomerAssets(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="Asset type") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        AssetController.checkParameter((String)"customerId", (String)strCustomerId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Assets (getUserAssets)", notes="Returns a page of assets objects available for the current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. Asset Info is an extension of the default Asset object that contains information about the owner name. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/assets"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Asset> getUserAssets(@Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="Asset type") @RequestParam(required=false) String type, @Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assetProfileId, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser currentUser = this.getCurrentUser();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        return this.entityService.findUserEntities(currentUser.getTenantId(), currentUser.getCustomerId(), mergedUserPermissions, EntityType.ASSET, Operation.READ, type, pageLink);
    }

    @ApiOperation(value="Get All Asset Infos for current user (getAllAssetInfos)", notes="Returns a page of asset info objects owned by the tenant or the customer of a current user. Asset Info is an extension of the default Asset object that contains information about the owner name.  You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assetInfos/all"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AssetInfo> getAllAssetInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assetProfileId, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            if (includeCustomers != null && includeCustomers.booleanValue()) {
                if (assetProfileId != null && assetProfileId.length() > 0) {
                    AssetProfileId profileId = new AssetProfileId(this.toUUID(assetProfileId));
                    return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndAssetProfileId(tenantId, profileId, pageLink));
                }
                return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantId(tenantId, pageLink));
            }
            if (assetProfileId != null && assetProfileId.length() > 0) {
                AssetProfileId profileId = new AssetProfileId(this.toUUID(assetProfileId));
                return (PageData)this.checkNotNull((Object)this.assetService.findTenantAssetInfosByTenantIdAndAssetProfileId(tenantId, profileId, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.assetService.findTenantAssetInfosByTenantId(tenantId, pageLink));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            if (assetProfileId != null && assetProfileId.length() > 0) {
                AssetProfileId profileId = new AssetProfileId(this.toUUID(assetProfileId));
                return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerIdAndAssetProfileIdIncludingSubCustomers(tenantId, customerId, profileId, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        if (assetProfileId != null && assetProfileId.length() > 0) {
            AssetProfileId profileId = new AssetProfileId(this.toUUID(assetProfileId));
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerIdAndAssetProfileId(tenantId, customerId, profileId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Customer Asset Infos (getCustomerAssetInfos)", notes="Returns a page of asset info objects owned by the specified customer. Asset Info is an extension of the default Asset object that contains information about the owner name.  You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/assetInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AssetInfo> getCustomerAssetInfos(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assetProfileId, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        AssetController.checkParameter((String)"customerId", (String)strCustomerId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            if (assetProfileId != null && assetProfileId.length() > 0) {
                AssetProfileId profileId = new AssetProfileId(this.toUUID(assetProfileId));
                return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerIdAndAssetProfileIdIncludingSubCustomers(tenantId, customerId, profileId, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        if (assetProfileId != null && assetProfileId.length() > 0) {
            AssetProfileId profileId = new AssetProfileId(this.toUUID(assetProfileId));
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerIdAndAssetProfileId(tenantId, customerId, profileId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Assets By Ids (getAssetsByIds)", notes="Requested assets must be owned by tenant or assigned to customer which user is performing the request. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assets"}, params={"assetIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Asset> getAssetsByIds(@Parameter(description="A list of asset ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="assetIds") String[] strAssetIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("assetIds", strAssetIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<AssetId> assetIds = new ArrayList<AssetId>();
        for (String strAssetId : strAssetIds) {
            assetIds.add(new AssetId(this.toUUID(strAssetId)));
        }
        List assets = (List)this.checkNotNull((Object)((List)this.assetService.findAssetsByTenantIdAndIdsAsync(tenantId, assetIds).get()));
        return this.filterAssetsByReadPermission(assets);
    }

    @ApiOperation(value="Find related assets (findByQuery)", notes="Returns all assets that are related to the specific entity. The entity id, relation type, asset types, depth of the search, and other query parameters defined using complex 'AssetSearchQuery' object. See 'Model' tab of the Parameters for more info. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assets"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Asset> findByQuery(@org.springframework.web.bind.annotation.RequestBody AssetSearchQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull((Object)query);
        this.checkNotNull((Object)query.getParameters());
        this.checkNotNull((Object)query.getAssetTypes());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        List assets = (List)this.checkNotNull((Object)((List)this.assetService.findAssetsByQuery(this.getTenantId(), query).get()));
        return this.filterAssetsByReadPermission(assets);
    }

    @ApiOperation(value="Get assets by Entity Group Id (getAssetsByEntityGroupId)", notes="Returns a page of asset objects that belongs to specified Entity Group Id. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for specified group.")
    @RequestMapping(value={"/entityGroup/{entityGroupId}/assets"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Asset> getAssetsByEntityGroupId(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        AssetController.checkParameter((String)"entityGroupId", (String)strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        this.checkEntityGroupType(EntityType.ASSET, entityGroup.getType());
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByEntityGroupId(entityGroupId, pageLink));
    }

    private List<Asset> filterAssetsByReadPermission(List<Asset> assets) {
        return assets.stream().filter(asset -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.ASSET, Operation.READ, (EntityId)asset.getId(), (TenantEntity)asset);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).toList();
    }

    @ApiOperation(value="Get Asset Types (getAssetTypes)", notes="Deprecated. See 'getAssetProfileNames' API from Asset Profile Controller instead.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset/types"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated(since="3.6.2")
    public List<EntitySubtype> getAssetTypes() throws ThingsboardException, ExecutionException, InterruptedException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ListenableFuture assetTypes = this.assetService.findAssetTypesByTenantId(tenantId);
        return (List)this.checkNotNull((Object)((List)assetTypes.get()));
    }

    @ApiOperation(value="Import the bulk of assets (processAssetsBulkImport)", notes="There's an ability to import the bulk of assets using the only .csv file.\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/asset/bulk_import"})
    public BulkImportResult<Asset> processAssetBulkImport(@org.springframework.web.bind.annotation.RequestBody BulkImportRequest request) throws Exception {
        return this.assetBulkImportService.processBulkImport(request, this.getCurrentUser(), (asset, savingFunction) -> {
            try {
                this.saveGroupEntity((GroupEntity)asset, request.getEntityGroupId(), savingFunction);
            }
            catch (ThingsboardException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @ConstructorProperties(value={"assetBulkImportService", "tbAssetService"})
    @Generated
    public AssetController(AssetBulkImportService assetBulkImportService, TbAssetService tbAssetService) {
        this.assetBulkImportService = assetBulkImportService;
        this.tbAssetService = tbAssetService;
    }
}

