/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmCommentInfo;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AlarmCommentId;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmCommentService;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class AlarmCommentController
extends BaseController {
    public static final String ALARM_ID = "alarmId";
    public static final String ALARM_COMMENT_ID = "commentId";
    private final TbAlarmCommentService tbAlarmCommentService;

    @ApiOperation(value="Create or update Alarm Comment ", notes="Creates or Updates the Alarm Comment. When creating comment, platform generates Alarm Comment Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Alarm Comment id will be present in the response. Specify existing Alarm Comment id to update the alarm. Referencing non-existing Alarm Comment Id will cause 'Not Found' error. \n\n To create new Alarm comment entity it is enough to specify 'comment' json element with 'text' node, for example: {\"comment\": { \"text\": \"my comment\"}}. \n\n If comment type is not specified the default value 'OTHER' will be saved. If 'alarmId' or 'userId' specified in body it will be ignored.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/alarm/{alarmId}/comment"})
    public AlarmComment saveAlarmComment(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="A JSON value representing the comment.") @RequestBody AlarmComment alarmComment) throws ThingsboardException {
        AlarmCommentController.checkParameter((String)"alarmId", (String)strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        AlarmInfo alarm = this.checkAlarmInfoId(alarmId, Operation.WRITE);
        alarmComment.setAlarmId(alarmId);
        return this.tbAlarmCommentService.saveAlarmComment((Alarm)alarm, alarmComment, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete Alarm comment (deleteAlarmComment)", notes="Deletes the Alarm comment. Referencing non-existing Alarm comment Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/alarm/{alarmId}/comment/{commentId}"})
    public void deleteAlarmComment(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="alarmId") String strAlarmId, @Parameter(description="A string value representing the alarm comment id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="commentId") String strCommentId) throws ThingsboardException {
        AlarmCommentController.checkParameter((String)"alarmId", (String)strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        Alarm alarm = this.checkAlarmId(alarmId, Operation.WRITE);
        AlarmCommentId alarmCommentId = new AlarmCommentId(this.toUUID(strCommentId));
        AlarmComment alarmComment = this.checkAlarmCommentId(alarmCommentId, alarmId);
        this.tbAlarmCommentService.deleteAlarmComment(alarm, alarmComment, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Alarm comments (getAlarmComments)", notes="Returns a page of alarm comments for specified alarm. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/alarm/{alarmId}/comment"})
    public PageData<AlarmCommentInfo> getAlarmComments(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="alarmId") String strAlarmId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "id"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws Exception {
        AlarmCommentController.checkParameter((String)"alarmId", (String)strAlarmId);
        AlarmId alarmId = new AlarmId(this.toUUID(strAlarmId));
        this.checkAlarmId(alarmId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, null, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.alarmCommentService.findAlarmComments(this.getTenantId(), alarmId, pageLink));
    }

    @ConstructorProperties(value={"tbAlarmCommentService"})
    @Generated
    public AlarmCommentController(TbAlarmCommentService tbAlarmCommentService) {
        this.tbAlarmCommentService = tbAlarmCommentService;
    }
}

