/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.config;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.exception.TenantProfileNotFoundException;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;
import org.thingsboard.server.exception.ThingsboardErrorResponseHandler;
import org.thingsboard.server.service.security.model.SecurityUser;

@Component
public class RateLimitProcessingFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitProcessingFilter.class);
    private final ThingsboardErrorResponseHandler errorResponseHandler;
    private final RateLimitService rateLimitService;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecurityUser user = this.getCurrentUser();
        if (user != null && !user.isSystemAdmin()) {
            try {
                if (!this.rateLimitService.checkRateLimit(LimitedApi.REST_REQUESTS_PER_TENANT, user.getTenantId())) {
                    this.rateLimitExceeded(EntityType.TENANT, response);
                    return;
                }
            }
            catch (TenantProfileNotFoundException e) {
                log.debug("[{}] Failed to lookup tenant profile", (Object)user.getTenantId());
                this.errorResponseHandler.handle((Exception)new BadCredentialsException("Failed to lookup tenant profile"), response);
                return;
            }
            if (user.isCustomerUser() && !this.rateLimitService.checkRateLimit(LimitedApi.REST_REQUESTS_PER_CUSTOMER, user.getTenantId(), (Object)user.getCustomerId())) {
                this.rateLimitExceeded(EntityType.CUSTOMER, response);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    private void rateLimitExceeded(EntityType type, HttpServletResponse response) {
        this.errorResponseHandler.handle((Exception)new TbRateLimitsException(type), response);
    }

    protected SecurityUser getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof SecurityUser) {
            return (SecurityUser)authentication.getPrincipal();
        }
        return null;
    }

    @ConstructorProperties(value={"errorResponseHandler", "rateLimitService"})
    @Generated
    public RateLimitProcessingFilter(ThingsboardErrorResponseHandler errorResponseHandler, RateLimitService rateLimitService) {
        this.errorResponseHandler = errorResponseHandler;
        this.rateLimitService = rateLimitService;
    }
}

