/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.tenant;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.ProcessFailureStrategy;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorNotRegisteredException;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbEntityActorId;
import org.thingsboard.server.actors.TbStringActorId;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldManagerActorCreator;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.actors.device.DeviceActorCreator;
import org.thingsboard.server.actors.ruleChain.RuleChainManagerActor;
import org.thingsboard.server.actors.tenant.TenantActor;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbActorStopReason;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.ToCalculatedFieldSystemMsg;
import org.thingsboard.server.common.msg.aware.DeviceAwareMsg;
import org.thingsboard.server.common.msg.aware.RuleChainAwareMsg;
import org.thingsboard.server.common.msg.aware.TenantAwareMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldCacheInitMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldEntityLifecycleMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;
import org.thingsboard.server.common.msg.queue.QueueToRuleEngineMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.rule.engine.DeviceDeleteMsg;
import org.thingsboard.server.service.transport.msg.TransportToDeviceActorMsgWrapper;

public class TenantActor
extends RuleChainManagerActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantActor.class);
    private boolean isRuleEngine;
    private boolean isCore;
    private ApiUsageState apiUsageState;
    private Set<DeviceId> deletedDevices = new HashSet();
    private TbActorRef cfActor;
    boolean cantFindTenant = false;

    private TenantActor(ActorSystemContext systemContext, TenantId tenantId) {
        super(systemContext, tenantId);
    }

    public void init(TbActorCtx ctx) throws TbActorException {
        block11: {
            super.init(ctx);
            log.debug("[{}] Starting tenant actor.", (Object)this.tenantId);
            try {
                block12: {
                    Tenant tenant = this.systemContext.getTenantService().findTenantById(this.tenantId);
                    if (tenant == null) {
                        this.cantFindTenant = true;
                        log.info("[{}] Started tenant actor for missing tenant.", (Object)this.tenantId);
                        break block11;
                    }
                    this.isCore = this.systemContext.getServiceInfoProvider().isService(ServiceType.TB_CORE);
                    this.isRuleEngine = this.systemContext.getServiceInfoProvider().isService(ServiceType.TB_RULE_ENGINE);
                    if (this.isRuleEngine) {
                        if (this.systemContext.getPartitionService().isManagedByCurrentService(this.tenantId)) {
                            try {
                                this.cfActor = ctx.getOrCreateChildActor((TbActorId)new TbStringActorId("CFM|" + String.valueOf(this.tenantId)), () -> "cf-manager-dispatcher", () -> new CalculatedFieldManagerActorCreator(this.systemContext, this.tenantId), () -> true);
                                this.cfActor.tellWithHighPriority((TbActorMsg)new CalculatedFieldCacheInitMsg(this.tenantId));
                            }
                            catch (Exception e) {
                                log.info("[{}] Failed to init CF Actor.", (Object)this.tenantId, (Object)e);
                            }
                            try {
                                if (this.getApiUsageState().isReExecEnabled()) {
                                    log.debug("[{}] Going to init rule chains", (Object)this.tenantId);
                                    this.initRuleChains();
                                    break block12;
                                }
                                log.info("[{}] Skip init of the rule chains due to API limits", (Object)this.tenantId);
                            }
                            catch (Exception e) {
                                log.info("Failed to check ApiUsage \"ReExecEnabled\"!!!", (Throwable)e);
                                this.cantFindTenant = true;
                            }
                        } else {
                            log.info("Tenant {} is not managed by current service, skipping rule chains and cf actor init", (Object)this.tenantId);
                        }
                    }
                }
                log.debug("[{}] Tenant actor started.", (Object)this.tenantId);
            }
            catch (Exception e) {
                log.warn("[{}] Unknown failure", (Object)this.tenantId, (Object)e);
            }
        }
    }

    public void destroy(TbActorStopReason stopReason, Throwable cause) {
        log.info("[{}] Stopping tenant actor.", (Object)this.tenantId);
        if (this.cfActor != null) {
            this.ctx.stop(this.cfActor.getActorId());
            this.cfActor = null;
        }
    }

    protected boolean doProcess(TbActorMsg msg) {
        if (this.cantFindTenant) {
            log.debug("[{}] Processing message for non-existing tenant: {}", (Object)this.tenantId, (Object)msg);
            switch (2.$SwitchMap$org$thingsboard$server$common$msg$MsgType[msg.getMsgType().ordinal()]) {
                case 1: {
                    ((QueueToRuleEngineMsg)msg).getMsg().getCallback().onSuccess();
                    break;
                }
                case 2: {
                    ((TransportToDeviceActorMsgWrapper)msg).getCallback().onSuccess();
                    break;
                }
                case 3: {
                    ((CalculatedFieldStateRestoreMsg)msg).getCallback().onSuccess();
                    break;
                }
                default: {
                    if (log.isDebugEnabled()) break;
                    log.info("[{}] Processing message for non-existing tenant: {}", (Object)this.tenantId, (Object)msg);
                }
            }
            return true;
        }
        switch (2.$SwitchMap$org$thingsboard$server$common$msg$MsgType[msg.getMsgType().ordinal()]) {
            case 4: {
                this.onPartitionChangeMsg((PartitionChangeMsg)msg);
                break;
            }
            case 5: {
                this.onComponentLifecycleMsg((ComponentLifecycleMsg)msg);
                break;
            }
            case 6: {
                this.forwardToCfActor((TenantAwareMsg)msg, true);
                break;
            }
            case 1: {
                this.onQueueToRuleEngineMsg((QueueToRuleEngineMsg)msg);
                break;
            }
            case 2: {
                this.onToDeviceActorMsg((DeviceAwareMsg)msg, false);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.onToDeviceActorMsg((DeviceAwareMsg)msg, true);
                break;
            }
            case 15: {
                this.ctx.broadcastToChildrenByType(msg, EntityType.DEVICE);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                this.onRuleChainMsg((RuleChainAwareMsg)msg);
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 21: {
                this.forwardToCfActor((TenantAwareMsg)((ToCalculatedFieldSystemMsg)msg), true);
                break;
            }
            case 22: 
            case 23: {
                this.forwardToCfActor((TenantAwareMsg)((ToCalculatedFieldSystemMsg)msg), false);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void forwardToCfActor(TenantAwareMsg msg, boolean priority) {
        if (this.cfActor == null) {
            if (msg instanceof CalculatedFieldStateRestoreMsg) {
                log.warn("[{}] CF Actor is not initialized. ToCalculatedFieldSystemMsg: [{}]", (Object)this.tenantId, (Object)msg);
            } else {
                log.debug("[{}] CF Actor is not initialized. ToCalculatedFieldSystemMsg: [{}]", (Object)this.tenantId, (Object)msg);
            }
            msg.getCallback().onSuccess();
            return;
        }
        if (priority) {
            this.cfActor.tellWithHighPriority((TbActorMsg)msg);
        } else {
            this.cfActor.tell((TbActorMsg)msg);
        }
    }

    private boolean isMyPartition(EntityId entityId) {
        return this.systemContext.resolve(ServiceType.TB_CORE, this.tenantId, entityId).isMyPartition();
    }

    private void onQueueToRuleEngineMsg(QueueToRuleEngineMsg msg) {
        if (!this.isRuleEngine) {
            log.warn("RECEIVED INVALID MESSAGE: {}", (Object)msg);
            return;
        }
        TbMsg tbMsg = msg.getMsg();
        if (this.getApiUsageState().isReExecEnabled()) {
            if (tbMsg.getRuleChainId() == null) {
                if (this.getRootChainActor() != null) {
                    this.getRootChainActor().tell((TbActorMsg)msg);
                } else {
                    tbMsg.getCallback().onFailure(new RuleEngineException("No Root Rule Chain available!"));
                    log.info("[{}] No Root Chain: {}", (Object)this.tenantId, (Object)msg);
                }
            } else {
                try {
                    this.ctx.tell((TbActorId)new TbEntityActorId((EntityId)tbMsg.getRuleChainId()), (TbActorMsg)msg);
                }
                catch (TbActorNotRegisteredException ex) {
                    log.trace("Received message for non-existing rule chain: [{}]", (Object)tbMsg.getRuleChainId());
                    tbMsg.getCallback().onSuccess();
                }
            }
        } else {
            log.trace("[{}] Ack message because Rule Engine is disabled", (Object)this.tenantId);
            tbMsg.getCallback().onSuccess();
        }
    }

    private void onRuleChainMsg(RuleChainAwareMsg msg) {
        if (this.getApiUsageState().isReExecEnabled()) {
            this.getOrCreateActor(msg.getRuleChainId()).tell((TbActorMsg)msg);
        }
    }

    private void onToDeviceActorMsg(DeviceAwareMsg msg, boolean priority) {
        if (!this.isCore) {
            log.warn("RECEIVED INVALID MESSAGE: {}", (Object)msg);
        }
        if (this.deletedDevices.contains(msg.getDeviceId())) {
            log.debug("RECEIVED MESSAGE FOR DELETED DEVICE: {}", (Object)msg);
            return;
        }
        TbActorRef deviceActor = this.getOrCreateDeviceActor(msg.getDeviceId());
        if (priority) {
            deviceActor.tellWithHighPriority((TbActorMsg)msg);
        } else {
            deviceActor.tell((TbActorMsg)msg);
        }
    }

    private void onPartitionChangeMsg(PartitionChangeMsg msg) {
        ServiceType serviceType = msg.getServiceType();
        if (ServiceType.TB_RULE_ENGINE.equals((Object)serviceType)) {
            if (this.systemContext.getPartitionService().isManagedByCurrentService(this.tenantId)) {
                if (this.cfActor == null) {
                    try {
                        this.cfActor = this.ctx.getOrCreateChildActor((TbActorId)new TbStringActorId("CFM|" + String.valueOf(this.tenantId)), () -> "cf-manager-dispatcher", () -> new CalculatedFieldManagerActorCreator(this.systemContext, this.tenantId), () -> true);
                        this.cfActor.tellWithHighPriority((TbActorMsg)new CalculatedFieldCacheInitMsg(this.tenantId));
                    }
                    catch (Exception e) {
                        log.info("[{}] Failed to init CF Actor.", (Object)this.tenantId, (Object)e);
                    }
                }
                if (!this.ruleChainsInitialized) {
                    log.info("Tenant {} is now managed by this service, initializing rule chains", (Object)this.tenantId);
                    this.initRuleChains();
                }
            } else {
                if (this.cfActor != null) {
                    this.ctx.stop(this.cfActor.getActorId());
                    this.cfActor = null;
                }
                if (this.ruleChainsInitialized) {
                    log.info("Tenant {} is no longer managed by this service, stopping rule chains", (Object)this.tenantId);
                    this.destroyRuleChains();
                }
                return;
            }
            this.broadcast((TbActorMsg)msg);
        } else if (ServiceType.TB_CORE.equals((Object)serviceType)) {
            List deviceActorIds = this.ctx.filterChildren((Predicate)new /* Unavailable Anonymous Inner Class!! */);
            deviceActorIds.forEach(id -> this.ctx.stop(id));
        }
    }

    private void onComponentLifecycleMsg(ComponentLifecycleMsg msg) {
        EntityType entityType = msg.getEntityId().getEntityType();
        if (entityType.equals((Object)EntityType.API_USAGE_STATE)) {
            ApiUsageState old = this.getApiUsageState();
            this.apiUsageState = new ApiUsageState(this.systemContext.getApiUsageStateService().getApiUsageState(this.tenantId));
            if (old.isReExecEnabled() && !this.apiUsageState.isReExecEnabled()) {
                log.info("[{}] Received API state update. Going to DISABLE Rule Engine execution.", (Object)this.tenantId);
                this.destroyRuleChains();
            } else if (!old.isReExecEnabled() && this.apiUsageState.isReExecEnabled()) {
                log.info("[{}] Received API state update. Going to ENABLE Rule Engine execution.", (Object)this.tenantId);
                this.initRuleChains();
            }
        }
        if (msg.getEntityId().getEntityType() == EntityType.DEVICE && ComponentLifecycleEvent.DELETED == msg.getEvent() && this.isMyPartition(msg.getEntityId())) {
            DeviceId deviceId = (DeviceId)msg.getEntityId();
            this.onToDeviceActorMsg((DeviceAwareMsg)new DeviceDeleteMsg(this.tenantId, deviceId), true);
            this.deletedDevices.add(deviceId);
        }
        if (this.isRuleEngine) {
            if (this.ruleChainsInitialized && !entityType.equals((Object)EntityType.INTEGRATION) && !entityType.equals((Object)EntityType.CONVERTER)) {
                TbActorRef target = this.getEntityActorRef(msg.getEntityId());
                if (target != null) {
                    RuleChain ruleChain;
                    if (entityType == EntityType.RULE_CHAIN && (ruleChain = this.systemContext.getRuleChainService().findRuleChainById(this.tenantId, new RuleChainId(msg.getEntityId().getId()))) != null && RuleChainType.CORE.equals((Object)ruleChain.getType())) {
                        this.visit(ruleChain, target);
                    }
                    target.tellWithHighPriority((TbActorMsg)msg);
                } else {
                    log.debug("[{}] Invalid component lifecycle msg: {}", (Object)this.tenantId, (Object)msg);
                }
            }
            if (this.cfActor != null && msg.getEntityId().getEntityType().isOneOf(new EntityType[]{EntityType.CALCULATED_FIELD, EntityType.DEVICE, EntityType.ASSET, EntityType.CUSTOMER, EntityType.TENANT_PROFILE})) {
                this.cfActor.tellWithHighPriority((TbActorMsg)new CalculatedFieldEntityLifecycleMsg(this.tenantId, msg));
            }
        }
    }

    private TbActorRef getOrCreateDeviceActor(DeviceId deviceId) {
        return this.ctx.getOrCreateChildActor((TbActorId)new TbEntityActorId((EntityId)deviceId), () -> "device-dispatcher", () -> new DeviceActorCreator(this.systemContext, this.tenantId, deviceId), () -> true);
    }

    private ApiUsageState getApiUsageState() {
        if (this.apiUsageState == null) {
            this.apiUsageState = new ApiUsageState(this.systemContext.getApiUsageStateService().getApiUsageState(this.tenantId));
        }
        return this.apiUsageState;
    }

    public ProcessFailureStrategy onProcessFailure(TbActorMsg msg, Throwable t) {
        log.error("[{}] Failed to process msg: {}", new Object[]{this.tenantId, msg, t});
        return this.doProcessFailure(t);
    }
}

