/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.service;

import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.TbRuleNodeUpdateException;
import org.thingsboard.server.actors.service.ComponentActor;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.actors.shared.ComponentMsgProcessor;
import org.thingsboard.server.actors.stats.StatsPersistMsg;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbActorStopReason;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;

public abstract class ComponentActor<T extends EntityId, P extends ComponentMsgProcessor<T>>
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentActor.class);
    private long lastPersistedErrorTs = 0L;
    protected final TenantId tenantId;
    protected final T id;
    protected P processor;
    private long messagesProcessed;
    private long errorsOccurred;
    ScheduledFuture<?> statsScheduledFuture = null;

    public ComponentActor(ActorSystemContext systemContext, TenantId tenantId, T id) {
        super(systemContext);
        this.tenantId = tenantId;
        this.id = id;
    }

    protected abstract P createProcessor(TbActorCtx var1);

    public void init(TbActorCtx ctx) throws TbActorException {
        super.init(ctx);
        this.processor = this.createProcessor(ctx);
        this.initProcessor(ctx);
    }

    protected void initProcessor(TbActorCtx ctx) throws TbActorException {
        try {
            log.debug("[{}][{}][{}] Starting processor.", new Object[]{this.tenantId, this.id, this.id.getEntityType()});
            this.processor.start(ctx);
            this.logLifecycleEvent(ComponentLifecycleEvent.STARTED);
            if (this.systemContext.isStatisticsEnabled()) {
                this.scheduleStatsPersistTick();
            }
        }
        catch (Exception e) {
            log.debug("[{}][{}] Failed to start {} processor.", new Object[]{this.tenantId, this.id, this.id.getEntityType(), e});
            this.logAndPersist("OnStart", e, true);
            this.logLifecycleEvent(ComponentLifecycleEvent.STARTED, e);
            throw new TbActorException("Failed to init actor", (Throwable)e);
        }
    }

    void scheduleStatsPersistTick() {
        try {
            this.statsScheduledFuture = this.processor.scheduleStatsPersistTick(this.ctx, this.systemContext.getStatisticsPersistFrequency());
        }
        catch (Exception e) {
            log.error("[{}][{}] Failed to schedule statistics store message. No statistics is going to be stored: {}", new Object[]{this.tenantId, this.id, e.getMessage()});
            this.logAndPersist("onScheduleStatsPersistMsg", e);
        }
    }

    public void destroy(TbActorStopReason stopReason, Throwable cause) {
        try {
            log.debug("[{}][{}][{}] Stopping processor.", new Object[]{this.tenantId, this.id, this.id.getEntityType()});
            if (this.processor != null) {
                this.processor.stop(this.ctx);
            }
            this.logLifecycleEvent(ComponentLifecycleEvent.STOPPED);
            Optional.ofNullable(this.statsScheduledFuture).ifPresent(x -> x.cancel(false));
            this.statsScheduledFuture = null;
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to stop {} processor: {}", new Object[]{this.tenantId, this.id, this.id.getEntityType(), e.getMessage()});
            this.logAndPersist("OnStop", e, true);
            this.logLifecycleEvent(ComponentLifecycleEvent.STOPPED, e);
        }
    }

    protected void onComponentLifecycleMsg(ComponentLifecycleMsg msg) {
        block8: {
            log.debug("[{}][{}][{}] onComponentLifecycleMsg: [{}]", new Object[]{this.tenantId, this.id, this.id.getEntityType(), msg.getEvent()});
            try {
                switch (1.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[msg.getEvent().ordinal()]) {
                    case 1: {
                        this.processor.onCreated(this.ctx);
                        break;
                    }
                    case 2: {
                        this.processor.onUpdate(this.ctx);
                        break;
                    }
                    case 3: {
                        this.processor.onSuspend(this.ctx);
                        break;
                    }
                    case 4: {
                        this.processor.onStop(this.ctx);
                        this.ctx.stop(this.ctx.getSelf());
                        break;
                    }
                }
                this.logLifecycleEvent(msg.getEvent());
            }
            catch (Exception e) {
                this.logAndPersist("onLifecycleMsg", e, true);
                this.logLifecycleEvent(msg.getEvent(), e);
                if (!(e instanceof TbRuleNodeUpdateException)) break block8;
                throw (TbRuleNodeUpdateException)e;
            }
        }
    }

    protected void onClusterEventMsg(PartitionChangeMsg msg) {
        try {
            this.processor.onPartitionChangeMsg(msg);
        }
        catch (Exception e) {
            this.logAndPersist("onClusterEventMsg", e);
        }
    }

    protected void onStatsPersistTick(EntityId entityId) {
        try {
            this.systemContext.getStatsActor().tell((TbActorMsg)new StatsPersistMsg(this.messagesProcessed, this.errorsOccurred, this.tenantId, entityId));
            this.resetStatsCounters();
        }
        catch (Exception e) {
            this.logAndPersist("onStatsPersistTick", e);
        }
    }

    private void resetStatsCounters() {
        this.messagesProcessed = 0L;
        this.errorsOccurred = 0L;
    }

    protected void increaseMessagesProcessedCount() {
        ++this.messagesProcessed;
    }

    protected void logAndPersist(String method, Exception e) {
        this.logAndPersist(method, e, false);
    }

    private void logAndPersist(String method, Exception e, boolean critical) {
        String componentName;
        ++this.errorsOccurred;
        String string = componentName = this.processor != null ? this.processor.getComponentName() : "Unknown";
        if (critical) {
            log.debug("[{}][{}][{}] Failed to process method: {}", new Object[]{this.id, this.tenantId, componentName, method});
            log.debug("Critical Error: ", (Throwable)e);
        } else {
            log.trace("[{}][{}][{}] Failed to process method: {}", new Object[]{this.id, this.tenantId, componentName, method});
            log.trace("Debug Error: ", (Throwable)e);
        }
        long ts = System.currentTimeMillis();
        if (ts - this.lastPersistedErrorTs > this.getErrorPersistFrequency()) {
            this.systemContext.persistError(this.tenantId, this.id, method, e);
            this.lastPersistedErrorTs = ts;
        }
    }

    private void logLifecycleEvent(ComponentLifecycleEvent event) {
        this.logLifecycleEvent(event, null);
    }

    protected void logLifecycleEvent(ComponentLifecycleEvent event, Exception e) {
        this.systemContext.persistLifecycleEvent(this.tenantId, this.id, event, e);
    }

    protected abstract long getErrorPersistFrequency();
}

