/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldAlarmActionMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldArgumentResetMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityDeleteMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityMessageProcessor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldException;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldReevaluateMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldRelationActionMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityInitCalculatedFieldMsg;
import org.thingsboard.server.actors.calculatedField.MultipleTbCallback;
import org.thingsboard.server.actors.shared.AbstractContextAwareMsgProcessor;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.cf.CalculatedFieldEventType;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.msg.CalculatedFieldStatePartitionRestoreMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldPartitionChangeMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.CalculatedFieldStateService;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesAggregationCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationCalculatedFieldState;
import org.thingsboard.server.utils.CalculatedFieldArgumentUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculatedFieldEntityMessageProcessor
extends AbstractContextAwareMsgProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldEntityMessageProcessor.class);
    public static final int CALLBACKS_PER_CF = 2;
    final TenantId tenantId;
    final EntityId entityId;
    final CalculatedFieldProcessingService cfService;
    final CalculatedFieldStateService cfStateService;
    TbActorCtx actorCtx;
    Map<CalculatedFieldId, CalculatedFieldState> states = new HashMap();

    CalculatedFieldEntityMessageProcessor(ActorSystemContext systemContext, TenantId tenantId, EntityId entityId) {
        super(systemContext);
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.cfService = systemContext.getCalculatedFieldProcessingService();
        this.cfStateService = systemContext.getCalculatedFieldStateService();
    }

    void init(TbActorCtx ctx) {
        this.actorCtx = ctx;
    }

    public void stop(boolean partitionChanged) {
        log.info(partitionChanged ? "[{}][{}] Stopping entity actor due to change partition event." : "[{}][{}] Stopping entity actor.", (Object)this.tenantId, (Object)this.entityId);
        this.states.values().forEach(arg_0 -> this.closeState(arg_0));
        this.states.clear();
        this.actorCtx.stop(this.actorCtx.getSelf());
    }

    public void process(CalculatedFieldPartitionChangeMsg msg) {
        if (!this.systemContext.getPartitionService().resolve(ServiceType.TB_RULE_ENGINE, "CalculatedFields", this.tenantId, this.entityId).isMyPartition()) {
            this.stop(true);
        }
    }

    public void process(CalculatedFieldStateRestoreMsg msg) {
        CalculatedFieldId cfId = msg.getId().cfId();
        log.debug("[{}] [{}] Processing CF state restore msg.", (Object)msg.getId().entityId(), (Object)cfId);
        CalculatedFieldState state = msg.getState();
        if (state != null) {
            state.setCtx(msg.getCtx(), (TbActorRef)this.actorCtx);
            state.setPartition(msg.getPartition());
            this.states.put(cfId, state);
        } else {
            this.removeState(cfId);
        }
        msg.getCallback().onSuccess();
    }

    public void process(CalculatedFieldStatePartitionRestoreMsg msg) {
        log.debug("Processing CF state partition restore msg: {}", (Object)msg);
        for (CalculatedFieldState state : this.states.values()) {
            if (!msg.getPartition().equals((Object)state.getPartition())) continue;
            state.init(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(EntityInitCalculatedFieldMsg msg) throws CalculatedFieldException {
        CalculatedFieldState state;
        log.debug("[{}] Processing entity init CF msg: {}", (Object)msg.getCtx().getCfId(), (Object)msg);
        CalculatedFieldCtx ctx = msg.getCtx();
        if (msg.getStateAction() == EntityInitCalculatedFieldMsg.StateAction.RECREATE) {
            this.removeState(ctx.getCfId());
            state = null;
        } else {
            state = (CalculatedFieldState)this.states.get(ctx.getCfId());
        }
        try {
            if (state == null) {
                state = this.createState(ctx);
            } else if (msg.getStateAction() == EntityInitCalculatedFieldMsg.StateAction.REINIT) {
                log.debug("Force reinitialization of CF: [{}].", (Object)ctx.getCfId());
                state.reset();
                this.initState(state, ctx);
            } else {
                state.setCtx(ctx, (TbActorRef)this.actorCtx);
            }
            if (msg.getStateAction() != EntityInitCalculatedFieldMsg.StateAction.REFRESH_CTX) {
                if (!state.isSizeOk()) throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).errorMessage(ctx.getSizeExceedsLimitMessage()).build();
                this.processStateIfReady(state, Collections.emptyMap(), ctx, Collections.singletonList(ctx.getCfId()), null, msg.getEventType().name(), msg.getCallback());
                return;
            } else {
                msg.getCallback().onSuccess();
            }
            return;
        }
        catch (Exception e) {
            log.debug("[{}][{}] Failed to initialize CF state", new Object[]{this.entityId, ctx.getCfId(), e});
            if (!(e instanceof CalculatedFieldException)) throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
            CalculatedFieldException cfe = (CalculatedFieldException)e;
            throw cfe;
        }
    }

    public void process(CalculatedFieldArgumentResetMsg msg) throws CalculatedFieldException {
        log.debug("[{}] Processing CF argument reset msg.", (Object)this.entityId);
        CalculatedFieldCtx ctx = msg.getCtx();
        try {
            Map<String, Argument> dynamicSourceArgs = ctx.getArguments().entrySet().stream().filter(entry -> ((Argument)entry.getValue()).hasOwnerSource()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map fetchedArgs = this.cfService.fetchArgsFromDb(this.tenantId, this.entityId, dynamicSourceArgs);
            fetchedArgs.values().forEach(arg -> arg.setForceResetPrevious(true));
            this.processArgumentValuesUpdate(ctx, Collections.singletonList(ctx.getCfId()), msg.getCallback(), fetchedArgs, null, msg.getEventType().name());
        }
        catch (Exception e) {
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
        }
    }

    public void process(CalculatedFieldEntityDeleteMsg msg) throws CalculatedFieldException {
        log.debug("[{}] Processing CF entity delete msg.", (Object)msg.getEntityId());
        if (this.entityId.equals(msg.getEntityId())) {
            if (this.states.isEmpty()) {
                msg.getCallback().onSuccess();
            } else {
                MultipleTbCallback multipleTbCallback = new MultipleTbCallback(this.states.size(), msg.getCallback());
                this.states.forEach((cfId, state) -> this.cfStateService.deleteState(new CalculatedFieldEntityCtxId(this.tenantId, cfId, this.entityId), (TbCallback)multipleTbCallback));
                this.actorCtx.stop(this.actorCtx.getSelf());
            }
        } else {
            CalculatedFieldId cfId2 = new CalculatedFieldId(msg.getEntityId().getId());
            CalculatedFieldState state2 = this.removeState(cfId2);
            if (state2 != null) {
                this.cfStateService.deleteState(new CalculatedFieldEntityCtxId(this.tenantId, cfId2, this.entityId), msg.getCallback());
            } else {
                msg.getCallback().onSuccess();
            }
        }
    }

    public void process(CalculatedFieldRelationActionMsg msg) throws CalculatedFieldException {
        log.debug("[{}] Processing CF {} related entity msg.", (Object)msg.getRelatedEntityId(), (Object)msg.getAction());
        switch (2.$SwitchMap$org$thingsboard$server$common$data$audit$ActionType[msg.getAction().ordinal()]) {
            case 1: {
                this.handleRelationUpdate(msg);
                break;
            }
            case 2: {
                this.handleRelationDelete(msg);
                break;
            }
            default: {
                msg.getCallback().onSuccess();
            }
        }
    }

    private void handleRelationUpdate(CalculatedFieldRelationActionMsg msg) throws CalculatedFieldException {
        CalculatedFieldCtx ctx = msg.getCalculatedField();
        CalculatedFieldState state = (CalculatedFieldState)this.states.get(ctx.getCfId());
        try {
            Map updatedArgs = null;
            if (state == null) {
                state = this.createState(ctx);
            } else {
                if (state instanceof RelatedEntitiesAggregationCalculatedFieldState) {
                    RelatedEntitiesAggregationCalculatedFieldState relatedEntitiesAggState = (RelatedEntitiesAggregationCalculatedFieldState)state;
                    Map fetchedArgs = this.cfService.fetchArgsFromDb(this.tenantId, msg.getRelatedEntityId(), ctx.getArguments());
                    updatedArgs = relatedEntitiesAggState.updateEntityData(this.setEntityIdToSingleEntityArguments(msg.getRelatedEntityId(), fetchedArgs));
                }
                if (state instanceof PropagationCalculatedFieldState) {
                    PropagationCalculatedFieldState propagationState = (PropagationCalculatedFieldState)state;
                    PropagationArgumentEntry entry = new PropagationArgumentEntry();
                    entry.setAdded(List.of(msg.getRelatedEntityId()));
                    updatedArgs = propagationState.update(Map.of("propagationCtx", entry), ctx);
                }
                if (CollectionsUtil.isEmpty(updatedArgs)) {
                    msg.getCallback().onSuccess();
                    return;
                }
                state.checkStateSize(new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), this.entityId), ctx.getMaxStateSize());
            }
            if (!state.isSizeOk()) {
                throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).errorMessage(ctx.getSizeExceedsLimitMessage()).build();
            }
            this.processStateIfReady(state, updatedArgs, ctx, Collections.singletonList(ctx.getCfId()), null, TbMsgType.RELATION_ADD_OR_UPDATE.name(), msg.getCallback());
        }
        catch (Exception e) {
            log.debug("[{}][{}] Failed to handle relation update", new Object[]{this.entityId, ctx.getCfId(), e});
            if (e instanceof CalculatedFieldException) {
                CalculatedFieldException cfe = (CalculatedFieldException)e;
                throw cfe;
            }
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
        }
    }

    private void handleRelationDelete(CalculatedFieldRelationActionMsg msg) throws CalculatedFieldException {
        CalculatedFieldCtx ctx = msg.getCalculatedField();
        CalculatedFieldId cfId = ctx.getCfId();
        CalculatedFieldState state = (CalculatedFieldState)this.states.get(cfId);
        try {
            if (state == null) {
                msg.getCallback().onSuccess();
                return;
            }
            if (state instanceof RelatedEntitiesAggregationCalculatedFieldState) {
                RelatedEntitiesAggregationCalculatedFieldState aggState = (RelatedEntitiesAggregationCalculatedFieldState)state;
                aggState.cleanupEntityData(msg.getRelatedEntityId());
                state.checkStateSize(new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), this.entityId), ctx.getMaxStateSize());
                if (!state.isSizeOk()) {
                    throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).errorMessage(ctx.getSizeExceedsLimitMessage()).build();
                }
                this.processStateIfReady(state, Collections.emptyMap(), ctx, Collections.singletonList(ctx.getCfId()), null, TbMsgType.RELATION_DELETED.name(), msg.getCallback());
                return;
            }
            if (state instanceof PropagationCalculatedFieldState) {
                PropagationCalculatedFieldState propagationState = (PropagationCalculatedFieldState)state;
                PropagationArgumentEntry entry = new PropagationArgumentEntry();
                entry.setRemoved(msg.getRelatedEntityId());
                propagationState.update(Map.of("propagationCtx", entry), ctx);
                if (DebugModeUtil.isDebugAllAvailable((HasDebugSettings)ctx.getCalculatedField())) {
                    this.systemContext.persistCalculatedFieldDebugEvent(this.tenantId, ctx.getCfId(), this.entityId, state.getArgumentsJson(), null, TbMsgType.RELATION_DELETED.name(), null, null);
                }
            }
            msg.getCallback().onSuccess();
        }
        catch (Exception e) {
            log.debug("[{}][{}] Failed to handle relation delete", new Object[]{this.entityId, ctx.getCfId(), e});
            if (e instanceof CalculatedFieldException) {
                CalculatedFieldException cfe = (CalculatedFieldException)e;
                throw cfe;
            }
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
        }
    }

    public void process(EntityCalculatedFieldTelemetryMsg msg) throws CalculatedFieldException {
        log.trace("[{}] Processing CF telemetry msg: {}", (Object)msg.getEntityId(), (Object)msg);
        TransportProtos.CalculatedFieldTelemetryMsgProto proto = msg.getProto();
        int numberOfCallbacks = msg.getEntityIdFields().size() + msg.getProfileIdFields().size();
        MultipleTbCallback callback = new MultipleTbCallback(numberOfCallbacks, msg.getCallback());
        List cfIdList = CalculatedFieldEntityMessageProcessor.getCalculatedFieldIds((TransportProtos.CalculatedFieldTelemetryMsgProto)proto);
        HashSet cfIdSet = new HashSet(cfIdList);
        for (CalculatedFieldCtx ctx : msg.getEntityIdFields()) {
            this.process(ctx, proto, cfIdSet, cfIdList, (TbCallback)callback);
        }
        for (CalculatedFieldCtx ctx : msg.getProfileIdFields()) {
            this.process(ctx, proto, cfIdSet, cfIdList, (TbCallback)callback);
        }
    }

    public void process(EntityCalculatedFieldLinkedTelemetryMsg msg) throws CalculatedFieldException {
        log.trace("[{}] Processing CF link telemetry msg: {}", (Object)msg.getEntityId(), (Object)msg);
        TransportProtos.CalculatedFieldTelemetryMsgProto proto = msg.getProto();
        CalculatedFieldCtx ctx = msg.getCtx();
        TbCallback callback = msg.getCallback();
        try {
            List cfIds = CalculatedFieldEntityMessageProcessor.getCalculatedFieldIds((TransportProtos.CalculatedFieldTelemetryMsgProto)proto);
            if (cfIds.contains(ctx.getCfId())) {
                callback.onSuccess();
            } else if (proto.getTsDataCount() > 0) {
                this.processArgumentValuesUpdate(ctx, cfIds, callback, this.mapToArguments(ctx, msg.getEntityId(), proto.getTsDataList()), this.toTbMsgId(proto), this.toMsgType(proto));
            } else if (proto.getAttrDataCount() > 0) {
                this.processArgumentValuesUpdate(ctx, cfIds, callback, this.mapToArguments(ctx, msg.getEntityId(), proto.getScope(), proto.getAttrDataList()), this.toTbMsgId(proto), this.toMsgType(proto));
            } else if (proto.getRemovedTsKeysCount() > 0) {
                this.processArgumentValuesUpdate(ctx, cfIds, callback, this.mapToArgumentsWithFetchedValue(ctx, msg.getEntityId(), (List)proto.getRemovedTsKeysList()), this.toTbMsgId(proto), this.toMsgType(proto));
            } else if (proto.getRemovedAttrKeysCount() > 0) {
                this.processArgumentValuesUpdate(ctx, cfIds, callback, this.mapToArgumentsWithDefaultValue(ctx, msg.getEntityId(), proto.getScope(), (List)proto.getRemovedAttrKeysList()), this.toTbMsgId(proto), this.toMsgType(proto));
            } else {
                callback.onSuccess();
            }
        }
        catch (Exception e) {
            log.debug("[{}][{}] Failed to process linked CF telemetry msg: {}", new Object[]{this.entityId, ctx.getCfId(), msg, e});
            if (e instanceof CalculatedFieldException) {
                CalculatedFieldException cfe = (CalculatedFieldException)e;
                throw cfe;
            }
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
        }
    }

    private void process(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, Collection<CalculatedFieldId> cfIds, List<CalculatedFieldId> cfIdList, TbCallback callback) throws CalculatedFieldException {
        try {
            if (cfIds.contains(ctx.getCfId())) {
                callback.onSuccess();
            } else if (proto.getTsDataCount() > 0) {
                this.processTelemetry(ctx, proto, cfIdList, callback);
            } else if (proto.getAttrDataCount() > 0) {
                this.processAttributes(ctx, proto, cfIdList, callback);
            } else if (proto.getRemovedTsKeysCount() > 0) {
                this.processRemovedTelemetry(ctx, proto, cfIdList, callback);
            } else if (proto.getRemovedAttrKeysCount() > 0) {
                this.processRemovedAttributes(ctx, proto, cfIdList, callback);
            } else {
                callback.onSuccess();
            }
        }
        catch (Exception e) {
            log.debug("[{}][{}] Failed to process CF telemetry msg: {}", new Object[]{this.entityId, ctx.getCfId(), proto, e});
            if (e instanceof CalculatedFieldException) {
                CalculatedFieldException cfe = (CalculatedFieldException)e;
                if (DebugModeUtil.isDebugFailuresAvailable((HasDebugSettings)cfe.getCtx().getCalculatedField())) {
                    this.systemContext.persistCalculatedFieldDebugError(cfe);
                }
                callback.onSuccess();
                return;
            }
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
        }
    }

    public void process(CalculatedFieldReevaluateMsg msg) throws CalculatedFieldException {
        CalculatedFieldCtx ctx = msg.getCtx();
        CalculatedFieldId cfId = ctx.getCfId();
        CalculatedFieldState state = (CalculatedFieldState)this.states.get(cfId);
        if (state == null) {
            log.warn("[{}][{}] Failed to find CF state (probably wasn't restored properly) for entity to handle {}", new Object[]{this.entityId, cfId, msg});
            state = this.createState(ctx);
        }
        if (!state.isSizeOk()) {
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).errorMessage(ctx.getSizeExceedsLimitMessage()).build();
        }
        log.debug("[{}][{}] Reevaluating CF state", (Object)this.entityId, (Object)cfId);
        this.processStateIfReady(state, null, ctx, Collections.singletonList(cfId), null, CalculatedFieldEventType.REEVALUATION_MSG.name(), msg.getCallback());
    }

    public void process(CalculatedFieldAlarmActionMsg msg) {
        log.debug("[{}] Processing alarm action event msg: {}", (Object)this.entityId, (Object)msg);
        for (CalculatedFieldState state : this.states.values()) {
            AlarmCalculatedFieldState alarmCfState;
            Alarm stateAlarm;
            if (!(state instanceof AlarmCalculatedFieldState) || (stateAlarm = (alarmCfState = (AlarmCalculatedFieldState)state).getCurrentAlarm()) == null || !stateAlarm.getId().equals((Object)msg.getAlarm().getId())) continue;
            alarmCfState.processAlarmAction(msg.getAlarm(), msg.getAction());
        }
        msg.getCallback().onSuccess();
    }

    private void processTelemetry(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, List<CalculatedFieldId> cfIdList, TbCallback callback) throws CalculatedFieldException {
        this.processArgumentValuesUpdate(ctx, cfIdList, callback, this.mapToArguments(ctx, proto.getTsDataList()), this.toTbMsgId(proto), this.toMsgType(proto));
    }

    private void processAttributes(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, List<CalculatedFieldId> cfIdList, TbCallback callback) throws CalculatedFieldException {
        this.processArgumentValuesUpdate(ctx, cfIdList, callback, this.mapToArguments(ctx, proto.getScope(), proto.getAttrDataList()), this.toTbMsgId(proto), this.toMsgType(proto));
    }

    private void processRemovedTelemetry(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, List<CalculatedFieldId> cfIdList, TbCallback callback) throws CalculatedFieldException {
        this.processArgumentValuesUpdate(ctx, cfIdList, callback, this.mapToArgumentsWithFetchedValue(ctx, this.entityId, (List)proto.getRemovedTsKeysList()), this.toTbMsgId(proto), this.toMsgType(proto));
    }

    private void processRemovedAttributes(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, List<CalculatedFieldId> cfIdList, TbCallback callback) throws CalculatedFieldException {
        this.processArgumentValuesUpdate(ctx, cfIdList, callback, this.mapToArgumentsWithDefaultValue(ctx, proto.getScope(), (List)proto.getRemovedAttrKeysList()), this.toTbMsgId(proto), this.toMsgType(proto));
    }

    private void processArgumentValuesUpdate(CalculatedFieldCtx ctx, List<CalculatedFieldId> cfIdList, TbCallback callback, Map<String, ArgumentEntry> newArgValues, UUID tbMsgId, String msgType) throws CalculatedFieldException {
        if (newArgValues.isEmpty()) {
            log.debug("[{}] No new argument values to process for CF.", (Object)ctx.getCfId());
            callback.onSuccess();
        }
        CalculatedFieldState state = (CalculatedFieldState)this.states.get(ctx.getCfId());
        boolean justRestored = false;
        if (state == null) {
            state = this.createState(ctx);
            justRestored = true;
        } else if (ctx.shouldFetchRelatedEntities(state)) {
            log.debug("[{}][{}] Going to update related entities for CF.", (Object)this.entityId, (Object)ctx.getCfId());
            try {
                List relatedEntities;
                RelatedEntitiesAggregationCalculatedFieldState relatedEntitiesState;
                List missingEntities;
                if (state instanceof RelatedEntitiesAggregationCalculatedFieldState && !(missingEntities = (relatedEntitiesState = (RelatedEntitiesAggregationCalculatedFieldState)state).checkRelatedEntities(relatedEntities = this.cfService.fetchRelatedEntities(ctx, this.entityId))).isEmpty()) {
                    missingEntities.forEach(missingEntityId -> {
                        Map fetchedArgs = this.cfService.fetchArgsFromDb(this.tenantId, missingEntityId, ctx.getArguments());
                        relatedEntitiesState.updateEntityData(this.setEntityIdToSingleEntityArguments(missingEntityId, fetchedArgs));
                    });
                    justRestored = true;
                }
                if (state instanceof GeofencingCalculatedFieldState) {
                    GeofencingCalculatedFieldState geofencingCalculatedFieldState = (GeofencingCalculatedFieldState)state;
                    Map dynamicArgsFromDb = this.cfService.fetchDynamicArgsFromDb(ctx, this.entityId);
                    dynamicArgsFromDb.forEach(newArgValues::putIfAbsent);
                    geofencingCalculatedFieldState.updateScheduledRefreshTs();
                }
            }
            catch (Exception e) {
                throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
            }
        }
        if (state.isSizeOk()) {
            Map updatedArgs = state.update(newArgValues, ctx);
            if (!updatedArgs.isEmpty() || justRestored) {
                cfIdList = new ArrayList<CalculatedFieldId>(cfIdList);
                cfIdList.add(ctx.getCfId());
                this.processStateIfReady(state, updatedArgs, ctx, cfIdList, tbMsgId, msgType, callback);
            } else {
                callback.onSuccess();
            }
        } else {
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).errorMessage(ctx.getSizeExceedsLimitMessage()).build();
        }
    }

    private CalculatedFieldState createState(CalculatedFieldCtx ctx) {
        CalculatedFieldState state = CalculatedFieldArgumentUtils.createStateByType((CalculatedFieldCtx)ctx, (EntityId)this.entityId);
        this.initState(state, ctx);
        return state;
    }

    private void initState(CalculatedFieldState state, CalculatedFieldCtx ctx) {
        state.setCtx(ctx, (TbActorRef)this.actorCtx);
        state.init(false);
        if (ctx.getCfType() == CalculatedFieldType.GEOFENCING && ctx.isCfHasRelationPathQuerySource()) {
            GeofencingCalculatedFieldState geofencingState = (GeofencingCalculatedFieldState)state;
            geofencingState.updateScheduledRefreshTs();
        }
        Map arguments = this.fetchArguments(ctx);
        state.update(arguments, ctx);
        state.checkStateSize(new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), this.entityId), ctx.getMaxStateSize());
        this.states.put(ctx.getCfId(), state);
    }

    private Map<String, ArgumentEntry> fetchArguments(CalculatedFieldCtx ctx) {
        ListenableFuture argumentsFuture = this.cfService.fetchArguments(ctx, this.entityId);
        return (Map)argumentsFuture.get(1L, TimeUnit.MINUTES);
    }

    private void processStateIfReady(CalculatedFieldState state, Map<String, ArgumentEntry> updatedArgs, CalculatedFieldCtx ctx, List<CalculatedFieldId> cfIdList, UUID tbMsgId, String tbMsgType, TbCallback callback) throws CalculatedFieldException {
        callback = new MultipleTbCallback(2, callback);
        log.trace("[{}][{}] Processing state if ready. Current args: {}, updated args: {}", new Object[]{this.entityId, ctx.getCfId(), state.getArguments(), updatedArgs});
        CalculatedFieldEntityCtxId ctxId = new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), this.entityId);
        boolean stateSizeChecked = false;
        try {
            if (ctx.isInitialized() && state.isReady()) {
                log.trace("[{}][{}] Performing calculation. Updated args: {}", new Object[]{this.entityId, ctx.getCfId(), updatedArgs});
                CalculatedFieldResult calculationResult = (CalculatedFieldResult)state.performCalculation(updatedArgs, ctx).get(this.systemContext.getCfCalculationResultTimeout(), TimeUnit.SECONDS);
                state.checkStateSize(ctxId, ctx.getMaxStateSize());
                stateSizeChecked = true;
                if (state.isSizeOk()) {
                    if (!calculationResult.isEmpty()) {
                        this.cfService.processResult(this.tenantId, this.entityId, ctx.getCfName(), calculationResult, cfIdList, callback);
                    } else {
                        callback.onSuccess();
                    }
                    if (DebugModeUtil.isDebugAllAvailable((HasDebugSettings)ctx.getCalculatedField())) {
                        this.systemContext.persistCalculatedFieldDebugEvent(this.tenantId, ctx.getCfId(), this.entityId, state.getArgumentsJson(), tbMsgId, tbMsgType, calculationResult.stringValue(), null);
                    }
                }
            } else {
                if (DebugModeUtil.isDebugFailuresAvailable((HasDebugSettings)ctx.getCalculatedField())) {
                    String errorMsg = ctx.isInitialized() ? state.getReadinessStatus().errorMsg() : "Calculated field state is not initialized!";
                    this.systemContext.persistCalculatedFieldDebugEvent(this.tenantId, ctx.getCfId(), this.entityId, state.getArgumentsJson(), tbMsgId, tbMsgType, null, errorMsg);
                }
                callback.onSuccess();
            }
        }
        catch (Exception e) {
            log.debug("[{}][{}] Failed to process CF state", new Object[]{this.entityId, ctx.getCfId(), e});
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).msgId(tbMsgId).msgType(tbMsgType).arguments(state.getArgumentsJson()).cause(e).build();
        }
        finally {
            if (!stateSizeChecked) {
                state.checkStateSize(ctxId, ctx.getMaxStateSize());
            }
            if (state.isSizeOk()) {
                this.cfStateService.persistState(ctxId, state, callback);
            } else {
                this.deleteStateAndRaiseSizeException(ctxId, CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).errorMessage(ctx.getSizeExceedsLimitMessage()).build(), callback);
            }
        }
    }

    private CalculatedFieldState removeState(CalculatedFieldId cfId) {
        CalculatedFieldState state = (CalculatedFieldState)this.states.remove(cfId);
        this.closeState(state);
        return state;
    }

    private void closeState(CalculatedFieldState state) {
        if (state != null) {
            try {
                state.close();
            }
            catch (Exception e) {
                log.warn("[{}][{}] Failed to close CF state", new Object[]{this.tenantId, state.getEntityId(), e});
            }
        }
    }

    private void deleteStateAndRaiseSizeException(CalculatedFieldEntityCtxId ctxId, CalculatedFieldException ex, TbCallback callback) throws CalculatedFieldException {
        this.cfStateService.deleteState(ctxId, (TbCallback)new /* Unavailable Anonymous Inner Class!! */);
        throw ex;
    }

    private Map<String, ArgumentEntry> mapToArguments(CalculatedFieldCtx ctx, List<TransportProtos.TsKvProto> data) {
        return this.mapToArguments(this.entityId, ctx, ctx.getMainEntityArguments(), Collections.emptyMap(), data);
    }

    private Map<String, ArgumentEntry> mapToArguments(CalculatedFieldCtx ctx, EntityId entityId, List<TransportProtos.TsKvProto> data) {
        return this.mapToArguments(entityId, ctx, ctx.getLinkedAndDynamicArgs(entityId), ctx.getRelatedEntityArguments(), data);
    }

    private Map<String, ArgumentEntry> mapToArguments(EntityId originator, CalculatedFieldCtx ctx, Map<ReferencedEntityKey, Set<String>> args, Map<ReferencedEntityKey, Set<String>> relatedEntityArgs, List<TransportProtos.TsKvProto> data) {
        HashMap<String, ArgumentEntry> arguments = new HashMap<String, ArgumentEntry>();
        if (!relatedEntityArgs.isEmpty() || !args.isEmpty()) {
            for (TransportProtos.TsKvProto item : data) {
                ReferencedEntityKey key = new ReferencedEntityKey(item.getKv().getKey(), ArgumentType.TS_LATEST, null);
                SingleValueArgumentEntry relatedArgIncoming = new SingleValueArgumentEntry(originator, item);
                this.mapLatest(ctx, relatedArgIncoming, relatedEntityArgs.get(key), arguments);
                SingleValueArgumentEntry incoming = new SingleValueArgumentEntry(item);
                this.mapLatest(ctx, incoming, args.get(key), arguments);
                key = new ReferencedEntityKey(item.getKv().getKey(), ArgumentType.TS_ROLLING, null);
                this.mapRolling(item, args.get(key), arguments);
            }
        }
        return arguments;
    }

    private void mapLatest(CalculatedFieldCtx ctx, SingleValueArgumentEntry incoming, Set<String> argNames, Map<String, ArgumentEntry> arguments) {
        if (argNames != null) {
            argNames.forEach(argName -> arguments.compute((String)argName, (name, existing) -> {
                if (existing == null) {
                    return incoming;
                }
                existing.updateEntry((ArgumentEntry)incoming, ctx);
                return existing;
            }));
        }
    }

    private void mapRolling(TransportProtos.TsKvProto item, Set<String> argNames, Map<String, ArgumentEntry> arguments) {
        if (argNames != null) {
            Double recordValue = TsRollingArgumentEntry.getValueForTsRecord((KvEntry)ProtoUtils.fromProto((TransportProtos.KeyValueProto)item.getKv()));
            argNames.forEach(argName -> arguments.compute((String)argName, (name, existing) -> {
                SingleValueArgumentEntry single;
                Double existingValue;
                if (existing instanceof TsRollingArgumentEntry) {
                    TsRollingArgumentEntry rolling = (TsRollingArgumentEntry)existing;
                    if (recordValue != null) {
                        rolling.getTsRecords().put(item.getTs(), recordValue);
                    }
                    return rolling;
                }
                TsRollingArgumentEntry rolling = new TsRollingArgumentEntry();
                if (recordValue != null) {
                    rolling.getTsRecords().put(item.getTs(), recordValue);
                }
                if (existing instanceof SingleValueArgumentEntry && (existingValue = TsRollingArgumentEntry.getValueForTsRecord((KvEntry)(single = (SingleValueArgumentEntry)existing).getKvEntryValue())) != null) {
                    rolling.getTsRecords().put(single.getTs(), existingValue);
                }
                return rolling;
            }));
        }
    }

    private Map<String, ArgumentEntry> mapToArguments(CalculatedFieldCtx ctx, TransportProtos.AttributeScopeProto scope, List<TransportProtos.AttributeValueProto> attrDataList) {
        return this.mapToArguments(this.entityId, ctx.getMainEntityArguments(), ctx.getMainEntityGeofencingArgumentNames(), Collections.emptyMap(), scope, attrDataList);
    }

    private Map<String, ArgumentEntry> mapToArguments(CalculatedFieldCtx ctx, EntityId entityId, TransportProtos.AttributeScopeProto scope, List<TransportProtos.AttributeValueProto> attrDataList) {
        Map args = ctx.getLinkedAndDynamicArgs(entityId);
        Map relatedEntityArgs = ctx.getRelatedEntityArguments();
        List geofencingArgumentNames = ctx.getLinkedEntityAndCurrentOwnerGeofencingArgumentNames();
        return this.mapToArguments(entityId, args, geofencingArgumentNames, relatedEntityArgs, scope, attrDataList);
    }

    private Map<String, ArgumentEntry> mapToArguments(EntityId entityId, Map<ReferencedEntityKey, Set<String>> args, List<String> geofencingArgNames, Map<ReferencedEntityKey, Set<String>> relatedEntityArgs, TransportProtos.AttributeScopeProto scope, List<TransportProtos.AttributeValueProto> attrDataList) {
        if (args.isEmpty() && relatedEntityArgs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ArgumentEntry> arguments = new HashMap<String, ArgumentEntry>();
        for (TransportProtos.AttributeValueProto item : attrDataList) {
            ReferencedEntityKey key = new ReferencedEntityKey(item.getKey(), ArgumentType.ATTRIBUTE, AttributeScope.valueOf((String)scope.name()));
            Set<String> argNames = relatedEntityArgs.get(key);
            if (argNames != null) {
                argNames.forEach(argName -> arguments.put((String)argName, (ArgumentEntry)new SingleValueArgumentEntry(entityId, item)));
            }
            if ((argNames = args.get(key)) == null) continue;
            argNames.forEach(argName -> {
                if (geofencingArgNames.contains(argName)) {
                    arguments.put((String)argName, (ArgumentEntry)new GeofencingArgumentEntry(entityId, item));
                } else {
                    arguments.put((String)argName, (ArgumentEntry)new SingleValueArgumentEntry(item));
                }
            });
        }
        return arguments;
    }

    private Map<String, ArgumentEntry> mapToArgumentsWithDefaultValue(CalculatedFieldCtx ctx, EntityId entityId, TransportProtos.AttributeScopeProto scope, List<String> removedAttrKeys) {
        Map args = ctx.getLinkedAndDynamicArgs(entityId);
        Map relatedEntityArgs = ctx.getRelatedEntityArguments();
        List geofencingArgumentNames = ctx.getLinkedEntityAndCurrentOwnerGeofencingArgumentNames();
        return this.mapToArgumentsWithDefaultValue(entityId, args, ctx.getArguments(), geofencingArgumentNames, relatedEntityArgs, scope, removedAttrKeys);
    }

    private Map<String, ArgumentEntry> mapToArgumentsWithDefaultValue(CalculatedFieldCtx ctx, TransportProtos.AttributeScopeProto scope, List<String> removedAttrKeys) {
        return this.mapToArgumentsWithDefaultValue(null, ctx.getMainEntityArguments(), ctx.getArguments(), ctx.getMainEntityGeofencingArgumentNames(), Collections.emptyMap(), scope, removedAttrKeys);
    }

    private Map<String, ArgumentEntry> mapToArgumentsWithDefaultValue(EntityId msgEntityId, Map<ReferencedEntityKey, Set<String>> args, Map<String, Argument> configArguments, List<String> geofencingArgNames, Map<ReferencedEntityKey, Set<String>> relatedEntityArgs, TransportProtos.AttributeScopeProto scope, List<String> removedAttrKeys) {
        if (args.isEmpty() && relatedEntityArgs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ArgumentEntry> arguments = new HashMap<String, ArgumentEntry>();
        for (String removedKey : removedAttrKeys) {
            ReferencedEntityKey key = new ReferencedEntityKey(removedKey, ArgumentType.ATTRIBUTE, AttributeScope.valueOf((String)scope.name()));
            Set<String> argNames = relatedEntityArgs.get(key);
            if (argNames != null) {
                argNames.forEach(argName -> {
                    String defaultValue = this.getDefaultValue(configArguments, argName);
                    SingleValueArgumentEntry argumentEntry = this.buildSingleValue(removedKey, defaultValue, System.currentTimeMillis());
                    arguments.put((String)argName, (ArgumentEntry)new SingleValueArgumentEntry(msgEntityId, (ArgumentEntry)argumentEntry));
                });
            }
            if ((argNames = args.get(key)) == null) continue;
            argNames.forEach(argName -> {
                if (geofencingArgNames.contains(argName)) {
                    arguments.put((String)argName, (ArgumentEntry)new GeofencingArgumentEntry());
                } else {
                    String defaultValue = this.getDefaultValue(configArguments, argName);
                    SingleValueArgumentEntry argumentEntry = this.buildSingleValue(removedKey, defaultValue, System.currentTimeMillis());
                    arguments.put((String)argName, (ArgumentEntry)new SingleValueArgumentEntry((ArgumentEntry)argumentEntry));
                }
            });
        }
        return arguments;
    }

    private String getDefaultValue(Map<String, Argument> configArguments, String argNames) {
        Argument argument = configArguments.get(argNames);
        return argument != null ? argument.getDefaultValue() : null;
    }

    private SingleValueArgumentEntry buildSingleValue(String attrKey, String defaultValue, long ts) {
        return StringUtils.isNotEmpty((String)defaultValue) ? new SingleValueArgumentEntry(ts, (BasicKvEntry)new StringDataEntry(attrKey, defaultValue), null) : new SingleValueArgumentEntry();
    }

    private Map<String, ArgumentEntry> mapToArgumentsWithFetchedValue(CalculatedFieldCtx ctx, EntityId entityId, List<String> removedTelemetryKeys) {
        Map<String, Argument> deletedArguments = ctx.getArguments().entrySet().stream().filter(entry -> removedTelemetryKeys.contains(((Argument)entry.getValue()).getRefEntityKey().getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map fetchedArgs = this.cfService.fetchArgsFromDb(this.tenantId, entityId, deletedArguments);
        if (CalculatedFieldType.RELATED_ENTITIES_AGGREGATION.equals((Object)ctx.getCfType())) {
            fetchedArgs = this.setEntityIdToSingleEntityArguments(entityId, fetchedArgs);
        }
        fetchedArgs.values().forEach(arg -> arg.setForceResetPrevious(true));
        return fetchedArgs;
    }

    private Map<String, ArgumentEntry> setEntityIdToSingleEntityArguments(EntityId relatedEntityId, Map<String, ArgumentEntry> fetchedArgs) {
        return fetchedArgs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, argEntry -> new SingleValueArgumentEntry(relatedEntityId, (ArgumentEntry)argEntry.getValue())));
    }

    private static List<CalculatedFieldId> getCalculatedFieldIds(TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        LinkedList<CalculatedFieldId> cfIds = new LinkedList<CalculatedFieldId>();
        for (TransportProtos.CalculatedFieldIdProto cfId : proto.getPreviousCalculatedFieldsList()) {
            cfIds.add(new CalculatedFieldId(new UUID(cfId.getCalculatedFieldIdMSB(), cfId.getCalculatedFieldIdLSB())));
        }
        return cfIds;
    }

    private UUID toTbMsgId(TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        if (proto.getTbMsgIdMSB() != 0L && proto.getTbMsgIdLSB() != 0L) {
            return new UUID(proto.getTbMsgIdMSB(), proto.getTbMsgIdLSB());
        }
        return null;
    }

    private String toMsgType(TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        if (!proto.getTbMsgType().isEmpty()) {
            return proto.getTbMsgType();
        }
        return null;
    }
}

