/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.app;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.ProcessFailureStrategy;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbEntityActorId;
import org.thingsboard.server.actors.app.AppActor;
import org.thingsboard.server.actors.device.SessionTimeoutCheckMsg;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.actors.tenant.TenantActor;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.ToCalculatedFieldSystemMsg;
import org.thingsboard.server.common.msg.aware.TenantAwareMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.QueueToRuleEngineMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.tenant.TenantService;

public class AppActor
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppActor.class);
    private final TenantService tenantService;
    private final Set<TenantId> deletedTenants;
    private volatile boolean ruleChainsInitialized;

    private AppActor(ActorSystemContext systemContext) {
        super(systemContext);
        this.tenantService = systemContext.getTenantService();
        this.deletedTenants = new HashSet();
    }

    public void init(TbActorCtx ctx) throws TbActorException {
        super.init(ctx);
        if (this.systemContext.getServiceInfoProvider().isService(ServiceType.TB_CORE)) {
            this.systemContext.schedulePeriodicMsgWithDelay((TbActorRef)ctx, (TbActorMsg)SessionTimeoutCheckMsg.instance(), this.systemContext.getSessionReportTimeout(), this.systemContext.getSessionReportTimeout());
        }
    }

    protected boolean doProcess(TbActorMsg msg) {
        if (!this.ruleChainsInitialized) {
            if (MsgType.APP_INIT_MSG.equals((Object)msg.getMsgType())) {
                this.initTenantActors();
                this.ruleChainsInitialized = true;
            } else {
                if (!msg.getMsgType().isIgnoreOnStart()) {
                    log.warn("Attempt to initialize Rule Chains by unexpected message: {}", (Object)msg);
                }
                return true;
            }
        }
        switch (1.$SwitchMap$org$thingsboard$server$common$msg$MsgType[msg.getMsgType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.ctx.broadcastToChildren(msg, true);
                break;
            }
            case 5: {
                this.onComponentLifecycleMsg((ComponentLifecycleMsg)msg);
                break;
            }
            case 6: {
                this.forwardToTenantActor((TenantAwareMsg)msg, true);
                break;
            }
            case 7: {
                this.onQueueToRuleEngineMsg((QueueToRuleEngineMsg)msg);
                break;
            }
            case 8: {
                this.forwardToTenantActor((TenantAwareMsg)msg, false);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.forwardToTenantActor((TenantAwareMsg)msg, true);
                break;
            }
            case 17: {
                this.ctx.broadcastToChildrenByType(msg, EntityType.TENANT);
                break;
            }
            case 18: 
            case 19: {
                this.forwardToTenantActor((TenantAwareMsg)((ToCalculatedFieldSystemMsg)msg), true);
                break;
            }
            case 20: 
            case 21: {
                this.forwardToTenantActor((TenantAwareMsg)((ToCalculatedFieldSystemMsg)msg), false);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void initTenantActors() {
        log.info("Starting main system actor.");
        try {
            if (this.systemContext.isTenantComponentsInitEnabled()) {
                PageDataIterable tenantIterator = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenants(arg_0), 1024);
                for (Tenant tenant : tenantIterator) {
                    log.debug("[{}] Creating tenant actor", (Object)tenant.getId());
                    this.getOrCreateTenantActor(tenant.getId()).ifPresentOrElse(tenantActor -> log.debug("[{}] Tenant actor created.", (Object)tenant.getId()), () -> log.debug("[{}] Skipped actor creation", (Object)tenant.getId()));
                }
            }
            log.info("Main system actor started.");
        }
        catch (Exception e) {
            log.warn("Unknown failure", (Throwable)e);
        }
    }

    private void onQueueToRuleEngineMsg(QueueToRuleEngineMsg msg) {
        if (TenantId.SYS_TENANT_ID.equals((Object)msg.getTenantId())) {
            msg.getMsg().getCallback().onFailure(new RuleEngineException("Message has system tenant id!"));
        } else {
            this.getOrCreateTenantActor(msg.getTenantId()).ifPresentOrElse(actor -> actor.tell((TbActorMsg)msg), () -> msg.getMsg().getCallback().onSuccess());
        }
    }

    private void onComponentLifecycleMsg(ComponentLifecycleMsg msg) {
        TbActorRef target = null;
        if (TenantId.SYS_TENANT_ID.equals((Object)msg.getTenantId())) {
            EntityId entityId;
            if (this.systemContext.isTenantComponentsInitEnabled() && (entityId = msg.getEntityId()) instanceof TenantProfileId) {
                TenantProfileId tenantProfileId = (TenantProfileId)entityId;
                this.tenantService.findTenantIdsByTenantProfileId(tenantProfileId).forEach(tenantId -> this.getOrCreateTenantActor(tenantId).ifPresentOrElse(tenantActor -> {
                    log.debug("[{}] Sending component lifecycle msg for tenant.", tenantId);
                    tenantActor.tellWithHighPriority((TbActorMsg)msg);
                }, () -> log.debug("Ignoring component lifecycle msg for tenant {} because it is not managed by this service", tenantId)));
            }
            if (!msg.getEntityId().getEntityType().isOneOf(new EntityType[]{EntityType.TENANT_PROFILE, EntityType.TB_RESOURCE, EntityType.USER})) {
                log.warn("Message has system tenant id: {}", (Object)msg);
            }
        } else {
            if (EntityType.TENANT.equals((Object)msg.getEntityId().getEntityType())) {
                TenantId tenantId2 = TenantId.fromUUID((UUID)msg.getEntityId().getId());
                if (msg.getEvent() == ComponentLifecycleEvent.DELETED) {
                    log.info("[{}] Handling tenant deleted notification: {}", (Object)msg.getTenantId(), (Object)msg);
                    this.deletedTenants.add(tenantId2);
                    this.ctx.stop((TbActorId)new TbEntityActorId((EntityId)tenantId2));
                    return;
                }
            }
            target = this.getOrCreateTenantActor(msg.getTenantId()).orElseGet(() -> {
                log.debug("Ignoring component lifecycle msg for tenant {} because it is not managed by this service", (Object)msg.getTenantId());
                return null;
            });
        }
        if (target != null) {
            target.tellWithHighPriority((TbActorMsg)msg);
        } else {
            log.debug("[{}] Invalid component lifecycle msg: {}", (Object)msg.getTenantId(), (Object)msg);
        }
    }

    private void forwardToTenantActor(TenantAwareMsg msg, boolean priority) {
        this.getOrCreateTenantActor(msg.getTenantId()).ifPresentOrElse(tenantActor -> {
            if (priority) {
                tenantActor.tellWithHighPriority((TbActorMsg)msg);
            } else {
                tenantActor.tell((TbActorMsg)msg);
            }
        }, () -> msg.getCallback().onSuccess());
    }

    private Optional<TbActorRef> getOrCreateTenantActor(TenantId tenantId) {
        if (this.deletedTenants.contains(tenantId)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.ctx.getOrCreateChildActor((TbActorId)new TbEntityActorId((EntityId)tenantId), () -> "tenant-dispatcher", () -> new TenantActor.ActorCreator(this.systemContext, tenantId), () -> true));
    }

    public ProcessFailureStrategy onProcessFailure(TbActorMsg msg, Throwable t) {
        log.error("Failed to process msg: {}", (Object)msg, (Object)t);
        return this.doProcessFailure(t);
    }
}

