/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.type;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.twilio.type.Rule;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RecordingRule
implements Rule {
    private static final RecordingRule recordAll = RecordingRule.builder().withType(Rule.Type.INCLUDE).withAll().build();
    private static final RecordingRule recordNone = RecordingRule.builder().withType(Rule.Type.EXCLUDE).withAll().build();
    @JsonProperty(value="type")
    private final Rule.Type type;
    @JsonProperty(value="all")
    private final Boolean all;
    @JsonProperty(value="publisher")
    private final String publisher;
    @JsonProperty(value="track")
    private final String track;
    @JsonProperty(value="kind")
    private final Rule.Kind kind;

    public RecordingRule(@JsonProperty(value="type") Rule.Type type, @JsonProperty(value="all") Boolean all, @JsonProperty(value="publisher") String publisher, @JsonProperty(value="track") String track, @JsonProperty(value="kind") Rule.Kind kind) {
        this.type = type;
        this.all = all;
        this.publisher = publisher;
        this.track = track;
        this.kind = kind;
    }

    public RecordingRule() {
        this.type = null;
        this.all = null;
        this.publisher = null;
        this.track = null;
        this.kind = null;
    }

    public static BuilderStart builder() {
        return new Builder();
    }

    @Override
    public Rule.Type getType() {
        return this.type;
    }

    @Override
    public Boolean getAll() {
        return this.all;
    }

    @Override
    public String getPublisher() {
        return this.publisher;
    }

    @Override
    public String getTrack() {
        return this.track;
    }

    @Override
    public Rule.Kind getKind() {
        return this.kind;
    }

    public static RecordingRule all() {
        return recordAll;
    }

    public static RecordingRule none() {
        return recordNone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordingRule)) {
            return false;
        }
        RecordingRule that = (RecordingRule)o;
        return this.getType() == that.getType() && Objects.equals(this.getAll(), that.getAll()) && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getTrack(), that.getTrack()) && this.getKind() == that.getKind();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getAll(), this.getPublisher(), this.getTrack(), this.getKind()});
    }

    public String toString() {
        return "RecordingRule(type=" + (Object)((Object)this.getType()) + ", all=" + this.getAll() + ", publisher=" + this.getPublisher() + ", track=" + this.getTrack() + ", kind=" + (Object)((Object)this.getKind()) + ")";
    }

    public static class Builder
    implements BuilderStart,
    BuilderMiddle,
    BuilderMiddleBuild,
    BuilderBuild {
        private Rule.Type type;
        private Boolean all;
        private String publisher;
        private Rule.Kind kind;
        private String track;

        private Builder() {
        }

        @Override
        public BuilderMiddle withType(Rule.Type type) {
            this.type = type;
            return this;
        }

        @Override
        public BuilderBuild withAll() {
            this.all = true;
            return this;
        }

        @Override
        public BuilderMiddleBuild withPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        @Override
        public BuilderMiddleBuild withKind(Rule.Kind kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public BuilderMiddleBuild withTrack(String track) {
            this.track = track;
            return this;
        }

        private boolean hasOneFilter() {
            return this.kind != null || this.all != null || this.track != null || this.publisher != null;
        }

        private boolean hasType() {
            return this.type != null;
        }

        @Override
        public RecordingRule build() {
            if (!this.hasType()) {
                throw new IllegalArgumentException("Recording Rule must have a type");
            }
            if (!this.hasOneFilter()) {
                throw new IllegalArgumentException("Recording Rule must have at least one filter");
            }
            return new RecordingRule(this.type, this.all, this.publisher, this.track, this.kind);
        }
    }

    public static interface BuilderBuild {
        public RecordingRule build();
    }

    public static interface BuilderMiddleBuild {
        public BuilderMiddleBuild withPublisher(String var1);

        public BuilderMiddleBuild withKind(Rule.Kind var1);

        public BuilderMiddleBuild withTrack(String var1);

        public RecordingRule build();
    }

    public static interface BuilderMiddle {
        public BuilderMiddleBuild withPublisher(String var1);

        public BuilderMiddleBuild withKind(Rule.Kind var1);

        public BuilderMiddleBuild withTrack(String var1);

        public BuilderBuild withAll();
    }

    public static interface BuilderStart {
        public BuilderMiddle withType(Rule.Type var1);
    }
}

