/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.SsmlBreak;
import com.twilio.twiml.voice.SsmlEmphasis;
import com.twilio.twiml.voice.SsmlP;
import com.twilio.twiml.voice.SsmlPhoneme;
import com.twilio.twiml.voice.SsmlProsody;
import com.twilio.twiml.voice.SsmlS;
import com.twilio.twiml.voice.SsmlSayAs;
import com.twilio.twiml.voice.SsmlSub;
import com.twilio.twiml.voice.SsmlW;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class SsmlLang
extends TwiML {
    private final XmlLang xmlLang;
    private final String words;

    private SsmlLang() {
        this(new Builder());
    }

    private SsmlLang(Builder b) {
        super("lang", b);
        this.xmlLang = b.xmlLang;
        this.words = b.words;
    }

    @Override
    protected String getElementBody() {
        return this.getWords() == null ? null : this.getWords();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getXmlLang() != null) {
            attrs.put("xml:lang", this.getXmlLang().toString());
        }
        return attrs;
    }

    public XmlLang getXmlLang() {
        return this.xmlLang;
    }

    public String getWords() {
        return this.words;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private XmlLang xmlLang;
        private String words;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a SsmlLang.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String words) {
            this.words = words;
        }

        public Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="xml:lang")
        public Builder xmlLang(XmlLang xmlLang) {
            this.xmlLang = xmlLang;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="break")
        public Builder break_(SsmlBreak ssmlBreak) {
            this.children.add(ssmlBreak);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="emphasis")
        public Builder emphasis(SsmlEmphasis ssmlEmphasis) {
            this.children.add(ssmlEmphasis);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="lang")
        public Builder lang(SsmlLang ssmlLang) {
            this.children.add(ssmlLang);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="p")
        public Builder p(SsmlP ssmlP) {
            this.children.add(ssmlP);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="phoneme")
        public Builder phoneme(SsmlPhoneme ssmlPhoneme) {
            this.children.add(ssmlPhoneme);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="prosody")
        public Builder prosody(SsmlProsody ssmlProsody) {
            this.children.add(ssmlProsody);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="s")
        public Builder s(SsmlS ssmlS) {
            this.children.add(ssmlS);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="say-as")
        public Builder sayAs(SsmlSayAs ssmlSayAs) {
            this.children.add(ssmlSayAs);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="sub")
        public Builder sub(SsmlSub ssmlSub) {
            this.children.add(ssmlSub);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="w")
        public Builder w(SsmlW ssmlW) {
            this.children.add(ssmlW);
            return this;
        }

        public SsmlLang build() {
            return new SsmlLang(this);
        }
    }

    public static enum XmlLang {
        ARB("arb"),
        AR_AE("ar-AE"),
        CA_ES("ca-ES"),
        CMN_CN("cmn-CN"),
        CY_GB("cy-GB"),
        DA_DK("da-DK"),
        DE_DE("de-DE"),
        DE_AT("de-AT"),
        EN_AU("en-AU"),
        EN_GB("en-GB"),
        EN_GB_WLS("en-GB-WLS"),
        EN_IN("en-IN"),
        EN_NZ("en-NZ"),
        EN_US("en-US"),
        EN_ZA("en-ZA"),
        ES_ES("es-ES"),
        ES_MX("es-MX"),
        ES_US("es-US"),
        FI_FI("fi-FI"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        HE_IL("he-IL"),
        HI_IN("hi-IN"),
        IS_IS("is-IS"),
        IT_IT("it-IT"),
        JA_JP("ja-JP"),
        KO_KR("ko-KR"),
        NB_NO("nb-NO"),
        NL_NL("nl-NL"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RO_RO("ro-RO"),
        RU_RU("ru-RU"),
        SV_SE("sv-SE"),
        TR_TR("tr-TR"),
        YUE_CN("yue-CN");

        private final String value;

        private XmlLang(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

