/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.Autopilot;
import com.twilio.twiml.voice.Conversation;
import com.twilio.twiml.voice.Room;
import com.twilio.twiml.voice.Stream;
import com.twilio.twiml.voice.VirtualAgent;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Connect
extends TwiML {
    private final URI action;
    private final HttpMethod method;

    private Connect() {
        this(new Builder());
    }

    private Connect(Builder b) {
        super("Connect", b);
        this.action = b.action;
        this.method = b.method;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        return attrs;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI action;
        private HttpMethod method;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Connect.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="action")
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Room")
        public Builder room(Room room) {
            this.children.add(room);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Autopilot")
        public Builder autopilot(Autopilot autopilot) {
            this.children.add(autopilot);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Stream")
        public Builder stream(Stream stream) {
            this.children.add(stream);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="VirtualAgent")
        public Builder virtualAgent(VirtualAgent virtualAgent) {
            this.children.add(virtualAgent);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Conversation")
        public Builder conversation(Conversation conversation) {
            this.children.add(conversation);
            return this;
        }

        public Connect build() {
            return new Connect(this);
        }
    }
}

