/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.ApplicationSid;
import com.twilio.twiml.voice.Parameter;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Application
extends TwiML {
    private final URI url;
    private final HttpMethod method;
    private final List<Event> statusCallbackEvent;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String customerId;
    private final Boolean copyParentTo;
    private final String applicationSid;

    private Application() {
        this(new Builder());
    }

    private Application(Builder b) {
        super("Application", b);
        this.url = b.url;
        this.method = b.method;
        this.statusCallbackEvent = b.statusCallbackEvent;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.customerId = b.customerId;
        this.copyParentTo = b.copyParentTo;
        this.applicationSid = b.applicationSid;
    }

    @Override
    protected String getElementBody() {
        return this.getApplicationSid() == null ? null : this.getApplicationSid();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getUrl() != null) {
            attrs.put("url", this.getUrl().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getStatusCallbackEvents() != null) {
            attrs.put("statusCallbackEvent", this.getStatusCallbackEventsAsString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getCustomerId() != null) {
            attrs.put("customerId", this.getCustomerId());
        }
        if (this.isCopyParentTo() != null) {
            attrs.put("copyParentTo", this.isCopyParentTo().toString());
        }
        return attrs;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<Event> getStatusCallbackEvents() {
        return this.statusCallbackEvent;
    }

    protected String getStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Event> iter = this.getStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public Boolean isCopyParentTo() {
        return this.copyParentTo;
    }

    public String getApplicationSid() {
        return this.applicationSid;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI url;
        private HttpMethod method;
        private List<Event> statusCallbackEvent;
        private URI statusCallback;
        private HttpMethod statusCallbackMethod;
        private String customerId;
        private Boolean copyParentTo;
        private String applicationSid;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Application.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String applicationSid) {
            this.applicationSid = applicationSid;
        }

        public Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="url")
        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackEvent")
        public Builder statusCallbackEvents(List<Event> statusCallbackEvent) {
            this.statusCallbackEvent = statusCallbackEvent;
            return this;
        }

        public Builder statusCallbackEvents(Event statusCallbackEvent) {
            this.statusCallbackEvent = Promoter.listOfOne(statusCallbackEvent);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallback")
        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackMethod")
        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="customerId")
        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="copyParentTo")
        public Builder copyParentTo(Boolean copyParentTo) {
            this.copyParentTo = copyParentTo;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="applicationSid")
        public Builder applicationSid(String applicationSid) {
            this.applicationSid = applicationSid;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="ApplicationSid")
        public Builder applicationSid(ApplicationSid applicationSid) {
            this.children.add(applicationSid);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Parameter")
        public Builder parameter(Parameter parameter) {
            this.children.add(parameter);
            return this;
        }

        public Application build() {
            return new Application(this);
        }
    }

    public static enum Event {
        INITIATED("initiated"),
        RINGING("ringing"),
        ANSWERED("answered"),
        COMPLETED("completed");

        private final String value;

        private Event(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

