/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.fax;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Receive
extends TwiML {
    private final URI action;
    private final HttpMethod method;
    private final MediaType mediaType;
    private final PageSize pageSize;
    private final Boolean storeMedia;

    private Receive() {
        this(new Builder());
    }

    private Receive(Builder b) {
        super("Receive", b);
        this.action = b.action;
        this.method = b.method;
        this.mediaType = b.mediaType;
        this.pageSize = b.pageSize;
        this.storeMedia = b.storeMedia;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getMediaType() != null) {
            attrs.put("mediaType", this.getMediaType().toString());
        }
        if (this.getPageSize() != null) {
            attrs.put("pageSize", this.getPageSize().toString());
        }
        if (this.isStoreMedia() != null) {
            attrs.put("storeMedia", this.isStoreMedia().toString());
        }
        return attrs;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public PageSize getPageSize() {
        return this.pageSize;
    }

    public Boolean isStoreMedia() {
        return this.storeMedia;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI action;
        private HttpMethod method;
        private MediaType mediaType;
        private PageSize pageSize;
        private Boolean storeMedia;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Receive.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="action")
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="mediaType")
        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="pageSize")
        public Builder pageSize(PageSize pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="storeMedia")
        public Builder storeMedia(Boolean storeMedia) {
            this.storeMedia = storeMedia;
            return this;
        }

        public Receive build() {
            return new Receive(this);
        }
    }

    public static enum PageSize {
        LETTER("letter"),
        LEGAL("legal"),
        A4("a4");

        private final String value;

        private PageSize(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum MediaType {
        APPLICATION_PDF("application/pdf"),
        IMAGE_TIFF("image/tiff");

        private final String value;

        private MediaType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

