/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.ConnectionPolicy;

public class ConnectionPolicyFetcher
extends Fetcher<ConnectionPolicy> {
    private String pathSid;

    public ConnectionPolicyFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public ConnectionPolicy fetch(TwilioRestClient client) {
        String path = "/v1/ConnectionPolicies/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.VOICE.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConnectionPolicy fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ConnectionPolicy.fromJson(response.getStream(), client.getObjectMapper());
    }
}

