/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.Room;

public class RoomUpdater
extends Updater<Room> {
    private String pathSid;
    private Room.RoomStatus status;

    public RoomUpdater(String pathSid, Room.RoomStatus status) {
        this.pathSid = pathSid;
        this.status = status;
    }

    public RoomUpdater setStatus(Room.RoomStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public Room update(TwilioRestClient client) {
        String path = "/v1/Rooms/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{Status}", this.status.toString());
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Room update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Room.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

