/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.CompositionHook;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class CompositionHookUpdater
extends Updater<CompositionHook> {
    private String pathSid;
    private String friendlyName;
    private Boolean enabled;
    private Map<String, Object> videoLayout;
    private List<String> audioSources;
    private List<String> audioSourcesExcluded;
    private Boolean trim;
    private CompositionHook.Format format;
    private String resolution;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;

    public CompositionHookUpdater(String pathSid, String friendlyName) {
        this.pathSid = pathSid;
        this.friendlyName = friendlyName;
    }

    public CompositionHookUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public CompositionHookUpdater setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public CompositionHookUpdater setVideoLayout(Map<String, Object> videoLayout) {
        this.videoLayout = videoLayout;
        return this;
    }

    public CompositionHookUpdater setAudioSources(List<String> audioSources) {
        this.audioSources = audioSources;
        return this;
    }

    public CompositionHookUpdater setAudioSources(String audioSources) {
        return this.setAudioSources(Promoter.listOfOne(audioSources));
    }

    public CompositionHookUpdater setAudioSourcesExcluded(List<String> audioSourcesExcluded) {
        this.audioSourcesExcluded = audioSourcesExcluded;
        return this;
    }

    public CompositionHookUpdater setAudioSourcesExcluded(String audioSourcesExcluded) {
        return this.setAudioSourcesExcluded(Promoter.listOfOne(audioSourcesExcluded));
    }

    public CompositionHookUpdater setTrim(Boolean trim) {
        this.trim = trim;
        return this;
    }

    public CompositionHookUpdater setFormat(CompositionHook.Format format) {
        this.format = format;
        return this;
    }

    public CompositionHookUpdater setResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    public CompositionHookUpdater setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public CompositionHookUpdater setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public CompositionHookUpdater setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    @Override
    public CompositionHook update(TwilioRestClient client) {
        String path = "/v1/CompositionHooks/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CompositionHook update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return CompositionHook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
        if (this.videoLayout != null) {
            request.addPostParam("VideoLayout", Converter.mapToJson(this.videoLayout));
        }
        if (this.audioSources != null) {
            for (String prop : this.audioSources) {
                request.addPostParam("AudioSources", prop);
            }
        }
        if (this.audioSourcesExcluded != null) {
            for (String prop : this.audioSourcesExcluded) {
                request.addPostParam("AudioSourcesExcluded", prop);
            }
        }
        if (this.trim != null) {
            request.addPostParam("Trim", this.trim.toString());
        }
        if (this.format != null) {
            request.addPostParam("Format", this.format.toString());
        }
        if (this.resolution != null) {
            request.addPostParam("Resolution", this.resolution);
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
    }
}

