/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.ratelimit;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.ratelimit.Bucket;

public class BucketCreator
extends Creator<Bucket> {
    private String pathServiceSid;
    private String pathRateLimitSid;
    private Integer max;
    private Integer interval;

    public BucketCreator(String pathServiceSid, String pathRateLimitSid, Integer max, Integer interval) {
        this.pathServiceSid = pathServiceSid;
        this.pathRateLimitSid = pathRateLimitSid;
        this.max = max;
        this.interval = interval;
    }

    public BucketCreator setMax(Integer max) {
        this.max = max;
        return this;
    }

    public BucketCreator setInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    @Override
    public Bucket create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/RateLimits/{RateLimitSid}/Buckets";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{RateLimitSid}", this.pathRateLimitSid.toString());
        path = path.replace("{Max}", this.max.toString());
        path = path.replace("{Interval}", this.interval.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Bucket creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Bucket.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.max != null) {
            request.addPostParam("Max", this.max.toString());
        }
        if (this.interval != null) {
            request.addPostParam("Interval", this.interval.toString());
        }
    }
}

