/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.entity.Challenge;
import java.util.Map;

public class ChallengeUpdater
extends Updater<Challenge> {
    private String pathServiceSid;
    private String pathIdentity;
    private String pathSid;
    private String authPayload;
    private Map<String, Object> metadata;

    public ChallengeUpdater(String pathServiceSid, String pathIdentity, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathSid = pathSid;
    }

    public ChallengeUpdater setAuthPayload(String authPayload) {
        this.authPayload = authPayload;
        return this;
    }

    public ChallengeUpdater setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public Challenge update(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Entities/{Identity}/Challenges/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Challenge update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Challenge.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.authPayload != null) {
            request.addPostParam("AuthPayload", this.authPayload);
        }
        if (this.metadata != null) {
            request.addPostParam("Metadata", Converter.mapToJson(this.metadata));
        }
    }
}

