/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.entity.ChallengeCreator;
import com.twilio.rest.verify.v2.service.entity.ChallengeFetcher;
import com.twilio.rest.verify.v2.service.entity.ChallengeReader;
import com.twilio.rest.verify.v2.service.entity.ChallengeUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Challenge
extends Resource {
    private static final long serialVersionUID = 265978723470772L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String entitySid;
    private final String identity;
    private final String factorSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime dateResponded;
    private final ZonedDateTime expirationDate;
    private final ChallengeStatuses status;
    private final ChallengeReasons respondedReason;
    private final Map<String, Object> details;
    private final Map<String, Object> hiddenDetails;
    private final Map<String, Object> metadata;
    private final FactorTypes factorType;
    private final URI url;
    private final Map<String, String> links;

    public static ChallengeCreator creator(String pathServiceSid, String pathIdentity, String factorSid) {
        return new ChallengeCreator(pathServiceSid, pathIdentity, factorSid);
    }

    public static ChallengeFetcher fetcher(String pathServiceSid, String pathIdentity, String pathSid) {
        return new ChallengeFetcher(pathServiceSid, pathIdentity, pathSid);
    }

    public static ChallengeReader reader(String pathServiceSid, String pathIdentity) {
        return new ChallengeReader(pathServiceSid, pathIdentity);
    }

    public static ChallengeUpdater updater(String pathServiceSid, String pathIdentity, String pathSid) {
        return new ChallengeUpdater(pathServiceSid, pathIdentity, pathSid);
    }

    public static Challenge fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Challenge.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Challenge fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Challenge.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Challenge(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="entity_sid") String entitySid, @JsonProperty(value="identity") String identity, @JsonProperty(value="factor_sid") String factorSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_responded") String dateResponded, @JsonProperty(value="expiration_date") String expirationDate, @JsonProperty(value="status") ChallengeStatuses status, @JsonProperty(value="responded_reason") ChallengeReasons respondedReason, @JsonProperty(value="details") Map<String, Object> details, @JsonProperty(value="hidden_details") Map<String, Object> hiddenDetails, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="factor_type") FactorTypes factorType, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.entitySid = entitySid;
        this.identity = identity;
        this.factorSid = factorSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.dateResponded = DateConverter.iso8601DateTimeFromString(dateResponded);
        this.expirationDate = DateConverter.iso8601DateTimeFromString(expirationDate);
        this.status = status;
        this.respondedReason = respondedReason;
        this.details = details;
        this.hiddenDetails = hiddenDetails;
        this.metadata = metadata;
        this.factorType = factorType;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEntitySid() {
        return this.entitySid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getFactorSid() {
        return this.factorSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getDateResponded() {
        return this.dateResponded;
    }

    public final ZonedDateTime getExpirationDate() {
        return this.expirationDate;
    }

    public final ChallengeStatuses getStatus() {
        return this.status;
    }

    public final ChallengeReasons getRespondedReason() {
        return this.respondedReason;
    }

    public final Map<String, Object> getDetails() {
        return this.details;
    }

    public final Map<String, Object> getHiddenDetails() {
        return this.hiddenDetails;
    }

    public final Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public final FactorTypes getFactorType() {
        return this.factorType;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Challenge other = (Challenge)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.entitySid, other.entitySid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.factorSid, other.factorSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateResponded, other.dateResponded) && Objects.equals(this.expirationDate, other.expirationDate) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.respondedReason, (Object)other.respondedReason) && Objects.equals(this.details, other.details) && Objects.equals(this.hiddenDetails, other.hiddenDetails) && Objects.equals(this.metadata, other.metadata) && Objects.equals((Object)this.factorType, (Object)other.factorType) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.entitySid, this.identity, this.factorSid, this.dateCreated, this.dateUpdated, this.dateResponded, this.expirationDate, this.status, this.respondedReason, this.details, this.hiddenDetails, this.metadata, this.factorType, this.url, this.links});
    }

    public String toString() {
        return "Challenge(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", entitySid=" + this.getEntitySid() + ", identity=" + this.getIdentity() + ", factorSid=" + this.getFactorSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", dateResponded=" + this.getDateResponded() + ", expirationDate=" + this.getExpirationDate() + ", status=" + (Object)((Object)this.getStatus()) + ", respondedReason=" + (Object)((Object)this.getRespondedReason()) + ", details=" + this.getDetails() + ", hiddenDetails=" + this.getHiddenDetails() + ", metadata=" + this.getMetadata() + ", factorType=" + (Object)((Object)this.getFactorType()) + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum ChallengeStatuses {
        PENDING("pending"),
        EXPIRED("expired"),
        APPROVED("approved"),
        DENIED("denied");

        private final String value;

        private ChallengeStatuses(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChallengeStatuses forValue(String value) {
            return (ChallengeStatuses)Promoter.enumFromString((String)value, (Enum[])ChallengeStatuses.values());
        }
    }

    public static enum ChallengeReasons {
        NONE("none"),
        NOT_NEEDED("not_needed"),
        NOT_REQUESTED("not_requested");

        private final String value;

        private ChallengeReasons(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChallengeReasons forValue(String value) {
            return (ChallengeReasons)Promoter.enumFromString((String)value, (Enum[])ChallengeReasons.values());
        }
    }

    public static enum FactorTypes {
        PUSH("push"),
        TOTP("totp");

        private final String value;

        private FactorTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FactorTypes forValue(String value) {
            return (FactorTypes)Promoter.enumFromString((String)value, (Enum[])FactorTypes.values());
        }
    }

    public static enum ListOrders {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private ListOrders(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ListOrders forValue(String value) {
            return (ListOrders)Promoter.enumFromString((String)value, (Enum[])ListOrders.values());
        }
    }
}

