/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.Verification;
import java.util.Map;

public class VerificationCreator
extends Creator<Verification> {
    private String pathServiceSid;
    private String to;
    private String channel;
    private String customFriendlyName;
    private String customMessage;
    private String sendDigits;
    private String locale;
    private String customCode;
    private String amount;
    private String payee;
    private Map<String, Object> rateLimits;
    private Map<String, Object> channelConfiguration;
    private String appHash;
    private String templateSid;
    private String templateCustomSubstitutions;
    private String deviceIp;
    private Verification.RiskCheck riskCheck;
    private String tags;

    public VerificationCreator(String pathServiceSid, String to, String channel) {
        this.pathServiceSid = pathServiceSid;
        this.to = to;
        this.channel = channel;
    }

    public VerificationCreator setTo(String to) {
        this.to = to;
        return this;
    }

    public VerificationCreator setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public VerificationCreator setCustomFriendlyName(String customFriendlyName) {
        this.customFriendlyName = customFriendlyName;
        return this;
    }

    public VerificationCreator setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
        return this;
    }

    public VerificationCreator setSendDigits(String sendDigits) {
        this.sendDigits = sendDigits;
        return this;
    }

    public VerificationCreator setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public VerificationCreator setCustomCode(String customCode) {
        this.customCode = customCode;
        return this;
    }

    public VerificationCreator setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public VerificationCreator setPayee(String payee) {
        this.payee = payee;
        return this;
    }

    public VerificationCreator setRateLimits(Map<String, Object> rateLimits) {
        this.rateLimits = rateLimits;
        return this;
    }

    public VerificationCreator setChannelConfiguration(Map<String, Object> channelConfiguration) {
        this.channelConfiguration = channelConfiguration;
        return this;
    }

    public VerificationCreator setAppHash(String appHash) {
        this.appHash = appHash;
        return this;
    }

    public VerificationCreator setTemplateSid(String templateSid) {
        this.templateSid = templateSid;
        return this;
    }

    public VerificationCreator setTemplateCustomSubstitutions(String templateCustomSubstitutions) {
        this.templateCustomSubstitutions = templateCustomSubstitutions;
        return this;
    }

    public VerificationCreator setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    public VerificationCreator setRiskCheck(Verification.RiskCheck riskCheck) {
        this.riskCheck = riskCheck;
        return this;
    }

    public VerificationCreator setTags(String tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public Verification create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Verifications";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{To}", this.to.toString());
        path = path.replace("{Channel}", this.channel.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Verification creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Verification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.channel != null) {
            request.addPostParam("Channel", this.channel);
        }
        if (this.customFriendlyName != null) {
            request.addPostParam("CustomFriendlyName", this.customFriendlyName);
        }
        if (this.customMessage != null) {
            request.addPostParam("CustomMessage", this.customMessage);
        }
        if (this.sendDigits != null) {
            request.addPostParam("SendDigits", this.sendDigits);
        }
        if (this.locale != null) {
            request.addPostParam("Locale", this.locale);
        }
        if (this.customCode != null) {
            request.addPostParam("CustomCode", this.customCode);
        }
        if (this.amount != null) {
            request.addPostParam("Amount", this.amount);
        }
        if (this.payee != null) {
            request.addPostParam("Payee", this.payee);
        }
        if (this.rateLimits != null) {
            request.addPostParam("RateLimits", Converter.mapToJson(this.rateLimits));
        }
        if (this.channelConfiguration != null) {
            request.addPostParam("ChannelConfiguration", Converter.mapToJson(this.channelConfiguration));
        }
        if (this.appHash != null) {
            request.addPostParam("AppHash", this.appHash);
        }
        if (this.templateSid != null) {
            request.addPostParam("TemplateSid", this.templateSid);
        }
        if (this.templateCustomSubstitutions != null) {
            request.addPostParam("TemplateCustomSubstitutions", this.templateCustomSubstitutions);
        }
        if (this.deviceIp != null) {
            request.addPostParam("DeviceIp", this.deviceIp);
        }
        if (this.riskCheck != null) {
            request.addPostParam("RiskCheck", this.riskCheck.toString());
        }
        if (this.tags != null) {
            request.addPostParam("Tags", this.tags);
        }
    }
}

