/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.VerificationAttemptsSummaryFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VerificationAttemptsSummary
extends Resource {
    private static final long serialVersionUID = 224637081616234L;
    private final Integer totalAttempts;
    private final Integer totalConverted;
    private final Integer totalUnconverted;
    private final BigDecimal conversionRatePercentage;
    private final URI url;

    public static VerificationAttemptsSummaryFetcher fetcher() {
        return new VerificationAttemptsSummaryFetcher();
    }

    public static VerificationAttemptsSummary fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, VerificationAttemptsSummary.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static VerificationAttemptsSummary fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, VerificationAttemptsSummary.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private VerificationAttemptsSummary(@JsonProperty(value="total_attempts") Integer totalAttempts, @JsonProperty(value="total_converted") Integer totalConverted, @JsonProperty(value="total_unconverted") Integer totalUnconverted, @JsonProperty(value="conversion_rate_percentage") BigDecimal conversionRatePercentage, @JsonProperty(value="url") URI url) {
        this.totalAttempts = totalAttempts;
        this.totalConverted = totalConverted;
        this.totalUnconverted = totalUnconverted;
        this.conversionRatePercentage = conversionRatePercentage;
        this.url = url;
    }

    public final Integer getTotalAttempts() {
        return this.totalAttempts;
    }

    public final Integer getTotalConverted() {
        return this.totalConverted;
    }

    public final Integer getTotalUnconverted() {
        return this.totalUnconverted;
    }

    public final BigDecimal getConversionRatePercentage() {
        return this.conversionRatePercentage;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationAttemptsSummary other = (VerificationAttemptsSummary)o;
        return Objects.equals(this.totalAttempts, other.totalAttempts) && Objects.equals(this.totalConverted, other.totalConverted) && Objects.equals(this.totalUnconverted, other.totalUnconverted) && Objects.equals(this.conversionRatePercentage, other.conversionRatePercentage) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.totalAttempts, this.totalConverted, this.totalUnconverted, this.conversionRatePercentage, this.url);
    }

    public String toString() {
        return "VerificationAttemptsSummary(totalAttempts=" + this.getTotalAttempts() + ", totalConverted=" + this.getTotalConverted() + ", totalUnconverted=" + this.getTotalUnconverted() + ", conversionRatePercentage=" + this.getConversionRatePercentage() + ", url=" + this.getUrl() + ")";
    }

    public static enum Channels {
        SMS("sms"),
        CALL("call"),
        EMAIL("email"),
        WHATSAPP("whatsapp");

        private final String value;

        private Channels(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Channels forValue(String value) {
            return (Channels)Promoter.enumFromString((String)value, (Enum[])Channels.values());
        }
    }
}

