/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.trustproducts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEvaluationsCreator;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEvaluationsFetcher;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEvaluationsReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TrustProductsEvaluations
extends Resource {
    private static final long serialVersionUID = 86634042597263L;
    private final String sid;
    private final String accountSid;
    private final String policySid;
    private final String trustProductSid;
    private final Status status;
    private final List<Map<String, Object>> results;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static TrustProductsEvaluationsCreator creator(String pathTrustProductSid, String policySid) {
        return new TrustProductsEvaluationsCreator(pathTrustProductSid, policySid);
    }

    public static TrustProductsEvaluationsFetcher fetcher(String pathTrustProductSid, String pathSid) {
        return new TrustProductsEvaluationsFetcher(pathTrustProductSid, pathSid);
    }

    public static TrustProductsEvaluationsReader reader(String pathTrustProductSid) {
        return new TrustProductsEvaluationsReader(pathTrustProductSid);
    }

    public static TrustProductsEvaluations fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TrustProductsEvaluations.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TrustProductsEvaluations fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TrustProductsEvaluations.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TrustProductsEvaluations(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="policy_sid") String policySid, @JsonProperty(value="trust_product_sid") String trustProductSid, @JsonProperty(value="status") Status status, @JsonProperty(value="results") List<Map<String, Object>> results, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.policySid = policySid;
        this.trustProductSid = trustProductSid;
        this.status = status;
        this.results = results;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getPolicySid() {
        return this.policySid;
    }

    public final String getTrustProductSid() {
        return this.trustProductSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final List<Map<String, Object>> getResults() {
        return this.results;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustProductsEvaluations other = (TrustProductsEvaluations)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.policySid, other.policySid) && Objects.equals(this.trustProductSid, other.trustProductSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.results, other.results) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.policySid, this.trustProductSid, this.status, this.results, this.dateCreated, this.url});
    }

    public String toString() {
        return "TrustProductsEvaluations(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", policySid=" + this.getPolicySid() + ", trustProductSid=" + this.getTrustProductSid() + ", status=" + (Object)((Object)this.getStatus()) + ", results=" + this.getResults() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        COMPLIANT("compliant"),
        NONCOMPLIANT("noncompliant");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

