/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.customerprofiles;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEvaluations;

public class CustomerProfilesEvaluationsReader
extends Reader<CustomerProfilesEvaluations> {
    private String pathCustomerProfileSid;
    private Integer pageSize;

    public CustomerProfilesEvaluationsReader(String pathCustomerProfileSid) {
        this.pathCustomerProfileSid = pathCustomerProfileSid;
    }

    public CustomerProfilesEvaluationsReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<CustomerProfilesEvaluations> read(TwilioRestClient client) {
        return new ResourceSet<CustomerProfilesEvaluations>(this, client, this.firstPage(client));
    }

    @Override
    public Page<CustomerProfilesEvaluations> firstPage(TwilioRestClient client) {
        String path = "/v1/CustomerProfiles/{CustomerProfileSid}/Evaluations";
        path = path.replace("{CustomerProfileSid}", this.pathCustomerProfileSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TRUSTHUB.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<CustomerProfilesEvaluations> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CustomerProfilesEvaluations read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), CustomerProfilesEvaluations.class, client.getObjectMapper());
    }

    @Override
    public Page<CustomerProfilesEvaluations> previousPage(Page<CustomerProfilesEvaluations> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfilesEvaluations> nextPage(Page<CustomerProfilesEvaluations> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfilesEvaluations> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

