/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.customerprofiles;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEntityAssignments;

public class CustomerProfilesEntityAssignmentsFetcher
extends Fetcher<CustomerProfilesEntityAssignments> {
    private String pathCustomerProfileSid;
    private String pathSid;

    public CustomerProfilesEntityAssignmentsFetcher(String pathCustomerProfileSid, String pathSid) {
        this.pathCustomerProfileSid = pathCustomerProfileSid;
        this.pathSid = pathSid;
    }

    @Override
    public CustomerProfilesEntityAssignments fetch(TwilioRestClient client) {
        String path = "/v1/CustomerProfiles/{CustomerProfileSid}/EntityAssignments/{Sid}";
        path = path.replace("{CustomerProfileSid}", this.pathCustomerProfileSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TRUSTHUB.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CustomerProfilesEntityAssignments fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return CustomerProfilesEntityAssignments.fromJson(response.getStream(), client.getObjectMapper());
    }
}

