/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.customerprofiles;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesChannelEndpointAssignment;

public class CustomerProfilesChannelEndpointAssignmentReader
extends Reader<CustomerProfilesChannelEndpointAssignment> {
    private String pathCustomerProfileSid;
    private String channelEndpointSid;
    private String channelEndpointSids;
    private Integer pageSize;

    public CustomerProfilesChannelEndpointAssignmentReader(String pathCustomerProfileSid) {
        this.pathCustomerProfileSid = pathCustomerProfileSid;
    }

    public CustomerProfilesChannelEndpointAssignmentReader setChannelEndpointSid(String channelEndpointSid) {
        this.channelEndpointSid = channelEndpointSid;
        return this;
    }

    public CustomerProfilesChannelEndpointAssignmentReader setChannelEndpointSids(String channelEndpointSids) {
        this.channelEndpointSids = channelEndpointSids;
        return this;
    }

    public CustomerProfilesChannelEndpointAssignmentReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<CustomerProfilesChannelEndpointAssignment> read(TwilioRestClient client) {
        return new ResourceSet<CustomerProfilesChannelEndpointAssignment>(this, client, this.firstPage(client));
    }

    @Override
    public Page<CustomerProfilesChannelEndpointAssignment> firstPage(TwilioRestClient client) {
        String path = "/v1/CustomerProfiles/{CustomerProfileSid}/ChannelEndpointAssignments";
        path = path.replace("{CustomerProfileSid}", this.pathCustomerProfileSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TRUSTHUB.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<CustomerProfilesChannelEndpointAssignment> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CustomerProfilesChannelEndpointAssignment read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), CustomerProfilesChannelEndpointAssignment.class, client.getObjectMapper());
    }

    @Override
    public Page<CustomerProfilesChannelEndpointAssignment> previousPage(Page<CustomerProfilesChannelEndpointAssignment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfilesChannelEndpointAssignment> nextPage(Page<CustomerProfilesChannelEndpointAssignment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfilesChannelEndpointAssignment> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.channelEndpointSid != null) {
            request.addQueryParam("ChannelEndpointSid", this.channelEndpointSid);
        }
        if (this.channelEndpointSids != null) {
            request.addQueryParam("ChannelEndpointSids", this.channelEndpointSids);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

