/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.CustomerProfiles;

public class CustomerProfilesReader
extends Reader<CustomerProfiles> {
    private CustomerProfiles.Status status;
    private String friendlyName;
    private String policySid;
    private Integer pageSize;

    public CustomerProfilesReader setStatus(CustomerProfiles.Status status) {
        this.status = status;
        return this;
    }

    public CustomerProfilesReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public CustomerProfilesReader setPolicySid(String policySid) {
        this.policySid = policySid;
        return this;
    }

    public CustomerProfilesReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<CustomerProfiles> read(TwilioRestClient client) {
        return new ResourceSet<CustomerProfiles>(this, client, this.firstPage(client));
    }

    @Override
    public Page<CustomerProfiles> firstPage(TwilioRestClient client) {
        String path = "/v1/CustomerProfiles";
        Request request = new Request(HttpMethod.GET, Domains.TRUSTHUB.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<CustomerProfiles> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CustomerProfiles read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), CustomerProfiles.class, client.getObjectMapper());
    }

    @Override
    public Page<CustomerProfiles> previousPage(Page<CustomerProfiles> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfiles> nextPage(Page<CustomerProfiles> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfiles> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.policySid != null) {
            request.addQueryParam("PolicySid", this.policySid);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

