/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.ComplianceTollfreeInquiriesCreator;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComplianceTollfreeInquiries
extends Resource {
    private static final long serialVersionUID = 153862952025802L;
    private final String inquiryId;
    private final String inquirySessionToken;
    private final String registrationId;
    private final URI url;

    public static ComplianceTollfreeInquiriesCreator creator(PhoneNumber tollfreePhoneNumber, String notificationEmail) {
        return new ComplianceTollfreeInquiriesCreator(tollfreePhoneNumber, notificationEmail);
    }

    public static ComplianceTollfreeInquiries fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ComplianceTollfreeInquiries.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ComplianceTollfreeInquiries fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ComplianceTollfreeInquiries.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ComplianceTollfreeInquiries(@JsonProperty(value="inquiry_id") String inquiryId, @JsonProperty(value="inquiry_session_token") String inquirySessionToken, @JsonProperty(value="registration_id") String registrationId, @JsonProperty(value="url") URI url) {
        this.inquiryId = inquiryId;
        this.inquirySessionToken = inquirySessionToken;
        this.registrationId = registrationId;
        this.url = url;
    }

    public final String getInquiryId() {
        return this.inquiryId;
    }

    public final String getInquirySessionToken() {
        return this.inquirySessionToken;
    }

    public final String getRegistrationId() {
        return this.registrationId;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplianceTollfreeInquiries other = (ComplianceTollfreeInquiries)o;
        return Objects.equals(this.inquiryId, other.inquiryId) && Objects.equals(this.inquirySessionToken, other.inquirySessionToken) && Objects.equals(this.registrationId, other.registrationId) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.inquiryId, this.inquirySessionToken, this.registrationId, this.url);
    }

    public String toString() {
        return "ComplianceTollfreeInquiries(inquiryId=" + this.getInquiryId() + ", inquirySessionToken=" + this.getInquirySessionToken() + ", registrationId=" + this.getRegistrationId() + ", url=" + this.getUrl() + ")";
    }

    public static enum OptInType {
        VERBAL("VERBAL"),
        WEB_FORM("WEB_FORM"),
        PAPER_FORM("PAPER_FORM"),
        VIA_TEXT("VIA_TEXT"),
        MOBILE_QR_CODE("MOBILE_QR_CODE");

        private final String value;

        private OptInType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static OptInType forValue(String value) {
            return (OptInType)Promoter.enumFromString((String)value, (Enum[])OptInType.values());
        }
    }
}

