/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.Trunk;

public class TrunkReader
extends Reader<Trunk> {
    private Integer pageSize;

    public TrunkReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Trunk> read(TwilioRestClient client) {
        return new ResourceSet<Trunk>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Trunk> firstPage(TwilioRestClient client) {
        String path = "/v1/Trunks";
        Request request = new Request(HttpMethod.GET, Domains.TRUNKING.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Trunk> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trunk read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("trunks", response.getContent(), Trunk.class, client.getObjectMapper());
    }

    @Override
    public Page<Trunk> previousPage(Page<Trunk> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TRUNKING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Trunk> nextPage(Page<Trunk> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUNKING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Trunk> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

