/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkersStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkersStatistics
extends Resource {
    private static final long serialVersionUID = 274987650256203L;
    private final Map<String, Object> realtime;
    private final Map<String, Object> cumulative;
    private final String accountSid;
    private final String workspaceSid;
    private final URI url;

    public static WorkersStatisticsFetcher fetcher(String pathWorkspaceSid) {
        return new WorkersStatisticsFetcher(pathWorkspaceSid);
    }

    public static WorkersStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkersStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkersStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkersStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkersStatistics(@JsonProperty(value="realtime") Map<String, Object> realtime, @JsonProperty(value="cumulative") Map<String, Object> cumulative, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.realtime = realtime;
        this.cumulative = cumulative;
        this.accountSid = accountSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final Map<String, Object> getRealtime() {
        return this.realtime;
    }

    public final Map<String, Object> getCumulative() {
        return this.cumulative;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkersStatistics other = (WorkersStatistics)o;
        return Objects.equals(this.realtime, other.realtime) && Objects.equals(this.cumulative, other.cumulative) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.realtime, this.cumulative, this.accountSid, this.workspaceSid, this.url);
    }

    public String toString() {
        return "WorkersStatistics(realtime=" + this.getRealtime() + ", cumulative=" + this.getCumulative() + ", accountSid=" + this.getAccountSid() + ", workspaceSid=" + this.getWorkspaceSid() + ", url=" + this.getUrl() + ")";
    }
}

