/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkerChannel;

public class WorkerChannelFetcher
extends Fetcher<WorkerChannel> {
    private String pathWorkspaceSid;
    private String pathWorkerSid;
    private String pathSid;

    public WorkerChannelFetcher(String pathWorkspaceSid, String pathWorkerSid, String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathWorkerSid = pathWorkerSid;
        this.pathSid = pathSid;
    }

    @Override
    public WorkerChannel fetch(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/Workers/{WorkerSid}/Channels/{Sid}";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        path = path.replace("{WorkerSid}", this.pathWorkerSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WorkerChannel fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return WorkerChannel.fromJson(response.getStream(), client.getObjectMapper());
    }
}

