/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.taskqueue.TaskQueuesStatisticsReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskQueuesStatistics
extends Resource {
    private static final long serialVersionUID = 167349245476595L;
    private final String accountSid;
    private final Map<String, Object> cumulative;
    private final Map<String, Object> realtime;
    private final String taskQueueSid;
    private final String workspaceSid;

    public static TaskQueuesStatisticsReader reader(String pathWorkspaceSid) {
        return new TaskQueuesStatisticsReader(pathWorkspaceSid);
    }

    public static TaskQueuesStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TaskQueuesStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskQueuesStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TaskQueuesStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskQueuesStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="cumulative") Map<String, Object> cumulative, @JsonProperty(value="realtime") Map<String, Object> realtime, @JsonProperty(value="task_queue_sid") String taskQueueSid, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.accountSid = accountSid;
        this.cumulative = cumulative;
        this.realtime = realtime;
        this.taskQueueSid = taskQueueSid;
        this.workspaceSid = workspaceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getCumulative() {
        return this.cumulative;
    }

    public final Map<String, Object> getRealtime() {
        return this.realtime;
    }

    public final String getTaskQueueSid() {
        return this.taskQueueSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQueuesStatistics other = (TaskQueuesStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.cumulative, other.cumulative) && Objects.equals(this.realtime, other.realtime) && Objects.equals(this.taskQueueSid, other.taskQueueSid) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.cumulative, this.realtime, this.taskQueueSid, this.workspaceSid);
    }

    public String toString() {
        return "TaskQueuesStatistics(accountSid=" + this.getAccountSid() + ", cumulative=" + this.getCumulative() + ", realtime=" + this.getRealtime() + ", taskQueueSid=" + this.getTaskQueueSid() + ", workspaceSid=" + this.getWorkspaceSid() + ")";
    }
}

