/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Task;

public class TaskFetcher
extends Fetcher<Task> {
    private String pathWorkspaceSid;
    private String pathSid;

    public TaskFetcher(String pathWorkspaceSid, String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathSid = pathSid;
    }

    @Override
    public Task fetch(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/Tasks/{Sid}";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }
}

